/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import com.tencent.b.a.g;
import com.tencent.utils.Util;
import java.security.MessageDigest;
import java.util.List;

public class SystemUtils {
    public static final String QQ_VERSION_NAME_4_1_0 = "4.1.0";
    public static final String QQ_VERSION_NAME_4_2_0 = "4.2.0";
    public static final String QQ_VERSION_NAME_4_3_0 = "4.3.0";
    public static final String QQ_VERSION_NAME_4_5_0 = "4.5.0";
    public static final String QQ_VERSION_NAME_4_6_0 = "4.6.0";
    public static final String QQ_SHARE_CALLBACK_ACTION = "shareToQQ";
    public static final String QZONE_SHARE_CALLBACK_ACTION = "shareToQzone";

    public static String getAppVersionName(Context context, String string) {
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(string, 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static int compareVersion(String string, String string2) {
        if (string == null && string2 == null) {
            return 0;
        }
        if (string != null && string2 == null) {
            return 1;
        }
        if (string == null && string2 != null) {
            return -1;
        }
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        try {
            int n2;
            for (n2 = 0; n2 < stringArray.length && n2 < stringArray2.length; ++n2) {
                int n3;
                int n4 = Integer.parseInt(stringArray[n2]);
                if (n4 < (n3 = Integer.parseInt(stringArray2[n2]))) {
                    return -1;
                }
                if (n4 <= n3) continue;
                return 1;
            }
            if (stringArray.length > n2) {
                return 1;
            }
            if (stringArray2.length > n2) {
                return -1;
            }
            return 0;
        }
        catch (NumberFormatException numberFormatException) {
            return string.compareTo(string2);
        }
    }

    public static boolean isAppSignatureValid(Context context, String string, String string2) {
        PackageInfo packageInfo;
        g.a("openSDK_LOG", "OpenUi, validateAppSignatureForPackage");
        try {
            packageInfo = context.getPackageManager().getPackageInfo(string, 64);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
        for (Signature signature : packageInfo.signatures) {
            String string3 = Util.encrypt(signature.toCharsString());
            if (!string3.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static String getAppSignatureMD5(Context context, String string) {
        g.a("openSDK_LOG", "OpenUi, getSignValidString");
        String string2 = "";
        try {
            String string3 = context.getPackageName();
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(string3, 64);
            Signature[] signatureArray = packageInfo.signatures;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(signatureArray[0].toByteArray());
            String string4 = Util.toHexString(messageDigest.digest());
            messageDigest.reset();
            String string5 = string3 + "_" + string4 + "_" + string + "";
            messageDigest.update(string5.getBytes());
            string2 = Util.toHexString(messageDigest.digest());
            messageDigest.reset();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            g.a("openSDK_LOG", "OpenUi, getSignValidString error", exception);
        }
        return string2;
    }

    public static boolean isActivityExist(Context context, Intent intent) {
        if (context == null || intent == null) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentActivities(intent, 0);
        return list.size() != 0;
    }

    public static String getRealPathFromUri(Activity activity, Uri uri) {
        String[] stringArray = new String[]{"_data"};
        Cursor cursor = activity.managedQuery(uri, stringArray, null, null, null);
        if (cursor != null) {
            int n2 = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            return cursor.getString(n2);
        }
        return null;
    }

    public static String getAppName(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        return applicationInfo.loadLabel(context.getPackageManager()).toString();
    }

    public static int compareQQVersion(Context context, String string) {
        String string2 = SystemUtils.getAppVersionName(context, "com.tencent.mobileqq");
        return SystemUtils.compareVersion(string2, string);
    }

    public static boolean checkMobileQQ(Context context) {
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packageInfo = null;
        try {
            packageInfo = packageManager.getPackageInfo("com.tencent.mobileqq", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.d((String)"checkMobileQQ", (String)"error");
            nameNotFoundException.printStackTrace();
        }
        if (packageInfo != null) {
            String string = packageInfo.versionName;
            try {
                Log.d((String)"MobileQQ verson", (String)string);
                String[] stringArray = string.split("\\.");
                int n2 = Integer.parseInt(stringArray[0]);
                int n3 = Integer.parseInt(stringArray[1]);
                return n2 > 4 || n2 == 4 && n3 >= 1;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        return false;
    }
}

