/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.weiyun;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.tencent.connect.auth.QQAuth;
import com.tencent.connect.auth.QQToken;
import com.tencent.connect.common.BaseApi;
import com.tencent.tauth.IUiListener;
import com.tencent.tauth.UiError;
import com.tencent.utils.DataConvert;
import com.tencent.utils.HttpUtils;
import com.tencent.weiyun.IDownLoadFileCallBack;
import com.tencent.weiyun.IGetFileListListener;
import com.tencent.weiyun.IUploadFileCallBack;
import com.tencent.weiyun.WeiyunFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FileManager
extends BaseApi {
    private static final String[] a = new String[]{"https://graph.qq.com/weiyun/get_photo_list", "https://graph.qq.com/weiyun/get_music_list", "https://graph.qq.com/weiyun/get_video_list"};
    private static final String[] b = new String[]{"https://graph.qq.com/weiyun/delete_photo", "https://graph.qq.com/weiyun/delete_music", "https://graph.qq.com/weiyun/delete_video"};

    public FileManager(Context context, QQAuth qQAuth, QQToken qQToken) {
        super(context, qQAuth, qQToken);
    }

    public FileManager(Context context, QQToken qQToken) {
        super(context, qQToken);
    }

    public void getFileList(WeiyunFileType weiyunFileType, IGetFileListListener iGetFileListListener) {
        String string = a[weiyunFileType.value()];
        Bundle bundle = this.composeCGIParams();
        bundle.putString("offset", "0");
        bundle.putString("number", "100");
        GetFileListListener getFileListListener = new GetFileListListener(iGetFileListListener);
        BaseApi.TempRequestListener tempRequestListener = new BaseApi.TempRequestListener(getFileListListener);
        HttpUtils.requestAsync(this.mToken, this.mContext, string, bundle, "GET", tempRequestListener);
    }

    public void deleteFile(WeiyunFileType weiyunFileType, String string, IUiListener iUiListener) {
        String string2 = b[weiyunFileType.value()];
        Bundle bundle = this.composeCGIParams();
        bundle.putString("file_id", string);
        BaseApi.TempRequestListener tempRequestListener = new BaseApi.TempRequestListener(iUiListener);
        HttpUtils.requestAsync(this.mToken, this.mContext, string2, bundle, "GET", tempRequestListener);
    }

    public void downLoadFile(WeiyunFileType weiyunFileType, WeiyunFile weiyunFile, String string, IDownLoadFileCallBack iDownLoadFileCallBack) {
        new DownLoadImp(this.mContext, weiyunFileType, weiyunFile, string, iDownLoadFileCallBack).start();
    }

    public void downLoadThumb(WeiyunFile weiyunFile, String string, String string2, IDownLoadFileCallBack iDownLoadFileCallBack) {
        DownLoadImp downLoadImp = new DownLoadImp(this.mContext, WeiyunFileType.ImageFile, weiyunFile, string, iDownLoadFileCallBack);
        downLoadImp.setThumbSize(string2);
        downLoadImp.start();
    }

    public void uploadFile(WeiyunFileType weiyunFileType, String string, IUploadFileCallBack iUploadFileCallBack) {
        new UploadFileImp(this.mContext, weiyunFileType, string, iUploadFileCallBack).start();
    }

    private class DownLoadImp {
        private static final String DOWNLOAD_PIC_URL = "https://graph.qq.com/weiyun/download_photo";
        private static final String DOWNLOAD_THUMB_URL = "https://graph.qq.com/weiyun/get_photo_thumb";
        private static final String DOWNLOAD_MUSIC_URL = "https://graph.qq.com/weiyun/download_music";
        private static final String DOWNLOAD_VIDEO_URL = "https://graph.qq.com/weiyun/download_video";
        private static final String DOWNLOAD_ENCRYPT_URL = "dl_encrypt_url";
        private static final String DOWNLOAD_COOKIE_NAME = "dl_cookie_name";
        private static final String DOWNLOAD_COOKIE_VALUE = "dl_cookie_value";
        private static final String DOWNLOAD_SERVER_HOST = "dl_svr_host";
        private static final String DOWNLOAD_SERVER_PORT = "dl_svr_port";
        private static final String DOWNLOAD_THUMB_SIZE = "dl_thumb_size";
        private static final int MAX_ERROR_TIMES = 10;
        private static final int GET_PERMISSON_DOWN = 0;
        private static final int DOWNLOAD_PROGRESS = 1;
        private static final int DOWNLOAD_PROGRESS_DONE = 2;
        private Context mContext;
        private WeiyunFileType mFileType;
        private WeiyunFile mWeiyunFile;
        private String mSavePath;
        private IDownLoadFileCallBack mCallback;
        private Handler mHandler;
        private File mFile;
        private String mDownloadEncryptUrl;
        private String mDownloadCookieName;
        private String mDownloadCookieValue;
        private String mDownloadServerHost;
        private int mDownloadServerPort;
        private String mDownloadThumbSize;
        private String mThumbSize;

        public DownLoadImp(Context context, WeiyunFileType weiyunFileType, WeiyunFile weiyunFile, String string, IDownLoadFileCallBack iDownLoadFileCallBack) {
            this.mContext = context;
            this.mFileType = weiyunFileType;
            this.mWeiyunFile = weiyunFile;
            this.mSavePath = string;
            this.mCallback = iDownLoadFileCallBack;
            this.mHandler = new Handler(this.mContext.getMainLooper()){

                public void handleMessage(Message message) {
                    switch (message.what) {
                        case 0: {
                            JSONObject jSONObject = (JSONObject)message.obj;
                            try {
                                int n2 = jSONObject.getInt("ret");
                                if (n2 != 0) {
                                    DownLoadImp.this.mCallback.onError(new UiError(n2, jSONObject.toString(), null));
                                    return;
                                }
                                JSONObject jSONObject2 = jSONObject.getJSONObject("data");
                                DownLoadImp.this.mDownloadEncryptUrl = jSONObject2.getString(DownLoadImp.DOWNLOAD_ENCRYPT_URL);
                                DownLoadImp.this.mDownloadCookieName = jSONObject2.getString(DownLoadImp.DOWNLOAD_COOKIE_NAME);
                                DownLoadImp.this.mDownloadCookieValue = jSONObject2.getString(DownLoadImp.DOWNLOAD_COOKIE_VALUE);
                                DownLoadImp.this.mDownloadServerPort = jSONObject2.getInt(DownLoadImp.DOWNLOAD_SERVER_PORT);
                                DownLoadImp.this.mDownloadServerHost = jSONObject2.getString(DownLoadImp.DOWNLOAD_SERVER_HOST);
                                if (jSONObject2.has(DownLoadImp.DOWNLOAD_THUMB_SIZE)) {
                                    DownLoadImp.this.mDownloadThumbSize = jSONObject2.getString(DownLoadImp.DOWNLOAD_THUMB_SIZE);
                                }
                            }
                            catch (JSONException jSONException) {
                                DownLoadImp.this.mCallback.onError(new UiError(-4, jSONException.getMessage(), null));
                                return;
                            }
                            DownLoadImp.this.mCallback.onDownloadStart();
                            DownLoadImp.this.doDownload();
                            break;
                        }
                        case 1: {
                            String string = (String)message.obj;
                            int n3 = Integer.parseInt(string);
                            DownLoadImp.this.mCallback.onDownloadProgress(n3);
                            break;
                        }
                        case 2: {
                            DownLoadImp.this.mCallback.onDownloadSuccess(DownLoadImp.this.mSavePath);
                            break;
                        }
                        default: {
                            DownLoadImp.this.mCallback.onError(new UiError(message.what, (String)message.obj, null));
                        }
                    }
                }
            };
        }

        public void setThumbSize(String string) {
            this.mThumbSize = string;
        }

        public void start() {
            if (this.mSavePath == null || this.mFileType == null || this.mWeiyunFile == null || this.mWeiyunFile.getFileId() == null) {
                Message message = this.mHandler.obtainMessage();
                message.what = -5;
                message.obj = new String("");
                this.mHandler.sendMessage(message);
                return;
            }
            this.mFile = new File(this.mSavePath);
            if (this.mFile.exists()) {
                Message message = this.mHandler.obtainMessage();
                message.what = -11;
                message.obj = new String("");
                this.mHandler.sendMessage(message);
                return;
            }
            this.mCallback.onPrepareStart();
            this.getDownloadPermission();
        }

        private String getDownloadUrl(WeiyunFileType weiyunFileType) {
            if (weiyunFileType == WeiyunFileType.ImageFile) {
                if (this.mThumbSize != null) {
                    return DOWNLOAD_THUMB_URL;
                }
                return DOWNLOAD_PIC_URL;
            }
            if (weiyunFileType == WeiyunFileType.MusicFile) {
                return DOWNLOAD_MUSIC_URL;
            }
            if (weiyunFileType == WeiyunFileType.VideoFile) {
                return DOWNLOAD_VIDEO_URL;
            }
            return DOWNLOAD_PIC_URL;
        }

        private void getDownloadPermission() {
            new Thread(){

                @Override
                public void run() {
                    Bundle bundle = FileManager.this.composeCGIParams();
                    bundle.putString("file_id", DownLoadImp.this.mWeiyunFile.getFileId());
                    if (!TextUtils.isEmpty((CharSequence)DownLoadImp.this.mThumbSize)) {
                        bundle.putString("thumb", DownLoadImp.this.mThumbSize);
                    }
                    JSONObject jSONObject = null;
                    try {
                        jSONObject = HttpUtils.request(FileManager.this.mToken, DownLoadImp.this.mContext, DownLoadImp.this.getDownloadUrl(DownLoadImp.this.mFileType), bundle, "GET");
                        Message message = DownLoadImp.this.mHandler.obtainMessage();
                        message.what = 0;
                        message.obj = jSONObject;
                        DownLoadImp.this.mHandler.sendMessage(message);
                    }
                    catch (MalformedURLException malformedURLException) {
                        Message message = DownLoadImp.this.mHandler.obtainMessage();
                        message.what = -3;
                        message.obj = malformedURLException.getMessage();
                        DownLoadImp.this.mHandler.sendMessage(message);
                    }
                    catch (IOException iOException) {
                        Message message = DownLoadImp.this.mHandler.obtainMessage();
                        message.obj = iOException.getMessage();
                        message.what = -2;
                        DownLoadImp.this.mHandler.sendMessage(message);
                    }
                    catch (JSONException jSONException) {
                        Message message = DownLoadImp.this.mHandler.obtainMessage();
                        message.obj = jSONException.getMessage();
                        message.what = -4;
                        DownLoadImp.this.mHandler.sendMessage(message);
                    }
                    catch (HttpUtils.NetworkUnavailableException networkUnavailableException) {
                        Message message = DownLoadImp.this.mHandler.obtainMessage();
                        message.obj = networkUnavailableException.getMessage();
                        message.what = -10;
                        DownLoadImp.this.mHandler.sendMessage(message);
                    }
                    catch (HttpUtils.HttpStatusException httpStatusException) {
                        Message message = DownLoadImp.this.mHandler.obtainMessage();
                        message.obj = httpStatusException.getMessage();
                        message.what = -9;
                        DownLoadImp.this.mHandler.sendMessage(message);
                    }
                }
            }.start();
        }

        private void doDownload() {
            new Thread(){

                /*
                 * Unable to fully structure code
                 */
                @Override
                public void run() {
                    block17: {
                        var1_1 = new BasicHttpParams();
                        HttpConnectionParams.setConnectionTimeout((HttpParams)var1_1, (int)15000);
                        HttpConnectionParams.setSoTimeout((HttpParams)var1_1, (int)20000);
                        HttpProtocolParams.setVersion((HttpParams)var1_1, (ProtocolVersion)HttpVersion.HTTP_1_1);
                        HttpProtocolParams.setContentCharset((HttpParams)var1_1, (String)"UTF-8");
                        HttpProtocolParams.setUserAgent((HttpParams)var1_1, (String)"TX_QQF_ANDROID");
                        var2_2 = "http://" + DownLoadImp.access$2000(DownLoadImp.this) + ":" + DownLoadImp.access$1900(DownLoadImp.this) + "/ftn_handler/" + DownLoadImp.access$1600(DownLoadImp.this) + "/";
                        if (!TextUtils.isEmpty((CharSequence)DownLoadImp.access$2100(DownLoadImp.this))) {
                            var2_2 = var2_2 + "?size=" + DownLoadImp.access$2100(DownLoadImp.this);
                        }
                        var3_3 = new DefaultHttpClient((HttpParams)var1_1);
                        var4_4 = null;
                        var5_5 = new File(DownLoadImp.access$2300(DownLoadImp.this));
                        try {
                            var6_6 = new FileOutputStream(var5_5);
                        }
                        catch (FileNotFoundException var7_7) {
                            var8_9 = DownLoadImp.access$3100(DownLoadImp.this).obtainMessage();
                            var8_9.what = -2;
                            var8_9.obj = var7_7.getMessage();
                            DownLoadImp.access$3100(DownLoadImp.this).sendMessage(var8_9);
                            return;
                        }
                        var7_8 = new byte[262144];
                        var8_10 = 0L;
                        var12_11 = 0L;
                        var14_12 = 0;
                        if (TextUtils.isEmpty((CharSequence)DownLoadImp.access$2600(DownLoadImp.this))) {
                            var10_13 = DownLoadImp.access$2500(DownLoadImp.this).getFileSize() > 262144L ? 262144L : DownLoadImp.access$2500(DownLoadImp.this).getFileSize();
                            var12_11 = var8_10 + var10_13;
                            while (var12_11 <= DownLoadImp.access$2500(DownLoadImp.this).getFileSize()) {
                                block18: {
                                    var15_14 = new HttpGet(var2_2);
                                    var15_14.addHeader("Accept-Encoding", "gzip");
                                    var15_14.addHeader("Host", DownLoadImp.access$2000(DownLoadImp.this));
                                    var15_14.addHeader("Connection", "Keep-Alive");
                                    var15_14.addHeader("Cookie", DownLoadImp.access$1700(DownLoadImp.this) + "=" + DownLoadImp.access$1800(DownLoadImp.this));
                                    var15_14.addHeader("Pragma", "no-cache");
                                    var15_14.addHeader("RANGE", "bytes=" + var8_10 + "-" + var12_11 + "");
                                    var16_16 = 0;
                                    try {
                                        var17_18 = var3_3.execute((HttpUriRequest)var15_14);
                                        Log.i((String)"weiyun_test", (String)("uploadFileToWeiyun doDownloadPic response:" + var17_18.toString()));
                                        var18_22 = var17_18.getStatusLine();
                                        var16_16 = var18_22.getStatusCode();
                                        if (var16_16 != 200 && var16_16 != 206) break block17;
                                        var4_4 = var17_18.getEntity().getContent();
                                        var19_25 = 0;
                                        while ((var19_25 = var4_4.read(var7_8)) > 0) {
                                            var6_6.write(var7_8, 0, var19_25);
                                            var8_10 += (long)var19_25;
                                        }
                                    }
                                    catch (Exception var17_19) {
                                        if (++var14_12 <= 10) break block18;
                                        var17_19.printStackTrace();
                                        Log.e((String)"weiyun_test", (String)("uploadFileToWeiyun doDownloadPic error:" + var17_19.getMessage() + ""));
                                        var18_22 = DownLoadImp.access$3100(DownLoadImp.this).obtainMessage();
                                        var18_22.what = -2;
                                        var18_22.obj = var17_19.getMessage();
                                        DownLoadImp.access$3100(DownLoadImp.this).sendMessage((Message)var18_22);
                                        break;
                                    }
                                }
                                if (DownLoadImp.access$2500(DownLoadImp.this).getFileSize() - var12_11 > 0L) {
                                    var12_11 = var8_10;
                                    var10_13 = DownLoadImp.access$2500(DownLoadImp.this).getFileSize() - var12_11 > 262144L ? 262144L : DownLoadImp.access$2500(DownLoadImp.this).getFileSize() - var12_11;
                                    var17_18 = DownLoadImp.access$3100(DownLoadImp.this).obtainMessage();
                                    var17_18.what = 1;
                                    var17_18.obj = (var12_11 += var10_13) * 100L / DownLoadImp.access$2500(DownLoadImp.this).getFileSize() + "";
                                    DownLoadImp.access$3100(DownLoadImp.this).sendMessage((Message)var17_18);
                                    continue;
                                }
                                break;
                            }
                        } else {
                            var15_14 = new HttpGet(var2_2);
                            var15_14.addHeader("Accept-Encoding", "gzip");
                            var15_14.addHeader("Host", DownLoadImp.access$2000(DownLoadImp.this));
                            var15_14.addHeader("Connection", "Keep-Alive");
                            var15_14.addHeader("Cookie", DownLoadImp.access$1700(DownLoadImp.this) + "=" + DownLoadImp.access$1800(DownLoadImp.this) + "");
                            var15_14.addHeader("Pragma", "no-cache");
                            var16_16 = 0;
                            try {
                                var17_20 = var3_3.execute((HttpUriRequest)var15_14);
                                Log.i((String)"weiyun_test", (String)("uploadFileToWeiyun doDownloadPic response:" + var17_20.toString()));
                                var18_23 = var17_20.getStatusLine();
                                var16_16 = var18_23.getStatusCode();
                                if (var16_16 != 200 && var16_16 != 206) ** GOTO lbl112
                                var4_4 = var17_20.getEntity().getContent();
                                var19_26 = 0;
                                while ((var19_26 = var4_4.read(var7_8)) > 0) {
                                    var6_6.write(var7_8, 0, var19_26);
                                }
                            }
                            catch (Exception var17_21) {
                                var17_21.printStackTrace();
                                Log.e((String)"weiyun_test", (String)("uploadFileToWeiyun doDownloadPic error:" + var17_21.getMessage() + ""));
                                var18_24 = DownLoadImp.access$3100(DownLoadImp.this).obtainMessage();
                                var18_24.what = -2;
                                var18_24.obj = var17_21.getMessage();
                                DownLoadImp.access$3100(DownLoadImp.this).sendMessage(var18_24);
                                try {
                                    var6_6.close();
                                    var4_4.close();
                                }
                                catch (IOException var19_27) {
                                    // empty catch block
                                }
                                return;
                            }
                        }
                    }
                    try {
                        var6_6.close();
                        var4_4.close();
                    }
                    catch (IOException var15_15) {
                        var16_17 = DownLoadImp.access$3100(DownLoadImp.this).obtainMessage();
                        var16_17.what = -2;
                        var16_17.obj = var15_15.getMessage();
                        DownLoadImp.access$3100(DownLoadImp.this).sendMessage(var16_17);
                        return;
                    }
                    var15_14 = DownLoadImp.access$3100(DownLoadImp.this).obtainMessage();
                    var15_14.what = 2;
                    DownLoadImp.access$3100(DownLoadImp.this).sendMessage((Message)var15_14);
                }
            }.start();
        }

        static /* synthetic */ String access$2000(DownLoadImp downLoadImp) {
            return downLoadImp.mDownloadServerHost;
        }

        static /* synthetic */ int access$1900(DownLoadImp downLoadImp) {
            return downLoadImp.mDownloadServerPort;
        }

        static /* synthetic */ String access$1600(DownLoadImp downLoadImp) {
            return downLoadImp.mDownloadEncryptUrl;
        }

        static /* synthetic */ String access$2100(DownLoadImp downLoadImp) {
            return downLoadImp.mDownloadThumbSize;
        }

        static /* synthetic */ String access$1700(DownLoadImp downLoadImp) {
            return downLoadImp.mDownloadCookieName;
        }

        static /* synthetic */ String access$1800(DownLoadImp downLoadImp) {
            return downLoadImp.mDownloadCookieValue;
        }
    }

    private class UploadFileImp {
        private static final String UPLOAD_IMAGE_URL = "https://graph.qq.com/weiyun/upload_photo";
        private static final String UPLOAD_MUSIC_URL = "https://graph.qq.com/weiyun/upload_music";
        private static final String UPLOAD_VIDEO_URL = "https://graph.qq.com/weiyun/upload_video";
        private static final int GET_PERMISSON_DONE = 0;
        private static final int UPLOAD_PROGRESS = 1;
        private static final int UPLOAD_PROGRESS_DONE = 2;
        private final Context mContext;
        private final WeiyunFileType mFileType;
        private final String mFilePath;
        private final IUploadFileCallBack mCallback;
        private final Handler mHandler;
        private long mFileSize;
        private String mFileKey;
        private String mMD5Hash;
        private byte[] mUKey;
        private String mHost;

        public UploadFileImp(Context context, WeiyunFileType weiyunFileType, String string, IUploadFileCallBack iUploadFileCallBack) {
            this.mContext = context;
            this.mFileType = weiyunFileType;
            this.mFilePath = string;
            this.mCallback = iUploadFileCallBack;
            this.mHandler = new Handler(this.mContext.getMainLooper()){

                public void handleMessage(Message message) {
                    switch (message.what) {
                        case 0: {
                            JSONObject jSONObject = (JSONObject)message.obj;
                            try {
                                int n2 = jSONObject.getInt("ret");
                                if (n2 != 0) {
                                    UploadFileImp.this.mCallback.onError(new UiError(n2, jSONObject.toString(), null));
                                    break;
                                }
                                JSONObject jSONObject2 = jSONObject.getJSONObject("data");
                                String string = jSONObject2.getString("csum");
                                UploadFileImp.access$102(UploadFileImp.this, DataConvert.string2bytes(string));
                                UploadFileImp.this.mHost = jSONObject2.getString("host");
                            }
                            catch (Exception exception) {
                                UploadFileImp.this.mCallback.onError(new UiError(-4, exception.getMessage(), null));
                                return;
                            }
                            UploadFileImp.this.mCallback.onUploadStart();
                            UploadFileImp.this.doUpload();
                            break;
                        }
                        case 1: {
                            String string = (String)message.obj;
                            int n3 = Integer.parseInt(string);
                            UploadFileImp.this.mCallback.onUploadProgress(n3);
                            break;
                        }
                        case 2: {
                            UploadFileImp.this.mCallback.onUploadSuccess();
                            break;
                        }
                        default: {
                            UploadFileImp.this.mCallback.onError(new UiError(message.what, (String)message.obj, null));
                        }
                    }
                }
            };
        }

        public void start() {
            Object object;
            MessageDigest messageDigest;
            if (this.mFilePath == null || !new File(this.mFilePath).exists()) {
                Message message = this.mHandler.obtainMessage();
                message.what = -5;
                message.obj = new String("");
                this.mHandler.sendMessage(message);
                return;
            }
            this.mCallback.onPrepareStart();
            File file = new File(this.mFilePath);
            this.mFileSize = file.length();
            FileInputStream fileInputStream = null;
            DigestInputStream digestInputStream = null;
            int n2 = 524288;
            try {
                messageDigest = MessageDigest.getInstance("SHA-1");
                fileInputStream = new FileInputStream(file);
                digestInputStream = new DigestInputStream(fileInputStream, messageDigest);
                object = new byte[n2];
                while (digestInputStream.read((byte[])object) > 0) {
                }
                messageDigest = digestInputStream.getMessageDigest();
                byte[] byArray = messageDigest.digest();
                this.mFileKey = DataConvert.toHexString(byArray);
                messageDigest.reset();
                fileInputStream.close();
                digestInputStream.close();
            }
            catch (Exception exception) {
                Message message = this.mHandler.obtainMessage();
                message.what = -2;
                message.obj = new String("");
                this.mHandler.sendMessage(message);
                return;
            }
            fileInputStream = null;
            digestInputStream = null;
            try {
                messageDigest = MessageDigest.getInstance("MD5");
                fileInputStream = new FileInputStream(file);
                digestInputStream = new DigestInputStream(fileInputStream, messageDigest);
                object = new byte[n2];
                while (digestInputStream.read((byte[])object) > 0) {
                }
                messageDigest = digestInputStream.getMessageDigest();
                this.mMD5Hash = DataConvert.toHexString(messageDigest.digest());
                messageDigest.reset();
                fileInputStream.close();
                digestInputStream.close();
            }
            catch (Exception exception) {
                object = this.mHandler.obtainMessage();
                object.what = -2;
                object.obj = new String("");
                this.mHandler.sendMessage((Message)object);
                return;
            }
            this.getUploadPermission();
        }

        private String getRequestUrl(WeiyunFileType weiyunFileType) {
            if (weiyunFileType == WeiyunFileType.ImageFile) {
                return UPLOAD_IMAGE_URL;
            }
            if (weiyunFileType == WeiyunFileType.MusicFile) {
                return UPLOAD_MUSIC_URL;
            }
            return UPLOAD_VIDEO_URL;
        }

        private void getUploadPermission() {
            new Thread(){

                @Override
                public void run() {
                    Uri uri = Uri.parse((String)UploadFileImp.this.mFilePath);
                    String string = SystemClock.elapsedRealtime() + "__" + uri.getLastPathSegment();
                    String string2 = "control";
                    Bundle bundle = FileManager.this.composeCGIParams();
                    bundle.putString("sha", UploadFileImp.this.mFileKey);
                    bundle.putString("md5", UploadFileImp.this.mMD5Hash);
                    bundle.putString("size", UploadFileImp.this.mFileSize + "");
                    bundle.putString("name", string);
                    bundle.putString("upload_type", string2);
                    JSONObject jSONObject = null;
                    try {
                        jSONObject = HttpUtils.request(FileManager.this.mToken, UploadFileImp.this.mContext, UploadFileImp.this.getRequestUrl(UploadFileImp.this.mFileType), bundle, "GET");
                        Message message = UploadFileImp.this.mHandler.obtainMessage();
                        message.what = 0;
                        message.obj = jSONObject;
                        UploadFileImp.this.mHandler.sendMessage(message);
                    }
                    catch (MalformedURLException malformedURLException) {
                        Message message = UploadFileImp.this.mHandler.obtainMessage();
                        message.what = -3;
                        message.obj = malformedURLException.getMessage();
                        UploadFileImp.this.mHandler.sendMessage(message);
                    }
                    catch (IOException iOException) {
                        Message message = UploadFileImp.this.mHandler.obtainMessage();
                        message.obj = iOException.getMessage();
                        message.what = -2;
                        UploadFileImp.this.mHandler.sendMessage(message);
                    }
                    catch (JSONException jSONException) {
                        Message message = UploadFileImp.this.mHandler.obtainMessage();
                        message.obj = jSONException.getMessage();
                        message.what = -4;
                        UploadFileImp.this.mHandler.sendMessage(message);
                    }
                    catch (HttpUtils.NetworkUnavailableException networkUnavailableException) {
                        Message message = UploadFileImp.this.mHandler.obtainMessage();
                        message.obj = networkUnavailableException.getMessage();
                        message.what = -10;
                        UploadFileImp.this.mHandler.sendMessage(message);
                    }
                    catch (HttpUtils.HttpStatusException httpStatusException) {
                        Message message = UploadFileImp.this.mHandler.obtainMessage();
                        message.obj = httpStatusException.getMessage();
                        message.what = -9;
                        UploadFileImp.this.mHandler.sendMessage(message);
                    }
                }
            }.start();
        }

        private void doUpload() {
            new Thread(){

                @Override
                public void run() {
                    Message message;
                    BasicHttpParams basicHttpParams = new BasicHttpParams();
                    HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)15000);
                    HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)20000);
                    HttpProtocolParams.setVersion((HttpParams)basicHttpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
                    HttpProtocolParams.setContentCharset((HttpParams)basicHttpParams, (String)"UTF-8");
                    HttpProtocolParams.setUserAgent((HttpParams)basicHttpParams, (String)"TX_QQF_ANDROID");
                    DefaultHttpClient defaultHttpClient = new DefaultHttpClient((HttpParams)basicHttpParams);
                    HttpPost httpPost = null;
                    HttpPost httpPost2 = null;
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = 131072;
                    byte[] byArray = new byte[n4];
                    FileInputStream fileInputStream = null;
                    try {
                        fileInputStream = new FileInputStream(UploadFileImp.this.mFilePath);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Message message2 = UploadFileImp.this.mHandler.obtainMessage();
                        message2.what = -2;
                        message2.obj = "";
                        UploadFileImp.this.mHandler.sendMessage(message2);
                        return;
                    }
                    while ((long)n2 < UploadFileImp.this.mFileSize) {
                        StatusLine statusLine;
                        HttpResponse httpResponse;
                        byte[] byArray2;
                        try {
                            n3 = fileInputStream.read(byArray);
                            byArray2 = UploadFileImp.this.packPostBody(byArray, n3, n2);
                            n2 += n3;
                        }
                        catch (IOException iOException) {
                            message = UploadFileImp.this.mHandler.obtainMessage();
                            message.what = -2;
                            message.obj = "";
                            UploadFileImp.this.mHandler.sendMessage(message);
                            break;
                        }
                        if (byArray2 == null) break;
                        httpPost = new HttpPost("http://" + UploadFileImp.this.mHost + "/ftn_handler/?bmd5=" + UploadFileImp.this.mMD5Hash);
                        httpPost.addHeader("Accept-Encoding", "*/*");
                        httpPost.setHeader("Connection", "Keep-Alive");
                        httpPost.setHeader("Pragma", "no-cache");
                        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
                        ByteArrayEntity byteArrayEntity = new ByteArrayEntity(byArray2);
                        httpPost.setEntity((HttpEntity)byteArrayEntity);
                        httpPost2 = httpPost;
                        int n5 = 0;
                        try {
                            httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost2);
                            statusLine = httpResponse.getStatusLine();
                            n5 = statusLine.getStatusCode();
                        }
                        catch (IOException iOException) {
                            statusLine = UploadFileImp.this.mHandler.obtainMessage();
                            statusLine.what = -2;
                            statusLine.obj = "";
                            UploadFileImp.this.mHandler.sendMessage((Message)statusLine);
                        }
                        if (n5 == 200) {
                            if ((long)n2 < UploadFileImp.this.mFileSize) {
                                int n6 = (int)((long)n2 * 100L / UploadFileImp.this.mFileSize);
                                statusLine = UploadFileImp.this.mHandler.obtainMessage();
                                statusLine.what = 1;
                                statusLine.obj = n6 + "";
                                UploadFileImp.this.mHandler.sendMessage((Message)statusLine);
                                continue;
                            }
                            httpResponse = UploadFileImp.this.mHandler.obtainMessage();
                            httpResponse.what = 2;
                            httpResponse.obj = "";
                            UploadFileImp.this.mHandler.sendMessage((Message)httpResponse);
                            continue;
                        }
                        httpResponse = UploadFileImp.this.mHandler.obtainMessage();
                        httpResponse.what = -9;
                        httpResponse.obj = "";
                        UploadFileImp.this.mHandler.sendMessage((Message)httpResponse);
                        break;
                    }
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        message = UploadFileImp.this.mHandler.obtainMessage();
                        message.what = -2;
                        message.obj = iOException.getMessage();
                        UploadFileImp.this.mHandler.sendMessage(message);
                        return;
                    }
                }
            }.start();
        }

        private byte[] packPostBody(byte[] byArray, int n2, int n3) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.update(byArray, 0, n2);
                this.mMD5Hash = DataConvert.toHexString(messageDigest.digest());
                messageDigest.reset();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Message message = this.mHandler.obtainMessage();
                message.what = -2;
                message.obj = noSuchAlgorithmException.getMessage();
                this.mHandler.sendMessage(message);
                return null;
            }
            int n4 = 340 + n2;
            int n5 = n4 + 4 + 4 + 4 + 4;
            byte[] byArray2 = new byte[n5];
            int n6 = 0;
            n6 += DataConvert.putInt2Bytes(-1412589450, byArray2, n6);
            n6 += DataConvert.putInt2Bytes(1000, byArray2, n6);
            n6 += DataConvert.putInt2Bytes(0, byArray2, n6);
            n6 += DataConvert.putInt2Bytes(n4, byArray2, n6);
            n6 += DataConvert.putShort2Bytes(304, byArray2, n6);
            n6 += DataConvert.putBytes2Bytes(this.mUKey, byArray2, n6);
            n6 += DataConvert.putShort2Bytes(20, byArray2, n6);
            n6 += DataConvert.putString2Bytes(this.mFileKey, byArray2, n6);
            n6 += DataConvert.putInt2Bytes((int)this.mFileSize, byArray2, n6);
            n6 += DataConvert.putInt2Bytes(n3, byArray2, n6);
            n6 += DataConvert.putInt2Bytes(n2, byArray2, n6);
            n6 += DataConvert.putBytes2Bytes(byArray, n2, byArray2, n6);
            return byArray2;
        }

        static /* synthetic */ byte[] access$102(UploadFileImp uploadFileImp, byte[] byArray) {
            uploadFileImp.mUKey = byArray;
            return byArray;
        }
    }

    private class GetFileListListener
    implements IUiListener {
        private IGetFileListListener mListener;

        public GetFileListListener(IGetFileListListener iGetFileListListener) {
            this.mListener = iGetFileListListener;
        }

        @Override
        public void onComplete(Object object) {
            JSONObject jSONObject = (JSONObject)object;
            try {
                ArrayList<WeiyunFile> arrayList = new ArrayList<WeiyunFile>();
                JSONObject jSONObject2 = jSONObject.getJSONObject("data");
                if (!jSONObject2.isNull("content")) {
                    JSONArray jSONArray = jSONObject2.getJSONArray("content");
                    for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                        JSONObject jSONObject3 = jSONArray.getJSONObject(i2);
                        WeiyunFile weiyunFile = new WeiyunFile(jSONObject3.getString("file_id"), jSONObject3.getString("file_name"), jSONObject3.getString("file_ctime"), jSONObject3.getInt("file_size"));
                        arrayList.add(weiyunFile);
                    }
                }
                this.mListener.onComplete(arrayList);
            }
            catch (JSONException jSONException) {
                this.mListener.onError(new UiError(-4, "\u670d\u52a1\u5668\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u6709\u8bef!", jSONObject.toString()));
            }
        }

        @Override
        public void onError(UiError uiError) {
            this.mListener.onError(uiError);
        }

        @Override
        public void onCancel() {
        }
    }

    public static enum WeiyunFileType {
        ImageFile(0),
        MusicFile(1),
        VideoFile(2);

        private final int mType;

        private WeiyunFileType(int n3) {
            this.mType = n3;
        }

        public int value() {
            return this.mType;
        }
    }
}

