package app.hanks.com.conquer.activity;

import android.app.ProgressDialog;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ImageButton;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.List;

import app.hanks.com.conquer.R;
import app.hanks.com.conquer.adapter.NearPeopleAdapter;
import app.hanks.com.conquer.bean.User;
import app.hanks.com.conquer.util.A;
import app.hanks.com.conquer.util.CollectionUtils;
import app.hanks.com.conquer.util.L;
import app.hanks.com.conquer.util.T;
import app.hanks.com.conquer.view.xlist.XListView;
import app.hanks.com.conquer.view.xlist.XListView.IXListViewListener;
import cn.bmob.im.task.BRequest;
import cn.bmob.v3.listener.CountListener;
import cn.bmob.v3.listener.FindListener;

/**
 * 附近的人列表
 * @ClassName: NewFriendActivity
 * @Description: TODO
 * @author smile
 * @date 2014-6-6 下午4:28:09
 */
public class NearPeopleActivity extends BaseActivity implements IXListViewListener, OnItemClickListener {

	XListView mListView;
	NearPeopleAdapter adapter;
	String from = "";

	List<User> nears = new ArrayList<User>();

	private double QUERY_KILOMETERS = 10;// 默认查询10公里范围内的人

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		initXListView();
	}

	private void initXListView() {
		mListView = (XListView) findViewById(R.id.list_near);
		mListView.setOnItemClickListener(this);
		// 首先不允许加载更多
		mListView.setPullLoadEnable(false);
		// 允许下拉
		mListView.setPullRefreshEnable(true);
		// 设置监听器
		mListView.setXListViewListener(this);
		//
		mListView.pullRefreshing();

		adapter = new NearPeopleAdapter(this, nears);
		mListView.setAdapter(adapter);
		initNearByList(false);
	}

	int curPage = 0;
	ProgressDialog progress;

	private void initNearByList(final boolean isUpdate) {
		if (!isUpdate) {
			progress = new ProgressDialog(NearPeopleActivity.this);
			progress.setMessage("正在查询附近的人...");
			progress.setCanceledOnTouchOutside(true);
			progress.show();
		}
		if ( mApplication.lastPoint.getLatitude()!=0 && mApplication.lastPoint.getLongitude()!=0) {
			double latitude = mApplication.lastPoint.getLatitude();
			double longtitude = mApplication.lastPoint.getLongitude();
			// 封装的查询方法，当进入此页面时 isUpdate为false，当下拉刷新的时候设置为true就行。
			// 此方法默认每页查询10条数据,若想查询多于10条，可在查询之前设置BRequest.QUERY_LIMIT_COUNT，如：BRequest.QUERY_LIMIT_COUNT=20

			// 此方法是新增的查询指定10公里内的性别为女性的用户列表，默认包含好友列表

			// 如果你不想查询性别为女的用户，可以将equalProperty设为null或者equalObj设为null即可
			BRequest.QUERY_LIMIT_COUNT = 30;
			userManager.queryKiloMetersListByPage(isUpdate, 0, "location", longtitude, latitude, true, QUERY_KILOMETERS, "sex", false,
					new FindListener<User>() {
						// 此方法默认查询所有带地理位置信息的且性别为女的用户列表，如果你不想包含好友列表的话，将查询条件中的isShowFriends设置为false就行
						// userManager.queryNearByListByPage(isUpdate,0,"location", longtitude, latitude,
						// true,"sex",false,new
						// FindListener<User>() {
						@Override
						public void onSuccess(List<User> arg0) {
							// TODO Auto-generated method stub
							if (CollectionUtils.isNotNull(arg0)) {
								if (isUpdate) {
									nears.clear();
								}
								adapter.addAll(arg0);
								if (arg0.size() < BRequest.QUERY_LIMIT_COUNT) {
									mListView.setPullLoadEnable(false);
									T.show(context, "附近的人搜索完成!");
								} else {
									mListView.setPullLoadEnable(true);
								}
							} else {
								T.show(context, "暂无附近的人!");
							}

							if (!isUpdate) {
								progress.dismiss();
							} else {
								refreshPull();
							}
						}

						@Override
						public void onError(int arg0, String arg1) {
							// TODO Auto-generated method stub
							T.show(context, "暂无附近的人!");
							mListView.setPullLoadEnable(false);
							if (!isUpdate) {
								progress.dismiss();
							} else {
								refreshPull();
							}
						}

					});
		} else {
			T.show(context, "暂无附近的人!");
			progress.dismiss();
		}

	}

	/**
	 * 查询更多
	 * @Title: queryMoreNearList
	 * @Description: TODO
	 * @param @param page
	 * @return void
	 * @throws
	 */
	private void queryMoreNearList(int page) {
		double latitude =  mApplication.lastPoint.getLatitude();
		double longtitude = mApplication.lastPoint.getLongitude();
		// 查询10公里范围内的性别为女的用户列表
		userManager.queryKiloMetersListByPage(true, page, "location", longtitude, latitude, true, QUERY_KILOMETERS, "sex", false,
				new FindListener<User>() {
					// 查询全部地理位置信息且性别为女性的用户列表
					// userManager.queryNearByListByPage(true,page, "location", longtitude, latitude,
					// true,"sex",false,new
					// FindListener<User>() {

					@Override
					public void onSuccess(List<User> arg0) {
						// TODO Auto-generated method stub
						if (CollectionUtils.isNotNull(arg0)) {
							adapter.addAll(arg0);
						}
						refreshLoad();
					}

					@Override
					public void onError(int arg0, String arg1) {
						// TODO Auto-generated method stub
						L.e("查询更多附近的人出错:" + arg1);
						mListView.setPullLoadEnable(false);
						refreshLoad();
					}

				});
	}

	@Override
	public void onItemClick(AdapterView<?> arg0, View arg1, int position, long arg3) {
		User user = (User) adapter.getItem(position - 1);
		Intent intent = new Intent(this, User.class);
		intent.putExtra("from", "add");
		intent.putExtra("username", user.getUsername());
		A.goOtherActivity(context, intent);
	}

	@Override
	public void onRefresh() {
		initNearByList(true);
	}

	private void refreshLoad() {
		if (mListView.getPullLoading()) {
			mListView.stopLoadMore();
		}
	}

	private void refreshPull() {
		if (mListView.getPullRefreshing()) {
			mListView.stopRefresh();
		}
	}

	@Override
	public void onLoadMore() {
		double latitude = mApplication.lastPoint.getLatitude();
		double longtitude = mApplication.lastPoint.getLongitude();
		// 这是查询10公里范围内的性别为女用户总数
		userManager.queryKiloMetersTotalCount(User.class, "location", longtitude, latitude, true, QUERY_KILOMETERS, "sex", false,
				new CountListener() {
					// 这是查询附近的人且性别为女性的用户总数
					// userManager.queryNearTotalCount(User.class, "location", longtitude, latitude,
					// true,"sex",false,new
					// CountListener() {
					@Override
					public void onSuccess(int arg0) {
						if (arg0 > nears.size()) {
							curPage++;
							queryMoreNearList(curPage);
						} else {
							T.show(context, "数据加载完成");
							mListView.setPullLoadEnable(false);
							refreshLoad();
						}
					}

					@Override
					public void onFailure(int arg0, String arg1) {
						// TODO Auto-generated method stub
						L.i("查询附近的人总数失败" + arg1);
						refreshLoad();
					}
				});

	}

	@Override
	public void initTitleBar(ViewGroup rl_title, TextView tv_title, ImageButton ib_back, ImageButton ib_right, View shadow) {
		tv_title.setText("附近的人");
	}

	@Override
	public View getContentView() {
		return View.inflate(context, R.layout.activity_near_people, null);
	}

}
