/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.GeoParsedResult;
import com.google.zxing.client.result.ResultParser;

final class GeoResultParser
extends ResultParser {
    private GeoResultParser() {
    }

    public static GeoParsedResult parse(Result result) {
        double altitude;
        double longitude;
        double latitude;
        int longitudeEnd;
        int latitudeEnd;
        String geoURIWithoutQuery;
        String query;
        block10: {
            String rawText = result.getText();
            if (rawText == null || !rawText.startsWith("geo:") && !rawText.startsWith("GEO:")) {
                return null;
            }
            int queryStart = rawText.indexOf(63, 4);
            if (queryStart < 0) {
                query = null;
                geoURIWithoutQuery = rawText.substring(4);
            } else {
                query = rawText.substring(queryStart + 1);
                geoURIWithoutQuery = rawText.substring(4, queryStart);
            }
            latitudeEnd = geoURIWithoutQuery.indexOf(44);
            if (latitudeEnd < 0) {
                return null;
            }
            longitudeEnd = geoURIWithoutQuery.indexOf(44, latitudeEnd + 1);
            try {
                latitude = Double.parseDouble(geoURIWithoutQuery.substring(0, latitudeEnd));
                if (!(latitude > 90.0) && !(latitude < -90.0)) break block10;
                return null;
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        if (longitudeEnd < 0) {
            longitude = Double.parseDouble(geoURIWithoutQuery.substring(latitudeEnd + 1));
            altitude = 0.0;
        } else {
            longitude = Double.parseDouble(geoURIWithoutQuery.substring(latitudeEnd + 1, longitudeEnd));
            altitude = Double.parseDouble(geoURIWithoutQuery.substring(longitudeEnd + 1));
        }
        if (longitude > 180.0 || longitude < -180.0 || altitude < 0.0) {
            return null;
        }
        return new GeoParsedResult(latitude, longitude, altitude, query);
    }
}

