package com.ifengse.mywebapp;

import android.os.Bundle;
import android.app.Activity;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.webkit.WebView;
import android.webkit.WebViewClient;

public class MainActivity extends Activity {

	private WebView webview;
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		webview = (WebView)findViewById(R.id.wv);
		//webview.getSettings().setJavaScriptEnabled(true);
		webview.getSettings().setBuiltInZoomControls(true);//֧
		webview.requestFocus();
		webview.setWebViewClient(new MyWebViewClient());
		webview.loadUrl("http://www.ifengse.com/");
		
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		menu.add(0, 1, 1, "").setIcon(android.R.drawable.ic_media_rew);
		menu.add(0, 2, 1, "ǰ").setIcon(android.R.drawable.ic_media_ff);
		menu.add(0, 3, 1, "ҳ").setIcon(android.R.drawable.btn_star);
		menu.add(0, 4, 1, "ˢ").setIcon(android.R.drawable.star_big_on);
		menu.add(0, 5, 1, "˳").setIcon(android.R.drawable.ic_menu_delete);
		return true;
	}
	
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		// TODO Զɵķ
		switch(item.getItemId()){
		case 1:
			webview.goBack();
			break;
		case 2:
			webview.goForward();
			break;
		case 3:
			webview.loadUrl("http://www.ifengse.com/");
			break;
		case 4:
			webview.reload();
			break;
		case 5:
			this.finish();
			break;
		}
		return false;
		//return super.onOptionsItemSelected(item);
	}

	@Override
	public boolean onKeyDown(int keyCode, KeyEvent event) {
		// TODO Զɵķ
		//return super.onKeyDown(keyCode, event);
		if((keyCode == KeyEvent.KEYCODE_BACK) && webview.canGoBack()){
			webview.goBack();
			return true;
		}
		return false;
	}



	public class MyWebViewClient extends WebViewClient{

		@Override
		public boolean shouldOverrideUrlLoading(WebView view, String url) {
			// TODO Զɵķ
			return super.shouldOverrideUrlLoading(view, url);
		}
		
	}

}
