<?php
/**
 * @Copyright (c) 2019  XIGU Inc. All rights reserved.
 * @Link https://www.vlcms.com
 * @License江苏溪谷网络科技有限公司版权所有
 */

namespace app\admin\controller;

use app\common\logic\Auth;
use app\common\logic\ManagerAuth;
use app\common\logic\Role;
use app\common\logic\Log;
use app\common\logic\Manager AS lManager;
use think\Controller;

class Base extends Controller
{
    /**
     * @基类初始化 验证登录 以及权限和写日志
     *
     * @author: imdong
     * @since: 2019/3/21 9:30
     */
    public function initialize()
    {
        $lManager = new lManager();
        if (!$lManager -> isLogin()) {
            $this -> noLogin();
        }
        $manager_id = $lManager -> getManagerId();
        $auth = new Auth();
        $current = $auth -> currentAuth();
        $managerAuth = new ManagerAuth();
        $auth_ids = $managerAuth -> authIds();
        $no_auth_route = [
                'admin/Upload/oneimgupload',//单图上传
                'admin/Platform/selectlists',//平台列表
                'admin/Platform/studiolists',//公会绑定平台列表
                'admin/Auth/menu',//当前登录账号权限菜单
                'admin/System/getsiteinfo',//获取网站配置
                'admin/Notic/categorynotic',//获取分类文章(员工天地)
                'admin/Manager/modifyavatar',//修改头像
                'admin/Index/clearcache',//清除缓存
                'admin/Index/getunputcount',//获取未入库数据
                'admin/Auth/lists',//所有权限列表
                'admin/Index/clickgame',//点击游戏事件
        ];
        $current_route = request() -> module() . '/' . request() -> controller() . '/' . request() -> action();
        if ($manager_id != config('administrators_id') && !in_array($current_route, $no_auth_route) && !in_array($current, $auth_ids)) {
            $this -> noPower();
        }
        $lLog = new Log();
        $lLog -> create(
                $manager_id,
                request() -> module(),
                request() -> controller(),
                request() -> action()
        );
    }

    protected function noLogin()
    {
        echo json_encode(['code' => 403, 'msg' => '请先登录', 'data' => []]);
        die();
    }

    protected function noPower()
    {
        echo json_encode(['code' => 401, 'msg' => '无权访问', 'data' => []]);
        die();
    }

    protected function noAuth()
    {
        echo json_encode(['code' => 404, 'msg' => '未知接口', 'data' => []]);
        die();
    }

}
