<?php

namespace app\admin\controller;

class BaseSetting extends Base
{

    /**
     * @获取网站信息
     *
     * @author: zsl
     * @since: 2021/4/1 11:33
     */
    public function getSiteInfo()
    {
        $result = ['code' => 200, 'msg' => '请求成功', 'data' => []];
        $data = get_option('site_info');
        if (empty($data) || empty($data['add_oil'])) {
            $data = [];
            $data['add_oil'] = [];
        }
        $result['data'] = $data;
        return json($result);
    }


    /**
     * @设置网站信息
     *
     * @author: zsl
     * @since: 2021/4/1 11:34
     */
    public function setSiteInfo()
    {
        $result = ['code' => 200, 'msg' => '设置成功', 'data' => []];
        $param = $this -> request -> param();
        $data = [];
        $data['add_oil'] = !empty($param['add_oil']) ? $param['add_oil'] : '';
        set_option('site_info', $data);
        return json($result);
    }

}
