<?php
/**
 * @Copyright (c) 2019  XIGU Inc. All rights reserved.
 * @Link https://www.vlcms.com
 * @License江苏溪谷网络科技有限公司版权所有
 */

namespace app\admin\controller;

use app\common\logic\Department as lDepartment;

class Department extends Base
{


    /**
     * @api {post} /admin/department/lists 部门列表
     * @apiGroup 部门管理
     * @apiName 部门列表接口
     *
     * @apiDescription 获取部门列表
     *
     * @apiParam {String} manager_access_token  员工token
     *
     * @apiSuccess {Number} code    状态码，200：请求成功
     * @apiSuccess {String} msg     提示信息
     * @apiSuccess {Object} data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"code":200,"msg":"请求成功","data":[{"id":1,"pid":0,"name":"这是一个部门","status":1,"create_time":0},{"id":2,"pid":1,"name":"下级部门","status":1,"create_time":0}]}
     *
     */
    public function lists()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lDepartment = new lDepartment();
            $lists = $lDepartment -> lists($param);
            return json($lists);
        }
        return false;
    }


    /**
     * @api {post} /admin/department/create 新增部门
     * @apiGroup 部门管理
     * @apiName 新增部门接口
     *
     * @apiDescription 添加部门接口
     *
     * @apiParam {String} manager_access_token  用户token
     * @apiParam {Number} pid  上级部门id,一级部门填写0
     * @apiParam {String} name  部门名称
     * @apiParam {Number} status  部门状态
     *
     * @apiSuccess {Number} code    状态码，200：请求成功
     * @apiSuccess {String} msg     提示信息
     * @apiSuccess {Object} data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"code":200,"msg":"添加成功","data":[]}
     *
     * @apiErrorExample {json} Error-Response:
     * {"code":8001,"msg":"名称已存在","data":[]}
     *
     */
    public function create()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lDepartment = new lDepartment();
            return json($lDepartment -> create($param));
        }
        return false;
    }

    /**
     * @更新部门信息
     *
     * @author: zsl
     * @since: 2019/5/14 16:34
     */
    public function update()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lDepartment = new lDepartment();
            return json($lDepartment -> update($param));
        }
    }

    /**
     * @启用部门
     *
     * @return \think\response\Json
     *
     * @author: zsl
     * @since: 2019/5/14 11:02
     */
    public function enable()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lDepartment = new lDepartment();
            return json($lDepartment -> enable($param));
        }
    }

    /**
     * @禁用部门
     *
     * @return \think\response\Json
     *
     * @author: zsl
     * @since: 2019/5/14 11:02
     */
    public function disable()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lDepartment = new lDepartment();
            return json($lDepartment -> disable($param));
        }
    }


    /**
     * @部门详情
     *
     * @return \think\response\Json
     *
     * @author: zsl
     * @since: 2019/5/14 16:19
     */
    public function detail()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lDepartment = new lDepartment();
            $detail = $lDepartment -> detail($param);
            unset($detail['create_time']);
            unset($detail['update_time']);
            return json($detail);
        }
    }

    /**
     * @根据公会ID 查询部门树状结构select选择
     *
     * @return \think\response\Json
     *
     * @author: imdong
     * @since: 2019/5/27 10:13
     */
    public function treeSelect()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lDepartment = new lDepartment();
            return json($lDepartment -> treeSelect($param));
        }
    }




}