<?php
/**
 * @Copyright (c) 2019  XIGU Inc. All rights reserved.
 * @Link https://www.vlcms.com
 * @License江苏溪谷网络科技有限公司版权所有
 */

namespace app\admin\controller;

use app\common\logic\Manager as lManager;

class Manager extends Base
{


    /**
     * @获取当前用户信息
     *
     * @author: zsl
     * @since: 2021/2/25 16:41
     */
    public function info()
    {
        if (request() -> isPost()) {
            $managerModel = new lManager();
            return json($managerModel -> detail());
        }
        return false;
    }


    /**
     * @更新用户基础信息
     *
     * @author: zsl
     * @since: 2021/2/25 17:53
     */
    public function saveInfo()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lManager = new lManager();
            return json($lManager -> saveInfo($param));
        }
        return false;
    }


    /**
     * @更新当前用户银行卡信息
     *
     * @author: zsl
     * @since: 2021/2/25 19:59
     */
    public function saveBankInfo()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lManager = new lManager();
            return json($lManager -> saveBankInfo($param));
        }
        return false;
    }


    /**
     * @修改密码
     *
     * @author: zsl
     * @since: 2021/2/25 20:23
     */
    public function modifypassword()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lManager = new lManager();
            return json($lManager -> modifypassword($param));
        }
        return false;
    }


    /**
     * @修改头像
     *
     * @author: zsl
     * @since: 2021/2/26 9:34
     */
    public function modifyavatar()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lManager = new lManager();
            return json($lManager -> modifyavatar($param));
        }
        return false;
    }


    /**
     * @修改二级密码
     *
     * @author: zsl
     * @since: 2021/2/26 9:34
     */
    public function modifyVerifyPassword()
    {

        if (request() -> isPost()) {
            $param = request() -> param();
            $lManager = new lManager();
            return json($lManager -> modifyVerifyPassword($param));
        }
        return false;
    }


}