<?php
/**
 * @Copyright (c) 2019  XIGU Inc. All rights reserved.
 * @Link https://www.vlcms.com
 * @License江苏溪谷网络科技有限公司版权所有
 */

namespace app\admin\controller;

use app\common\logic\Platform as lPlatform;

class Platform extends Base
{


    /**
     * @我申请的渠道列表
     *
     * @author: 鹿文学[lwx]<fyj301415926@126.com>
     * @since: 2020\12\8 0008 11:55
     */
    public function mine()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lPlatform = new lPlatform();
            return json($lPlatform -> mine($param));
        }
        return false;
    }


    /**
     * @添加渠道
     *
     * @author: 鹿文学[lwx]<fyj301415926@126.com>
     * @since: 2020\12\7 0007 19:51
     */
    public function mineCreate()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lPlatform = new lPlatform();
            return json($lPlatform -> create($param));
        }
        return false;
    }

    /**
     * @编辑渠道
     *
     * @author: 鹿文学[lwx]<fyj301415926@126.com>
     * @since: 2020\12\8 0008 17:35
     */
    public function mineUpdate()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lPlatform = new lPlatform();
            return json($lPlatform -> modify($param));
        }
        return false;
    }

    /**
     * @渠道详情
     *
     * @author: 鹿文学[lwx]<fyj301415926@126.com>
     * @since: 2020\12\8 0008 11:55
     */
    public function detail()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lPlatform = new lPlatform();
            return json($lPlatform -> detail($param));
        }
        return false;
    }


    /**
     * @系统推荐渠道列表
     *
     * @author: 鹿文学[lwx]<fyj301415926@126.com>
     * @since: 2020\12\7 0007 19:50
     */
    public function lists()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lPlatform = new lPlatform();
            return json($lPlatform -> lists($param));
        }
        return false;
    }


    /**
     * @激活渠道
     *
     * @author: zsl
     * @since: 2021/3/12 9:36
     */
    public function apply()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lPlatform = new lPlatform();
            return json($lPlatform -> apply($param));
        }
        return false;
    }


}