<?php
/**
 * @Copyright (c) 2019  XIGU Inc. All rights reserved.
 * @Link https://www.vlcms.com
 * @License江苏溪谷网络科技有限公司版权所有
 */

namespace app\admin\controller;

use app\common\logic\WageDiy as lWageDiy;

class WageDiy extends Base
{


    /**
     * @自定义工资列表
     *
     * @author: zsl
     * @since: 2019/5/10 10:46
     */
    public function lists()
    {
        if (request() -> isPost()) {
            $lWageDiy = new lWageDiy();
            return json($lWageDiy -> lists());
        }
        return false;
    }

    /**
     * @获取自定义工资详情
     *
     * @return \think\response\Json
     *
     * @author: zsl
     * @since: 2019/5/10 15:37
     */
    public function detail()
    {
        if (request() -> isPost()) {
            $id = request() -> post('role_id');
            $lWageDiy = new lWageDiy();
            return json($lWageDiy -> detail($id));
        }

    }


    /**
     * @更新自定义工资
     *
     * @author: zsl
     * @since: 2019/5/13 9:06
     */
    public function create()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lWageDiy = new lWageDiy();
            return json($lWageDiy -> create($param));
        }
        return false;
    }

    public function update()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lWageDiy = new lWageDiy();
            return json($lWageDiy -> update($param));
        }
        return false;
    }

}