<?php
/**
 * @Copyright (c) 2019  XIGU Inc. All rights reserved.
 * @Link https://www.vlcms.com
 * @License江苏溪谷网络科技有限公司版权所有
 */

namespace app\admin\controller;

use app\common\logic\Welfare as lWelfare;

class Welfare extends Base
{

    /**
     * @我的福利列表
     *
     * @author: zsl
     * @since: 2019/6/5 17:06
     */
    public function lists()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lWelfare = new lWelfare();
            return json($lWelfare -> lists($param));
        }
        return false;
    }

    /**
     * @添加福利
     *
     * @author: zsl
     * @since: 2019/6/5 17:11
     */
    public function create()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lWelfare = new lWelfare();
            return json($lWelfare -> create($param));
        }
        return false;
    }

    /**
     * @更新福利
     *
     * @author: zsl
     * @since: 2019/6/5 17:48
     */
    public function update()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lWelfare = new lWelfare();
            return json($lWelfare -> update($param));
        }
    }

    /**
     * @福利详情
     *
     * @author: zsl
     * @since: 2019/6/5 17:50
     */
    public function detail()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lWelfare = new lWelfare();
            return json($lWelfare -> detail($param));
        }
        return false;
    }

    /**
     * @删除福利
     *
     * @author: zsl
     * @since: 2019/6/6 9:21
     */
    public function delete()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lWelfare = new lWelfare();
            return json($lWelfare -> delete($param));
        }
    }

}