<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2016 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 流年 <liu21st@gmail.com>
// +----------------------------------------------------------------------
// 应用公共文件
function data_encrypt($data)
{
    if (empty($data) || !is_string($data)) {
        return false;
    }
    return md5(md5($data) . config('data_encrypt_key'));
}

/**
 * @文件缓存快速调用方法
 *
 * @param string $key 缓存key
 * @param string $value 缓存值
 *
 * @author: 曹旭东
 * @since: 2019/4/22 10:18
 */
function file_cache($key, $value = '', $expire = 0)
{
    $fileCache = new \cache\FileCache(config('file_cache')['path']);
    if ($expire < 0) {
        return $fileCache -> delete($key);
    }
    if (empty($value)) {
        return $fileCache -> get($key);
    } else {
        return $fileCache -> set($key, $value, $expire);
    }
}

/**
 * 系统加密方法
 *
 * @param string $data 要加密的字符串
 * @param string $key 加密密钥
 * @param int $expire 过期时间 单位 秒
 *
 * @return string
 */
function encrypt($data, $key = '', $expire = 0)
{

    $key = md5(empty($key) ? config('data_token') : $key);
    $data = base64_encode($data);
    $x = 0;
    $len = strlen($data);
    $l = strlen($key);
    $char = '';
    for ($i = 0; $i < $len; $i ++) {
        if ($x == $l) $x = 0;
        $char .= substr($key, $x, 1);
        $x ++;
    }
    $str = sprintf('%010d', $expire ? $expire + time() : 0);
    for ($i = 0; $i < $len; $i ++) {
        $str .= chr(ord(substr($data, $i, 1)) + (ord(substr($char, $i, 1))) % 256);
    }
    return str_replace(array('+', '/', '='), array('-', '_', ''), base64_encode($str));
}

/**
 * 系统解密方法
 *
 * @param string $data 要解密的字符串 （必须是think_encrypt方法加密的字符串）
 * @param string $key 加密密钥
 *
 * @return string
 */
function decrypt($data, $key = '')
{
    $key = md5(empty($key) ? config('data_token') : $key);
    $data = str_replace(array('-', '_'), array('+', '/'), $data);
    $mod4 = strlen($data) % 4;
    if ($mod4) {
        $data .= substr('====', $mod4);
    }
    $data = base64_decode($data);
    $expire = substr($data, 0, 10);
    $data = substr($data, 10);
    if ($expire > 0 && $expire < time()) {
        return '';
    }
    $x = 0;
    $len = strlen($data);
    $l = strlen($key);
    $char = $str = '';
    for ($i = 0; $i < $len; $i ++) {
        if ($x == $l) $x = 0;
        $char .= substr($key, $x, 1);
        $x ++;
    }
    for ($i = 0; $i < $len; $i ++) {
        if (ord(substr($data, $i, 1)) < ord(substr($char, $i, 1))) {
            $str .= chr((ord(substr($data, $i, 1)) + 256) - ord(substr($char, $i, 1)));
        } else {
            $str .= chr(ord(substr($data, $i, 1)) - ord(substr($char, $i, 1)));
        }
    }
    return base64_decode($str);
}

/**
 * 设置系统配置，通用
 *
 * @param string $key 配置键值,都小写
 * @param array $data 配置值，数组
 * @param bool $replace 是否完全替换
 *
 * @return bool 是否成功
 */
function set_option($key, $data, $replace = false)
{
    if (!is_array($data) || empty($data) || !is_string($key) || empty($key)) {
        return false;
    }
    $key = strtolower($key);
    $option = [];
    $findOption = \think\Db ::name('option') -> where('option_name', $key) -> find();
    if ($findOption) {
        if (!$replace) {
            $oldOptionValue = json_decode($findOption['option_value'], true);
            if (!empty($oldOptionValue)) {
                $data = array_merge($oldOptionValue, $data);
            }
        }
        $option['option_value'] = json_encode($data);
        \think\Db ::name('option') -> where('option_name', $key) -> update($option);
        \think\Db ::name('option') -> getLastSql();
    } else {
        $option['option_name'] = $key;
        $option['option_value'] = json_encode($data);
        \think\Db ::name('option') -> insert($option);
    }
    cache('options_' . $key, null);//删除缓存
    return true;
}

/**
 * 获取系统配置，通用
 *
 * @param string $key 配置键值,都小写
 *
 * @return array
 */
function get_option($key)
{
    if (!is_string($key) || empty($key)) {
        return [];
    }
    static $GetOption;
    if (empty($GetOption)) {
        $GetOption = [];
    } else {
        if (!empty($GetOption[$key])) {
            return $GetOption[$key];
        }
    }
    $optionValue = cache('options_' . $key);
    if (empty($optionValue)) {
        $optionValue = \think\Db ::name('option') -> where('option_name', $key) -> value('option_value');
        if (!empty($optionValue)) {
            $optionValue = json_decode($optionValue, true);
            cache('options_' . $key, $optionValue);
        }
    }
    $GetOption[$key] = $optionValue;
    return $optionValue;
}

/**
 * @获取图片url
 *
 * @param $file
 *
 * @return string
 *
 * @author: zsl
 * @since: 2019/5/15 15:46
 */
function get_image_url($file, $path_name = 'images')
{
    if (empty($file)) {
        return '';
    }
    if (strpos($file, "http") === 0) {
        return $file;
    } else if (strpos($file, "/") === 0) {
        return get_domain() . $file;
    } else {
        return get_domain() . get_root() . '/upload/' . $path_name . '/' . $file;
    }
}

/**
 * 返回带协议的域名
 */
function get_domain()
{
    return request() -> domain();
}

/**
 * 获取当前访问的网站根目录
 *
 * @return string 网站根目录
 */
function get_root()
{
    $root = request() -> root();
    $root = str_replace('/index.php', '', $root);
    return $root;
}

/**
 * @curl
 *
 * @param string $url
 * @param array $data
 *
 * @return array|bool|mixed
 *
 * @author: imdong
 * @since: 2019/5/13 15:45
 */
function curl($url = '', $data = [])
{
    $url_arr = parse_url($url);
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_HEADER, 0);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
    if ($url_arr['scheme'] == 'https') {
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
    }
    curl_setopt($curl, CURLOPT_POST, 1);
    curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
    curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
    $data = curl_exec($curl);
    if ($data) {
        curl_close($curl);
        return $data;
    } else {
        curl_close($curl);
        return false;
    }
}

function rand_str($length = 16)
{
    $chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    $rand = '';
    for ($i = 0; $i < $length; $i ++) {
        $rand .= $chars[mt_rand(0, strlen($chars) - 1)];
    }
    return $rand;
}

/**
 * @获取所有员工和下属id
 *
 * @author: zsl
 * @since: 2021/3/8 9:47
 */
function get_sub_manager_ids($data, $id = '0', $is_first_time = true)
{
    static $arr = [];
    if ($is_first_time) {
        $arr = [];
    }
    foreach ($data as $key => $val) {
        if ($val['pid'] == $id) {
            $arr[] = $val['id'];
            get_sub_manager_ids($data, $val['id'], false);
        }
    }
    return $arr;
}

/**
 * 获取指定日期段内每一天的日期
 *
 * @param : Date $startdate 开始日期
 * @param : Date $enddate 结束日期
 *
 * @return array
 */
function getDateFromRange($startdate, $enddate)
{

    $stimestamp = strtotime($startdate);
    $etimestamp = strtotime($enddate);
    // 计算日期段内有多少天
    $days = ($etimestamp - $stimestamp) / 86400 + 1;
    // 保存每天日期
    $date = array();
    for ($i = 0; $i < $days; $i ++) {
        $date[] = date('Y-m-d', $stimestamp + (86400 * $i));
    }
    return $date;
}

/**
 * @获取员工列表
 *
 * @author: zsl
 * @since: 2021/3/8 20:10
 */
function get_manager_lists()
{
    $mManager = new \app\common\model\Manager();
    $managerLists = $mManager -> where('status', 'in', [0, 1]) -> column('id,name');
    return $managerLists;
}

/**
 * 发送修改密码通知短信
 */
function send_change_password_msg($phone, $param)
{
    //【工作室名称】您的账号zhangsan于3月29日16:24通过OA管理后台进行密码重设，如有疑问，请联系客服电话159xxxxxxxx。感谢您为共同梦想辛劳付出！
    //【签名】您的账号{1}于{2}通过OA管理后台进行密码重设，如有疑问，请联系客服电话{3}。感谢您为共同梦想辛劳付出！
    return alicloud_sms_send($phone, $param, 'change_password_code');
}

/**
 * @发送工资通知
 */
function send_wage_msg($phone, $param)
{
    //【工作室名称】亲爱的zhangsan同学，您的3月工资已发放，请注意查收，感谢您为共同梦想辛劳付出！
    //【签名】亲爱的{1}同学，您的{2}月工资已发放，请注意查收，感谢您为共同梦想辛劳付出！
    return alicloud_sms_send($phone, $param, 'wage_code', 0);

}

/**
 * @荣誉等级短信通知
 */
function send_honor_msg($phone, $param)
{
    //【工作室名称】亲爱的张三同学，您的推广账号已达到【精英推广】等级，当前荣誉总分10000，可使用余额10000，可兑换安卓手机使用权，感谢您为共同梦想辛劳付出！
    //【签名】亲爱的{1}同学，您的推广账号已达到【{2}】等级，当前荣誉总分{3}，可使用余额{4}，可兑换{5}，感谢您为共同梦想辛劳付出！
    return alicloud_sms_send($phone, $param, 'honor_code');

}

/**
 * @特权奖励短信通知
 */
function send_grant_msg($phone, $param)
{
    //【工作室名称】亲爱的张三同学，您申请的<安卓手机使用权>特权已发放，请注意查收，感谢您为共同梦想辛劳付出！
    //【签名】亲爱的{1}同学，您申请的<{2}>特权已发放，请注意查收，感谢您为共同梦想辛劳付出！
    return alicloud_sms_send($phone, $param, 'privilege_code');
}

/**
 * @发送短信
 *
 * @author: zsl
 * @since: 2021/3/16 19:34
 */
function alicloud_sms_send($phone, $param, $msg_type, $expires = 0)
{
    $config = get_option('sms_info');
    if (empty($config['status'])) {
        return 2;
    }
    if ($config['number']) {
        $where = [];
        $where[] = ['template_id', '=', $config[$msg_type]];;
        $where[] = ['phone', '=', $phone];;
        $where[] = ['create_time', '>=', strtotime(date('Y-m-d'))];;
        $count = db('sms_log') -> where($where) -> count('id');
        if ($count >= $config['number']) {
            return 1;
        }
    }
    if (!empty($config)) {
        $result = \app\common\api\AliCloud ::main($config['access_key_id'], $config['access_key_secret'], $phone, $config['sign_name'], $config[$msg_type], $param);
        if ($result) {
            $insert = [];
            $insert['template_id'] = $config[$msg_type];
            $insert['phone'] = $phone;
            $insert['content'] = $param;
            $insert['expires_time'] = time() + $expires;
            $insert['api_result'] = $result;
            $insert['status'] = 0;
            $insert['create_time'] = time();
            db('sms_log') -> insert($insert);
            return 0;
        } else {
            return 3;
        }
    }
    return 2;
}

/**
 * @检测是否安装
 *
 * @author: zsl
 * @since: 2021/3/18 9:42
 */
function is_installed()
{
    static $isInstalled;
    if (empty($isInstalled)) {
        $isInstalled = file_exists('../data/install.lock');
    }
    return $isInstalled;
}

/**
 * @检测是否清除过演示数据
 *
 * @author: zsl
 * @since: 2021/3/18 9:42
 */
function is_truncate()
{
    static $isTruncate;
    if (empty($isTruncate)) {
        $isTruncate = file_exists('../data/truncate.lock');
    }
    return $isTruncate;
}

/**
 *
 * 正则检测手机号码格式
 **/
function check_mobile($mobile)
{
    if (!is_numeric($mobile)) {
        return false;
    }
    return preg_match('#^13[\d]{9}$|^14[5,7]{1}\d{8}$|^15[^4]{1}\d{8}$|^17[0,6,7,8]{1}\d{8}$|^18[\d]{9}$#', $mobile) ? true : false;
}


