<?php

namespace app\common\api;

use AlibabaCloud\SDK\Dysmsapi\V20170525\Dysmsapi;
use AlibabaCloud\Darabonba\Env\Env;
use AlibabaCloud\Tea\Utils\Utils;
use AlibabaCloud\Tea\Console\Console;
use AlibabaCloud\Darabonba\String\StringUtil;
use AlibabaCloud\Darabonba\Time\Time;
use Darabonba\OpenApi\Models\Config;
use AlibabaCloud\SDK\Dysmsapi\V20170525\Models\SendSmsRequest;
use AlibabaCloud\SDK\Dysmsapi\V20170525\Models\QuerySendDetailsRequest;

class AliCloud
{

    /**
     * 使用AK&SK初始化账号Client
     *
     * @param string $accessKeyId
     * @param string $accessKeySecret
     *
     * @return Dysmsapi
     */
    public static function createClient($accessKeyId, $accessKeySecret)
    {
        $config = new Config([]);
        $config -> accessKeyId = $accessKeyId;
        $config -> accessKeySecret = $accessKeySecret;
        return new Dysmsapi($config);
    }


    /**
     * @发送短信
     *
     * @param $phoneNumbers : 手机号
     * @param $signName : 签名
     * @param $templateCode : 模板代码
     * @param $templateParam : 短信参数
     *
     * @return bool
     *
     * @author: zsl
     * @since: 2021/3/16 19:22
     */
    public static function main($accessKeyId, $accessKeySecret, $phoneNumbers, $signName, $templateCode, $templateParam)
    {
        $client = self ::createClient($accessKeyId, $accessKeySecret);
        $param = [
                "phoneNumbers" => $phoneNumbers,
                "signName" => $signName,
                "templateCode" => $templateCode,
                "templateParam" => $templateParam
        ];
        // 1.发送短信
        $sendReq = new SendSmsRequest($param);
        $sendResp = $client -> sendSms($sendReq);
        $code = $sendResp -> body -> code;
        if (!Utils ::equalString($code, "OK")) {
            return false;
        }
        return true;
    }
}

