<?php

namespace app\common\api;

use app\common\model\Platform as mPlatform;

class PlatformApi
{

    //平台信息
    protected $platformInfo;

    //接口文件对象
    protected $platformObj;

    //接口文件存放目录
    private $file_path = "";

    //错误码
    private $error_code = 0;

    //错误信息
    private $error_msg = "";


    public function __construct()
    {
        $this -> file_path = env('app_path') . 'common' . DIRECTORY_SEPARATOR . 'platform' . DIRECTORY_SEPARATOR;
        return true;
    }


    public function check($param)
    {
        try {

            $mPlatform = new mPlatform();
            $where = [];
            $where['id'] = $param['platform_id'];
            $platformInfo = $mPlatform -> where($where) -> find();
            if (empty($platformInfo['ename'])) {
                $this -> error_msg = '接口标识不能为空';
                return $this;
            }
            if (!file_exists($this -> file_path . $platformInfo['ename'] . '.php')) {
                $this -> error_msg = '平台接口文件不存在';
                return $this;
            }
            $objPath = '\app\common\platform\\' . $platformInfo['ename'];
            $obj = new $objPath($platformInfo['api'], $platformInfo['token'], $platformInfo['appid']);
            $this -> platformInfo = $platformInfo;
            $this -> platformObj = $obj;
            $this -> error_msg = "";
            $this -> error_code = 1;
            return $this;
        } catch (\Exception $exception) {
            $this -> error_msg = $exception -> getMessage();
            return $this;
        }
    }


    /**
     * @绑定用户
     *
     * @author: zsl
     * @since: 2021/3/2 15:19
     */
    public function bind($param = [])
    {
        $result = ['code' => 1, 'msg' => 'success', 'data' => []];
        if ($this -> error_code == 0) {
            $result['code'] = 0;
            $result['msg'] = $this -> error_msg;
            return $result;
        }
        $apiList = json_decode($this -> platformInfo['api'], true);
        if (!empty($param['is_create'])) {
            if (empty($apiList['create_promote'])) {
                $result['code'] = 0;
                $result['msg'] = '创建推广员接口地址错误';
                return $result;
            }
            //新建推广员
            $res = $this -> platformObj -> createPromote($param);
        } else {
            if (empty($apiList['verify_promote'])) {
                $result['code'] = 0;
                $result['msg'] = '验证推广员接口地址错误';
                return $result;
            }
            //验证推广员
            $res = $this -> platformObj -> verifyPromote($param);
        }
        if (!$res) {
            $result['code'] = 0;
            $result['msg'] = '接口异常';
            return $result;
        }
        return $res;
    }


    /**
     * @游戏中心
     *
     * @author: zsl
     * @since: 2021/3/10 11:46
     */
    public function game($param = [])
    {
        $result = ['code' => 1, 'msg' => 'success', 'data' => []];
        // 检查是否通过验证
        if ($this -> error_code == 0) {
            $result['code'] = 0;
            $result['msg'] = $this -> error_msg;
            return $result;
        }
        // 检查接口是否正确
        $apiList = json_decode($this -> platformInfo['api'], true);
        if (empty($apiList['game'])) {
            $result['code'] = 0;
            $result['msg'] = '游戏中心接口错误';
            return $result;
        }
        // 调用接口获取游戏
        $gameRes = $this -> platformObj -> game($param);
        $gameRes = json_decode($gameRes, true);
        if (!$gameRes) {
            $result['code'] = 0;
            $result['msg'] = '接口异常';
            return $result;
        }
        return $gameRes;
    }

    /**
     * @申请游戏
     *
     * @author: zsl
     * @since: 2021/3/11 10:15
     */
    public function apply($param)
    {
        $result = ['code' => 1, 'msg' => 'success', 'data' => []];
        // 检查是否通过验证
        if ($this -> error_code == 0) {
            $result['code'] = 0;
            $result['msg'] = $this -> error_msg;
            return $result;
        }
        // 检查接口是否正确
        $apiList = json_decode($this -> platformInfo['api'], true);
        if (empty($apiList['apply'])) {
            $result['code'] = 0;
            $result['msg'] = '申请游戏接口错误';
            return $result;
        }
        // 调用接口申请游戏
        $applyRes = $this -> platformObj -> apply($param);
        $applyRes = json_decode($applyRes, true);
        if (!$applyRes) {
            $result['code'] = 0;
            $result['msg'] = '接口异常';
            return $result;
        }
        return $applyRes;
    }


    /**
     * @我的游戏
     *
     * @author: zsl
     * @since: 2021/3/11 11:31
     */
    public function my($param)
    {
        $result = ['code' => 1, 'msg' => 'success', 'data' => []];
        // 检查是否通过验证
        if ($this -> error_code == 0) {
            $result['code'] = 0;
            $result['msg'] = $this -> error_msg;
            return $result;
        }
        // 检查接口是否正确
        $apiList = json_decode($this -> platformInfo['api'], true);
        if (empty($apiList['my'])) {
            $result['code'] = 0;
            $result['msg'] = '我的游戏接口错误';
            return $result;
        }
        // 调用接口
        $myRes = $this -> platformObj -> my($param);
        $myRes = json_decode($myRes, true);
        if (!$myRes) {
            $result['code'] = 0;
            $result['msg'] = '接口异常';
            return $result;
        }
        return $myRes;
    }


    /**
     * @游戏渠道打包
     *
     * @author: zsl
     * @since: 2021/3/11 16:19
     */
    public function package($param)
    {
        $result = ['code' => 1, 'msg' => 'success', 'data' => []];
        // 检查是否通过验证
        if ($this -> error_code == 0) {
            $result['code'] = 0;
            $result['msg'] = $this -> error_msg;
            return $result;
        }
        // 检查接口是否正确
        $apiList = json_decode($this -> platformInfo['api'], true);
        if (empty($apiList['package'])) {
            $result['code'] = 0;
            $result['msg'] = '游戏渠道打包接口错误';
            return $result;
        }
        // 调用接口
        $res = $this -> platformObj -> package($param);
        $res = json_decode($res, true);
        if (!$res) {
            $result['code'] = 0;
            $result['msg'] = '接口异常';
            return $result;
        }
        return $res;
    }


    /**
     * @拉取注册数据
     *
     * @author: zsl
     * @since: 2021/3/3 11:05
     */
    public function pullRegister($param)
    {
        $result = ['code' => 1, 'msg' => 'success', 'data' => []];
        if ($this -> error_code == 0) {
            $result['code'] = 0;
            $result['msg'] = $this -> error_msg;
            return $result;
        }
        $apiList = json_decode($this -> platformInfo['api'], true);
        if (empty($apiList['register'])) {
            $result['code'] = 0;
            $result['msg'] = '注册用户接口地址错误';
            return $result;
        }
        //获取注册数据
        $res = $this -> platformObj -> pullRegister($param);
        $res = json_decode($res, true);
        if (!empty($res['data'])) {
            $result['data'] = $res['data'];
        }
        return $result;
    }


    /**
     * @拉取充值订单数据
     *
     * @author: zsl
     * @since: 2021/3/5 13:59
     */
    public function pullRecharge($param)
    {
        $result = ['code' => 1, 'msg' => 'success', 'data' => []];
        if ($this -> error_code == 0) {
            $result['code'] = 0;
            $result['msg'] = $this -> error_msg;
            return $result;
        }
        $apiList = json_decode($this -> platformInfo['api'], true);
        if (empty($apiList['register'])) {
            $result['code'] = 0;
            $result['msg'] = '充值订单接口地址错误';
            return $result;
        }
        //获取注册数据
        $res = $this -> platformObj -> pullRecharge($param);
        $res = json_decode($res, true);
        if (!empty($res['data'])) {
            $result['data'] = $res['data'];
        }
        return $result;
    }


    /**
     * 获取错误信息
     *
     * @return string
     */
    public function getErrorMsg(): string
    {
        return $this -> error_msg;
    }


}