<?php

namespace app\common\logic;

use app\common\model\Manager as mManager;

class Achievements extends Base
{


    /**
     * @业绩总览
     *
     * @author: zsl
     * @since: 2021/3/8 13:38
     */
    public function overview($param)
    {
        $result = ['code' => 200, 'msg' => '请求成功', 'data' => [], 'monthData' => []];
        $stat = new Stat();
        $managerId = $this -> getManagerId();
        //获取查询日期范围
        $start_date = empty($param['start_date']) ? date('Y-m-d', strtotime('-6 days')) : $param['start_date'];
        $end_date = empty($param['end_date']) ? date('Y-m-d', strtotime('-0 days')) : $param['end_date'];
        $dateRange = getDateFromRange($start_date, $end_date);
        $dateRange = array_reverse($dateRange);
        $data = [];
        //获取每日数据
        foreach ($dateRange as $k => $v) {
            $timestamp = strtotime($v);
            $data[$k] = $stat -> data($managerId, $timestamp, $timestamp + 86399);
            $data[$k]['date'] = $v;
        }
        //本月起始时间戳和结束时间戳
        $beginThismonth = mktime(0, 0, 0, date('m'), 1, date('Y'));
        $endThismonth = mktime(23, 59, 59, date('m'), date('t'), date('Y'));
        //获取当月数据
        $monthData = $stat -> data($managerId, $beginThismonth, $endThismonth);
        //获取汇总数据
//        $totalData = $stat -> data($managerId);
        $result['data'] = $data;
        $result['monthData'] = $monthData;
//        $result['totalData'] = $totalData;
        return $result;
    }


    /**
     * @业绩总览详情
     *
     * @author: zsl
     * @since: 2021/3/8 19:42
     */
    public function overviewDetail($param)
    {
        $result = ['code' => 200, 'msg' => '请求成功', 'data' => []];
        if (empty($param['date'])) {
            $param['date'] = date("Y-m-d");
        }
        $timestamp = strtotime($param['date']);
        $stat = new Stat();
        // 获取下级所有员工
        $managerId = $this -> getManagerId();
        if ($managerId == config('administrators_id')) {
            $managerIds = $stat -> getSubManagerIds(0);
        } else {
            $managerIds = $stat -> getSubManagerIds($this -> getManagerId());
        }
        //获取所有员工账号
        $managerLists = get_manager_lists();
        //获取不包含下级所有业绩数据
        $data = [];
        foreach ($managerIds as $k => $managerId) {
            if ($managerId != 0 && $managerId != config('administrators_id')) {

                if (!empty($param['name'])) {
                    if ($param['name'] == $managerLists[$managerId]) {
                        // 获取员工自身业绩数据
                        $data[$k] = $stat -> data($managerId, $timestamp, $timestamp + 86399, false);
                        $data[$k]['manager_id'] = $managerId;
                        $data[$k]['manager_name'] = $managerLists[$managerId];
                    }
                } else {
                    // 获取员工自身业绩数据
                    $data[$k] = $stat -> data($managerId, $timestamp, $timestamp + 86399, false);
                    $data[$k]['manager_id'] = $managerId;
                    $data[$k]['manager_name'] = $managerLists[$managerId];
                }
            }
        }
        $result['data'] = array_merge($data);
        return $result;
    }


}
