<?php
/**
 * @Copyright (c) 2019  XIGU Inc. All rights reserved.
 * @Link https://www.vlcms.com
 * @License江苏溪谷网络科技有限公司版权所有
 */

namespace app\common\logic;

use app\common\model\Auth as mAuth;
use app\common\model\ManagerAuth as mManagerAuth;
use app\common\model\Role as mRole;

class Auth extends Base
{
    public function currentAuth()
    {
        $where = [];
        $where[] = ['module', '=', strtolower(request() -> module())];
        $where[] = ['controller', '=', strtolower(request() -> controller())];
        $where[] = ['action', '=', strtolower(request() -> action())];
        $where[] = ['status', 'in', '0,1'];
        $mAuth = new mAuth();
        return $mAuth -> where($where) -> value('id');
    }


    public function detail($param)
    {
        $detail = [];
        if (!empty($param['id'])) {
            $mAuth = new mAuth();
            $detail = $mAuth -> where('id', '=', $param['id']) -> where('status', 'in', [0, 1]) -> find();
        }
        return $detail;
    }


    public function lists($param)
    {

        $result = ['code' => 200, 'msg' => '', 'data' => []];
        $userInfo = json_decode(decrypt($param['manager_access_token']), true);
        $where = [];
        if (config('administrators_id') != $userInfo['id']) {

            $mManagerAuth = new mManagerAuth();
            $role_id = $mManagerAuth -> where(['manager_id' => $userInfo['id']]) -> value('role_id');
            $mRole = new mRole();
            $auth_ids = $mRole -> where(['id' => $role_id]) -> value('auth_ids');
            $where[] = ['id', 'in', explode(',', $auth_ids)];

        }
        $mAuth = new mAuth();
        $field = 'id,pid,title,iconfont,param,type,sort,remark,route_url,status';
        $where[] = ['status', 'in', '0,1'];
        $mAuthData = $mAuth -> field($field) -> where($where) -> order('sort') -> select();
        if (!$mAuthData -> isEmpty()) {
            $result['data'] = $mAuthData -> toArray();
        }
        return $result;
    }

    public function menu($param)
    {
        $result = ['code' => 200, 'msg' => '', 'data' => []];
        $userInfo = json_decode(decrypt($param['manager_access_token']), true);
        $where = [];
        if (config('administrators_id') != $userInfo['id']) {

            $mManagerAuth = new mManagerAuth();
            $role_id = $mManagerAuth -> where(['manager_id' => $userInfo['id']]) -> value('role_id');
            $mRole = new mRole();
            $auth_ids = $mRole -> where(['id' => $role_id]) -> value('auth_ids');
            $where[] = ['id', 'in', explode(',', $auth_ids)];

        }
        $mAuth = new mAuth();
        $field = 'id,pid,title,iconfont,param,type,sort,remark,route_url,status';
        $where[] = ['status', '=', 1];
        $where[] = ['type', 'in', '0,1'];
        $mAuthData = $mAuth -> field($field) -> where($where) -> order('sort') -> select();
        if (!$mAuthData -> isEmpty()) {
            $result['data'] = $mAuthData -> toArray();
        }
        return $result;
    }

    public function sort($param)
    {
        $result = ['code' => 200, 'msg' => '节点排序成功', 'data' => []];
        $where = [];
        if (!empty($param['id'])) {
            $where[] = ['id', '=', $param['id']];
        }
        try {
            $mAuth = new mAuth();
            $mAuth -> where($where) -> update(['sort' => $param['sort']]);
        } catch (\Exception $e) {
            $result['code'] = 2005;
            $result['msg'] = $this -> errorCode(2006);
        }
        return $result;
    }

    public function enable($param)
    {
        $result = ['code' => 200, 'msg' => '节点启用成功', 'data' => []];
        $where = [];
        if (!empty($param['id'])) {
            $where[] = ['id', '=', $param['id']];
        }
        if (!$this -> reStatus($where, 1)) {
            $result['code'] = 2006;
            $result['msg'] = $this -> errorCode(2006);
        }
        return $result;
    }

    public function disable($param)
    {
        $result = ['code' => 200, 'msg' => '节点禁用成功', 'data' => []];
        $where = [];
        if (!empty($param['id'])) {
            $where[] = ['id', '=', $param['id']];
        }
        if (!$this -> reStatus($where, 0)) {
            $result['code'] = 2007;
            $result['msg'] = $this -> errorCode(2007);
        }
        return $result;
    }

    public function delete($param)
    {
        $result = ['code' => 200, 'msg' => '节点删除成功', 'data' => []];
        $where = [];
        if (!empty($param['id'])) {
            $where[] = ['id', '=', $param['id']];
        }
        if (!$this -> reStatus($where, - 1)) {
            $result['code'] = 2008;
            $result['msg'] = $this -> errorCode(2008);
        }
        return $result;
    }

    private function reStatus($where, $status)
    {
        try {
            $mAuth = new mAuth();
            $mAuth -> where($where) -> update(['status' => $status]);
            return true;
        } catch (\Exception $e) {
            return false;
        }
    }

    private function errorCode($code)
    {
        $errorCode = [
                2001 => '',
                2002 => '节点添加失败',
                2003 => '节点修改失败',
                2004 => '节点不存在，或已被删除',
                2005 => '节点排序设置失败',
                2006 => '节点启用失败',
                2007 => '节点禁用失败',
                2008 => '节点删除成功'
        ];
        return empty($errorCode[$code]) ? '系统繁忙,请稍候再试' : $errorCode[$code];
    }

}