<?php
/**
 * gitee: https://github.com/kyle-cao
 * Created by: admin.dadmin.cn
 * User: imdong
 * Date: 2019/1/14
 * Time: 14:05
 */

namespace app\common\logic;

use app\common\model\Manager as mManager;

class Base
{
    public function __construct()
    {
    }


    /**
     * @返回当前登录用户id,未登录返回false
     *
     * @return int|bool
     * @author: zsl
     * @since: 2019/5/7 16:35
     */
    public function getManagerId()
    {
        $param = request() -> param();
        if (empty($param['manager_access_token'])) {
            return false;
        }
        $token_str = json_decode(decrypt($param['manager_access_token']), true);
        if (!$token_str) {
            return false;
        }
        if (empty($param['staff'])) {
            $access_token_str = file_cache('manager_access_' . $token_str['id']);
        } else {
            $access_token_str = file_cache('staff_access_' . $token_str['id']);
        }
        if ($param['manager_access_token'] != $access_token_str) {
            return false;
        }
        return $token_str['id'];
    }

    /**
     * @返回当前登录用户帐号,未登录返回false
     *
     * @return bool
     *
     * @author: 鹿文学[lwx]<fyj301415926@126.com>
     * @since: 2020\12\12 0012 10:34
     */
    public function getManagerName()
    {
        $param = request() -> param();
        if (empty($param['manager_access_token'])) {
            return false;
        }
        $token_str = json_decode(decrypt($param['manager_access_token']), true);
        if (!$token_str) {
            return false;
        }
        if (empty($param['staff'])) {
            $access_token_str = file_cache('manager_access_' . $token_str['id']);
        } else {
            $access_token_str = file_cache('staff_access_' . $token_str['id']);
        }
        if ($param['manager_access_token'] != $access_token_str) {
            return false;
        }
        return $token_str['name'];
    }

    /**
     * @返回当前登录用户角色ID,未登录返回false
     *
     * @param int $manager_id
     *
     * @return mixed
     *
     * @author: 鹿文学[lwx]<fyj301415926@126.com>
     * @since: 2020\12\12 0012 10:44
     */
    public function getManagerRoleId($manager_id = 0)
    {
        $managerId = !empty($manager_id) ? $manager_id : $this -> getManagerId();
        return $managerId ? mManager ::hasWhere('auth') -> where(['manager_id' => $managerId]) -> value('role_id') : false;
    }

    /**
     * @生成token并写入缓存
     *
     * @param array $manager_info
     *
     * @return array|boolean
     *
     * @author: zsl
     * @since: 2019/5/8 13:59
     */
    protected function createManagerToken(array $manager_info = [])
    {
        if (empty($manager_info)) {
            return false;
        }
        //生成token
        $manager_access_token = encrypt(json_encode($manager_info));
        $manager_info['time'] = time();
        $manager_refresh_token = encrypt(json_encode($manager_info));
        file_cache('manager_access_' . $manager_info['id'], $manager_access_token, config('manager_login_expire_time'));
        file_cache('manager_refresh_' . $manager_info['id'], $manager_refresh_token, config('manager_login_expire_time') + 86400 * 7);
        return [
                'manager_access_token' => $manager_access_token,
                'manager_refresh_token' => $manager_refresh_token,
        ];

    }



}
