<?php

namespace app\common\logic;

use app\common\model\Manager as mManager;
use app\common\model\Recharge;
use app\common\model\Recharge as mRecharge;
use app\common\model\Register;
use app\common\model\Register as mRegister;
use app\common\model\Platform as mPlatform;

class Data extends Base
{


    /**
     * @数据汇总
     *
     * @author: zsl
     * @since: 2021/3/5 13:45
     */
    public function summarize($param)
    {
        $result = ['code' => 200, 'msg' => '请求成功', 'data' => []];
        $page = empty($param['page']) ? 1 : $param['page'];
        $limit = empty($param['limit']) ? 1 : $param['limit'];
        $lStat = new Stat();
        $field = "m.id,m.name,mp.promote_account";
        $where = [];
        $mManager = new mManager();
        // 查找下级所有数据
        if ($this -> getManagerId() != config('administrators_id')) {
            $managerIds = $lStat -> getSubManagerIds($this -> getManagerId());
            $where[] = ['m.id', 'in', $managerIds];
        }
        // 员工账号
        if (!empty($param['name'])) {
            $where[] = ['m.name', 'like', '%' . $param['name'] . '%'];
        }
        // 渠道账号
        if (!empty($param['channel_name'])) {
            $where[] = ['mp.promote_account', 'like', '%' . $param['channel_name'] . '%'];
        }
        // 获取员工列表
        $result['count'] = $mManager -> alias('m')
                -> join(['oa_manager_platform' => 'mp'], 'm.id = mp.manager_id', 'left')
                -> where($where)
                -> count();
        $result['page'] = $page;
        $result['limit'] = $limit;
        $managerLists = $mManager -> alias('m')
                -> field($field)
                -> join(['oa_manager_platform' => 'mp'], 'm.id = mp.manager_id', 'left')
                -> where($where)
                -> page($page, $limit)
                -> order('m.id')
                -> select();
        // 获取员工数据
        $data = $this -> managerSummarize($managerLists);
        $result['data'] = $data;
        return $result;
    }


    /**
     * @员工数据总览
     *
     * @author: zsl
     * @since: 2021/3/8 9:31
     */
    private function managerSummarize($managerLists)
    {
        $mRegister = new Register();
        $mRecharge = new Recharge();
        foreach ($managerLists as $k => $manager) {
            if (!empty($manager['promote_account'])) {
                //注册人数
                $where = [];
                $where['manager_id'] = $manager['id'];
                $where['promote_account'] = $manager['promote_account'];
                $regCount = $mRegister -> where($where) -> count();
                $managerLists[$k]['register_count'] = $regCount;
                //注册IP数
                $regIpCount = $mRegister -> where($where) -> group('register_ip') -> count();
                $managerLists[$k]['register_ip_count'] = $regIpCount;
                //充值人数
                $where = [];
                $where['manager_id'] = $manager['id'];
                $where['promote_account'] = $manager['promote_account'];
                $rechargeCount = $mRecharge -> where($where) -> count();
                $managerLists[$k]['recharge_count'] = $rechargeCount;
                //充值金额
                $rechargeNum = $mRecharge -> where($where) -> sum('cost_amount');
                $managerLists[$k]['recharge_num'] = round($rechargeNum / 100, 2);
            } else {
                $managerLists[$k]['promote_account'] = '';
                $managerLists[$k]['register_count'] = 0;
                $managerLists[$k]['register_ip_count'] = 0;
                $managerLists[$k]['recharge_count'] = 0;
                $managerLists[$k]['recharge_num'] = 0;
            }
        }
        return $managerLists;
    }


    /**
     * @充值明细
     *
     * @author: zsl
     * @since: 2021/3/8 10:23
     */
    public function recharge($param)
    {
        $result = ['code' => 200, 'msg' => '请求成功', 'data' => []];
        $page = empty($param['page']) ? 1 : $param['page'];
        $limit = empty($param['limit']) ? 1 : $param['limit'];
        $mRecharge = new mRecharge();
        $field = 'r.id,r.user_account,r.order_no,r.game_name,r.server_name,r.total_amount,r.cost_amount,r.pay_time,r.pay_way_str,
        m.name manager_name,r.promote_account channel_name,r.platform_id';
        $where = [];
        //玩家账号
        if (!empty($param['user_account'])) {
            $where[] = ['r.user_account', 'like', '%' . $param['user_account'] . '%'];
        }
        //游戏名称
        if (!empty($param['game_name'])) {
            $where[] = ['r.game_name', 'like', '%' . $param['game_name'] . '%'];
        }
        //员工账号
        if (!empty($param['manager_name'])) {
            $where[] = ['m.name', 'like', '%' . $param['manager_name'] . '%'];
        }
        //渠道账号
        if (!empty($param['channel_name'])) {
            $where[] = ['r.promote_account', 'like', '%' . $param['channel_name'] . '%'];
        }
        //充值时间
        if (!empty($param['start_time'])) {
            $where[] = ['r.pay_time', ['>', strtotime($param['start_time'])], ['=', 0], 'or'];
        }
        if (!empty($param['end_time'])) {
            $where[] = ['r.pay_time', ['<', strtotime($param['end_time']) + 86400 - 1], ['=', 0], 'or'];
        }
        // 非超管查找包含下级所有数据
        if ($this -> getManagerId() != config('administrators_id')) {
            $statis = new Stat();
            $managerId = $this -> getManagerId();
            $manager_ids = $statis -> getSubManagerIds($managerId);
            $where[] = ['r.manager_id', 'in', empty($manager_ids) ? [] : $manager_ids];
        }
        $where1 = [];
        //分页参数
        if (!empty($page)) {
            $offset = ($page - 1) * $limit;
            $last_id = $mRecharge -> alias('r')
                    -> join(['oa_manager' => 'm'], 'm.id = r.manager_id', 'left')
                    -> field('r.id')
                    -> where($where) -> order('r.id desc') -> group('r.id') -> limit($offset, 1) -> select();
            if (!empty($last_id[0])) {
                $where1[] = ['r.id', '<=', $last_id[0]['id']];
            }
        }
        $result['limit'] = $limit;
        $result['count'] = $mRecharge -> alias('r')
                -> field($field)
                -> join(['oa_manager' => 'm'], 'm.id = r.manager_id', 'left')
                -> where($where)
                -> group('r.id')
                -> count();
        $rechargeList = $mRecharge -> alias('r')
                -> field($field)
                -> join(['oa_manager' => 'm'], 'm.id = r.manager_id', 'left')
                -> where($where)
                -> where($where1)
                -> order('id desc')
                -> group('r.id')
                -> limit($limit)
                -> select();
        if (!empty($rechargeList)) {

            //获取平台列表
            $mPlatform = new mPlatform();
            $platformMap = $mPlatform -> column('id,name');
            foreach ($rechargeList as &$v) {
                $v['platform_name'] = $platformMap[$v['platform_id']];
            }
            $result['data'] = $rechargeList;
        }
        return $result;
    }


    /**
     * @注册明细
     *
     * @author: zsl
     * @since: 2019/6/11 14:24
     */
    public function register($param)
    {
        $result = ['code' => 200, 'msg' => '请求成功', 'data' => []];
        $page = empty($param['page']) ? 1 : $param['page'];
        $limit = empty($param['limit']) ? 1 : $param['limit'];
        $mRegister = new mRegister();
        $field = 'r.id,r.user_account,r.game_name,r.server_name,r.register_time,r.register_ip,m.name manager_name,r.promote_account channel_name';
        $where = [];
        $where1 = [];
        //分页参数
        if (!empty($page)) {
            $offset = ($page - 1) * $limit;
            $last_id = $mRegister -> alias('r') -> field('id')
                    -> where($where) -> order('id desc') -> limit($offset, 1) -> select();
            if (!empty($last_id[0])) {
                $where1[] = ['r.id', '<=', $last_id[0]['id']];
            }
        }
        //玩家账号
        if (!empty($param['user_account'])) {
            $where[] = ['r.user_account', 'like', '%' . $param['user_account'] . '%'];
        }
        //游戏名称
        if (!empty($param['game_name'])) {
            $where[] = ['r.game_name', 'like', '%' . $param['game_name'] . '%'];
        }
        //员工账号
        if (!empty($param['manager_name'])) {
            $where[] = ['m.name', 'like', '%' . $param['manager_name'] . '%'];
        }
        //渠道账号
        if (!empty($param['channel_name'])) {
            $where[] = ['r.promote_account', 'like', '%' . $param['channel_name'] . '%'];
        }
        //注册时间
        if (!empty($param['start_time'])) {
            $where[] = ['r.register_time', ['>', strtotime($param['start_time'])], ['=', 0], 'or'];
        }
        if (!empty($param['end_time'])) {
            $where[] = ['r.register_time', ['<', strtotime($param['end_time']) + 86400 - 1], ['=', 0], 'or'];
        }
        // 非超管查找包含下级所有数据
        if ($this -> getManagerId() != config('administrators_id')) {
            $statis = new Stat();
            $managerId = $this -> getManagerId();
            $manager_ids = $statis -> getSubManagerIds($managerId);
            $where[] = ['r.manager_id', 'in', empty($manager_ids) ? [] : $manager_ids];
        }
        $result['limit'] = $limit;
        $result['count'] = $mRegister -> alias('r')
                -> join(['oa_manager' => 'm'], 'm.id = r.manager_id', 'left')
                -> where($where)
                -> group('r.id')
                -> count();
        $registerList = $mRegister -> alias('r')
                -> field($field)
                -> join(['oa_manager' => 'm'], 'm.id = r.manager_id', 'left')
                -> where($where)
                -> where($where1)
                -> limit($limit)
                -> order('id desc')
                -> group('r.id')
                -> select();
        if (!empty($registerList)) {
            $result['data'] = $registerList;
        }
        return $result;
    }


    /**
     * @注册账号列表
     *
     * @author: zsl
     * @since: 2021/3/8 19:02
     */
    public function viewRegister($param)
    {
        $result = ['code' => 200, 'msg' => '请求成功', 'data' => []];
        $stat = new Stat();
        $manager_ids = $stat -> getSubManagerIds($param['manager_id']);
        $mRegister = new mRegister();
        $where = [];
        $where[] = ['manager_id', '=', $param['manager_id']];
        if (empty($param['start_time']) && empty($param['end_time'])) {
            $where[] = ['register_time', '<', strtotime(date("Y-m-d")) + 86400 - 1];
        } else {
            if (!empty($param['start_time'])) {
                $where[] = ['register_time', ['>', strtotime($param['start_time'])], ['=', 0], 'or'];
            }
            if (!empty($param['end_time'])) {
                $where[] = ['register_time', ['<', strtotime($param['end_time']) + 86400 - 1], ['=', 0], 'or'];
            }
        }
        //查询当前推广员所属渠道
        $mManager = new mManager();
        $mpWhere = [];
        $mpWhere[] = ['promote_account', '=', $param['promote_account']];
        $platformId = $mManager -> platform() -> where($mpWhere) -> value('platform_id');
        $where[] = ['platform_id', '=', $platformId];
        //查询注册数据
        $registerList = $mRegister -> where($where) -> order('id desc') -> column('user_account');
        if ($registerList) {
            $result['data'] = $registerList;
        }
        return $result;
    }


    public function viewRecharge($param)
    {
        $result = ['code' => 200, 'msg' => '请求成功', 'data' => []];
        $statis = new Stat();
        $manager_ids = $statis -> getSubManagerIds($param['manager_id']);
        $mRecharge = new mRecharge();
        $field = 'user_account,game_name,cost_amount,total_amount,promote_account';
        $where = [];
        $where[] = ['manager_id', '=', $param['manager_id']];
        if (empty($param['start_time']) && empty($param['end_time'])) {
            $where[] = ['pay_time', '<', strtotime(date("Y-m-d")) + 86400 - 1];
        } else {
            if (!empty($param['start_time'])) {
                $where[] = ['pay_time', ['>', strtotime($param['start_time'])], ['=', 0], 'or'];
            }
            if (!empty($param['end_time'])) {
                $where[] = ['pay_time', ['<', strtotime($param['end_time']) + 86400 - 1], ['=', 0], 'or'];
            }
        }
        //查询当前推广员所属渠道
        $mManager = new mManager();
        $mpWhere = [];
        $mpWhere[] = ['promote_account', '=', $param['promote_account']];
        $platformId = $mManager -> platform() -> where($mpWhere) -> value('platform_id');
        $where[] = ['platform_id', '=', $platformId];
        $rechargeList = $mRecharge -> field($field) -> where($where) -> order('id desc') -> select();
        if ($rechargeList) {
            $result['data'] = $rechargeList;
        }
        return $result;
    }


}
