<?php

namespace app\common\logic;

use app\common\api\PlatformApi;
use app\common\model\Manager as mManager;
use app\common\model\Platform as mPlatform;

class Game extends Base
{


    /**
     * @游戏中心(可申请游戏)
     *
     * @author: zsl
     * @since: 2021/3/10 14:16
     */
    public function center($param)
    {
        $result = ['code' => 200, 'msg' => '请求成功', 'data' => []];
        // 获取当前账号绑定渠道信息
        $managerId = $this -> getManagerId();
        $mManager = new mManager();
        $field = "id,manager_id,platform_id,promote_account";
        $where = [];
        $where[] = ['manager_id', '=', $managerId];
        if (!empty($param['platform_id'])) {
            $where[] = ['platform_id', '=', $param['platform_id']];
        }
        $bindInfo = $mManager -> platform() -> field($field) -> where($where) -> order('id') -> find();
        if (empty($bindInfo)) {
            $result['code'] = 0;
            $result['msg'] = '暂未绑定该渠道';
            return $result;
        }
        //调用可申请游戏接口
        $param['platform_id'] = $bindInfo['platform_id'];
        $param['promote_account'] = $bindInfo['promote_account'];
        $api = new PlatformApi();
        $gameRes = $api -> check($param) -> game($param);
        if ($gameRes['code'] == 0) {
            $result['code'] = 0;
            $result['msg'] = $gameRes['msg'];
            return $result;
        }
        //游戏列表写入平台id
        if (!empty($gameRes['data'])) {
            foreach ($gameRes['data'] as $k => $v) {
                $gameRes['data'][$k]['platform_id'] = $param['platform_id'];
            }
        }
        $result['data'] = $gameRes['data'];
        $result['page'] = $gameRes['page'];
        $result['limit'] = $gameRes['limit'];
        $result['count'] = $gameRes['count'];
        return $result;
    }


    /**
     * @申请游戏
     *
     * @author: zsl
     * @since: 2021/3/11 10:10
     */
    public function apply($param)
    {
        $result = ['code' => 200, 'msg' => '申请成功', 'data' => []];
        // 获取当前账号绑定渠道信息
        $managerId = $this -> getManagerId();
        $mManager = new mManager();
        $field = "id,manager_id,platform_id,promote_account";
        $where = [];
        $where[] = ['manager_id', '=', $managerId];
        $where[] = ['platform_id', '=', $param['platform_id']];
        $mpInfo = $mManager -> platform() -> field($field) -> where($where) -> find();
        if (empty($mpInfo)) {
            $result['code'] = 0;
            $result['msg'] = '账号未绑定渠道';
            return $result;
        }
        $param['promote_account'] = $mpInfo['promote_account'];
        $api = new PlatformApi();
        $applyRes = $api -> check($param) -> apply($param);
        if ($applyRes['code'] == 0) {
            $result['code'] = 0;
            $result['msg'] = $applyRes['msg'];
            return $result;
        }
        $result['data'] = $applyRes['data'];
        return $result;
    }


    /**
     * @我的游戏
     *
     * @author: zsl
     * @since: 2021/3/11 11:20
     */
    public function my($param)
    {
        $result = ['code' => 200, 'msg' => '请求成功', 'data' => []];
        // 获取当前账号绑定渠道信息
        $managerId = $this -> getManagerId();
        $mManager = new mManager();
        $field = "id,manager_id,platform_id,promote_account";
        $where = [];
        $where[] = ['manager_id', '=', $managerId];
        if (!empty($param['platform_id'])) {
            $where[] = ['platform_id', '=', $param['platform_id']];
        }
        $bindInfo = $mManager -> platform() -> field($field) -> where($where) -> order('id') -> find();
        if (empty($bindInfo)) {
            $result['code'] = 0;
            $result['msg'] = '暂未绑定该渠道';
            return $result;
        }
        //调用我的游戏接口
        $param['platform_id'] = $bindInfo['platform_id'];
        $param['promote_account'] = $bindInfo['promote_account'];
        $api = new PlatformApi();
        $myRes = $api -> check($param) -> my($param);
        if ($myRes['code'] == 0) {
            $result['code'] = 0;
            $result['msg'] = $myRes['msg'];
            return $result;
        }
        //查询平台名称
        $mPlatform = new mPlatform();
        $pWhere = [];
        $pWhere[] = ['id', '=', $param['platform_id']];
        $platform_name = $mPlatform -> where($pWhere) -> value('name');
        if (!empty($myRes['data'])) {
            foreach ($myRes['data'] as $k => $v) {
                $myRes['data'][$k]['platform_id'] = $param['platform_id'];
                $myRes['data'][$k]['platform_name'] = $platform_name;
            }
        }
        $result['data'] = $myRes['data'];
        $result['page'] = $myRes['page'];
        $result['limit'] = $myRes['limit'];
        $result['count'] = $myRes['count'];
        return $result;
    }


    /**
     * @渠道打包
     *
     * @author: zsl
     * @since: 2021/3/11 16:15
     */
    public function package($param)
    {
        $result = ['code' => 200, 'msg' => '已加入打包队列', 'data' => []];
        // 获取当前账号绑定渠道信息
        $managerId = $this -> getManagerId();
        $mManager = new mManager();
        $field = "id,manager_id,platform_id,promote_account";
        $where = [];
        $where[] = ['manager_id', '=', $managerId];
        $where[] = ['platform_id', '=', $param['platform_id']];
        $bindInfo = $mManager -> platform() -> field($field) -> where($where) -> order('id') -> find();
        if (empty($bindInfo)) {
            $result['code'] = 0;
            $result['msg'] = '暂未绑定该渠道';
            return $result;
        }
        $param['promote_account'] = $bindInfo['promote_account'];
        //请求打包接口
        $api = new PlatformApi();
        $res = $api -> check($param) -> package($param);
        if ($res['code'] == 0) {
            $result['code'] = 0;
            $result['msg'] = $res['msg'];
            return $result;
        }
        return $result;
    }

}