<?php

namespace app\common\logic;

use app\common\model\Honor as mHonor;
use app\common\model\HonorApply as mHonorApply;
use app\common\model\Manager as mManager;
use app\common\model\Welfare as mWelfare;

class Index extends Base
{


    /**
     * @后台首页
     *
     * @author: zsl
     * @since: 2021/3/16 11:48
     */
    public function homePage($param)
    {
        $result = ['code' => 200, 'msg' => '请求成功', 'data' => []];
        //用户信息
        $result['data']['manager_info'] = $this -> managerInfo();
        //我的福利
        $result['data']['welfare'] = $this -> welfare();
        //数据图表
        $result['data']['chart'] = $this -> chart();
        //建议反馈
        $result['data']['managerList'] = $this -> managerList();
        //网站信息
        $result['data']['site_info'] = $this -> siteInfo();
        $result['data']['is_truncate'] = is_truncate() ? 1 : 0;
        return $result;
    }


    /**
     * @推荐游戏列表
     *
     * @author: zsl
     * @since: 2021/3/24 13:48
     */
    public function recommendGame($param)
    {
        $url = config('api.xigu.domain') . config('api.xigu.recommend_game');
        $data = json_decode(curl($url, $param), true);
        return $data;
    }

    /**
     * @点击
     *
     * @author: zsl
     * @since: 2021/4/1 9:25
     */
    public function clickGame($param)
    {
        $result = ['code' => 200, 'msg' => '请求成功'];
        $url = config('api.xigu.domain') . config('api.xigu.click_game');
        $data = json_decode(curl($url, $param), true);
        if (empty($data)) {
            $result['code'] = 0;
            $result['msg'] = '请求失败';
            return $result;
        }
        return $result;
    }


    /**
     * @获取用户信息
     *
     * @author: zsl
     * @since: 2021/3/16 11:52
     */
    private function managerInfo()
    {
        $managerId = $this -> getManagerId();
        $field = 'm.id manager_id,d.id as department_id,d.pid as department_pid,d.name as department_name,h.name as honor_name,h.honor_num,
        m.name as manager_name,m.avatar,mh.total_honor_num,mh.use_honor_num,mh.current_honor_num,m.entry_date';
        $where = [];
        $where[] = ['m.status', 'in', '0,1'];
        $where[] = ['m.id', '=', $managerId];
        $mManager = new mManager();
        $manager_info = $mManager -> alias('m')
                -> join(['oa_manager_item' => 'mi'], 'm.id = mi.manager_id', 'left')
                -> join(['oa_department' => 'd'], 'mi.department_id = d.id', 'left')
                -> join(['oa_manager_honor' => 'mh'], 'm.id = mh.manager_id', 'left')
                -> join(['oa_honor' => 'h'], 'mh.honor_id = h.id', 'left')
                -> field($field)
                -> where($where)
                -> find() -> toArray();
        $manager_info['avatar'] = get_image_url($manager_info['avatar']);
        //升级所需荣誉值
        $mHonor = new mHonor();
        $map = [];
        $map[] = ['honor_num', 'gt', empty($manager_info['honor_num']) ? 0 : $manager_info['honor_num']];
        $map[] = ['status', 'in', [0, 1]];
        $next_honor_num = $mHonor -> where($map) -> order('honor_num') -> value('honor_num');
        if (!empty($next_honor_num)) {
            $manager_info['need_honor_num'] = $next_honor_num - $manager_info['total_honor_num'];
        } else {
            $manager_info['need_honor_num'] = 0;
        }
        // 荣誉名称
        $mHonorName = $mHonor -> where('status', 'in', '0,1') -> column('id,name');
        //超过人数
        $hmap = [];
        $hmap[] = ['total_honor_num', '<', empty($manager_info['total_honor_num']) ? 0 : $manager_info['total_honor_num']];
        $manager_info['exceed'] = $mManager -> honor() -> where($hmap) -> count();
        //已获得特权
        $mHonorApply = new mHonorApply();
        $privilege = $mHonorApply -> where(['manager_id' => $managerId, 'status' => 3]) -> column('honor_id,privilege,status');
        $privilege_arr = [];
        if (!empty($privilege)) {
            foreach ($privilege as $v) {
                $privilege_arr = array_merge($privilege_arr, json_decode($v['privilege'], true));
                $status = $v['status'] == 1 ? '通过待发放' : ($v['status'] == 2 ? '已驳回' : ($v['status'] == 3 ? '已发放' : '审核中'));
                $type = $mHonorName[$v['honor_id']];
                if (!empty($privilege_arr)) {
                    foreach ($privilege_arr as &$vo) {
                        $vo['icon_url'] = get_image_url(empty($vo['icon']) ? '' : $vo['icon']);
                        $vo['type_name'] = $type;
                        $vo['status'] = $status;
                    }
                }
            }
        }
        $manager_info['privilege'] = $privilege_arr;
        //即将获得特权
        $next_privilege = $mHonor -> where($map) -> order('honor_num') -> value('privilege');
        $next_name = $mHonor -> where($map) -> order('honor_num') -> value('name');
        $next_privilege = json_decode($next_privilege, true);
        if (!empty($next_privilege)) {
            foreach ($next_privilege as &$item) {
                $item['icon_url'] = get_image_url(empty($item['icon']) ? '' : $item['icon']);
                $item['type_name'] = $next_name;
            }
        }
        $manager_info['next_privilege'] = $next_privilege;
        //用户业绩
        $beginYesterday = mktime(0, 0, 0, date('m'), date('d') - 1, date('Y'));
        $endYesterday = mktime(0, 0, 0, date('m'), date('d'), date('Y')) - 1;
        $beginThismonth = mktime(0, 0, 0, date('m'), 1, date('Y'));
        $endThismonth = mktime(23, 59, 59, date('m'), date('t'), date('Y'));
        $stat = new Stat();
        $total_achievements = $stat -> data($managerId);
        $yesterday_achievements = $stat -> data($managerId, $beginYesterday, $endYesterday);
        $month_achievements = $stat -> data($managerId, $beginThismonth, $endThismonth);
        $manager_info['achievements'] = [];
        $manager_info['achievements']['total_achievements'] = $total_achievements['recharge_pay_sum'];
        $manager_info['achievements']['yesterday_achievements'] = $yesterday_achievements['recharge_pay_sum'];
        $manager_info['achievements']['month_achievements'] = $month_achievements['recharge_pay_sum'];
        //入职到目前天数
        $entry_day = (int) ((time() - strtotime($manager_info['entry_date'])) / 86400);
        $manager_info['entry_day'] = $entry_day;
        return $manager_info ? $manager_info : [];
    }


    /**
     * @福利列表
     *
     * @author: zsl
     * @since: 2019/6/10 10:37
     */
    private function welfare()
    {
        $mWelfare = new mWelfare();
        $field = 'id,name,required';
        $where = [];
        $where[] = ['status', '=', '1'];
        $where[] = ['start_time', ['lt', time()], ['=', 0], 'or'];
        $where[] = ['end_time', ['gt', time()], ['=', 0], 'or'];
        $welfareList = $mWelfare -> field($field) -> where($where) -> order('create_time') -> select();
        return $welfareList ? $welfareList : [];
    }


    /**
     * @管理员列表
     *
     * @author: zsl
     * @since: 2021/3/16 14:17
     */
    private function managerList()
    {
        $mManager = new mManager();
        $field = 'm.id,m.name,r.name as role_name,m.realname,m.qq,m.avatar,m.duty';
        $where = [];
        $where[] = ['m.status', '=', 1];
        $where[] = ['r.status', '=', 1];
        $managerList = $mManager -> alias('m')
                -> field($field)
                -> join(['oa_manager_auth' => 'ma'], 'm.id = ma.manager_id', 'left')
                -> join(['oa_role' => 'r'], 'ma.role_id = r.id', 'left')
                -> where($where)
                -> limit(4)
                -> order('m.create_time')
                -> select() -> toArray();
        if (!empty($managerList)) {
            foreach ($managerList as &$item) {
                $item['avatar_url'] = get_image_url($item['avatar']);
            }
        }
        return $managerList ? $managerList : [];
    }

    /**
     * @数据图表
     *
     * @author: zsl
     * @since: 2021/3/18 13:55
     */
    private function chart()
    {
        $result = [];
        $managerId = $this -> getManagerId();
        //今日数据
        $today_start = strtotime(date('Y-m-d') . '00:00:00');
        $today_end = strtotime(date('Y-m-d') . '23:59:59');
        $stat = new Stat();
        $today = $stat -> data($managerId, $today_start, $today_end);
        //昨日数据
        $yesterday_start = strtotime(date("Y-m-d", strtotime("-1 day")));
        $yesterday_end = strtotime(date("Y-m-d", strtotime("-1 day"))) + 86399;
        $yesterday = $stat -> data($managerId, $yesterday_start, $yesterday_end);
        //近7日数据
        $seven_day_start = strtotime(date("Y-m-d", strtotime("-7 day")));
        $seven_day_end = time();
        $seven_day = $stat -> data($managerId, $seven_day_start, $seven_day_end);
        //近30天数据
        $thirty_day_start = strtotime(date("Y-m-d", strtotime("-30 day")));
        $thirty_day_end = time();
        $thirty_day = $stat -> data($managerId, $thirty_day_start, $thirty_day_end);
        //全部数据
        $all = $stat -> data($managerId);
        $result['today'] = $today;
        $result['yesterday'] = $yesterday;
        $result['seven_day'] = $seven_day;
        $result['thirty_day'] = $thirty_day;
        $result['all'] = $all;
        return $result;
    }

    /**
     * @网站信息
     *
     * @author: zsl
     * @since: 2021/4/1 13:34
     */
    private function siteInfo()
    {
        $data = get_option('site_info');
        if (!empty($data['add_oil'])) {
            $index = array_rand($data['add_oil'], 1);
            $data['add_oil'] = $data['add_oil'][$index]['add_oil'];
        } else {
            $data = [];
            $data['add_oil'] = "";
        }
        return $data;
    }

}
