<?php
/**
 * @Copyright (c) 2019  XIGU Inc. All rights reserved.
 * @Link https://www.vlcms.com
 * @License江苏溪谷网络科技有限公司版权所有
 */

namespace app\common\logic;

use app\common\model\Log as mLog;

class Log
{
    /**
     * @添加日志
     *
     * @author: imdong
     * @since: 2019/3/21 11:10
     */
    public function create($manager_id, $module, $controller, $action)
    {
        $mLog = new mLog();
        $mLog -> manager_id = $manager_id;
        $mLog -> module = $module;
        $mLog -> controller = $controller;
        $mLog -> action = $action;
        $mLog -> param = json_encode(request() -> param(), JSON_UNESCAPED_UNICODE);
        $mLog -> save();
    }

    /**
     * @删除日志
     *
     * @author: imdong
     * @since: 2019/3/21 11:10
     */
    public function delete()
    {
        $result = ['code' => 200, 'msg' => '', 'data' => []];
        $param = request() -> post();
        if (empty($param['id'])) {
            $result['code'] = 1004;
            $result['msg'] = '缺少日志标识';
            return $result;
        }
        $mLog = new mLog();
        $mLog -> where('id', '=', $param['id']) -> delete();
        $result['msg'] = '删除成功';
        return $result;
    }

    /**
     * @清空日志
     *
     * @author: imdong
     * @since: 2019/3/21 11:10
     */
    public function drop()
    {
        $result = ['code' => 200, 'msg' => '', 'data' => []];
        $mLog = new mLog();
        $mLog -> delete();
        $result['msg'] = '清空成功';
        return $result;
    }

}
