<?php

namespace app\common\logic;

class Rank extends Base
{


    /**
     * @昨日排行
     *
     * @author: zsl
     * @since: 2021/3/29 14:58
     */
    public function yesterday($param)
    {
        $result = ['thead' => ["排名", "员工", "业绩"], 'lists' => []];
        $limit = empty($param['limit']) ? 10 : $param['limit'];
        $start = strtotime(date("Y-m-d", strtotime("-1 day")));
        $end = strtotime(date("Y-m-d", strtotime("-1 day"))) + 86399;
        $lists = $this -> getRankData($start, $end, $limit);
        $result['lists'] = $lists;
        return $result;
    }

    /**
     * @日排行
     *
     * @author: zsl
     * @since: 2021/3/9 9:28
     */
    public function day($param)
    {
        $result = ['thead' => ["排名", "员工", "业绩"], 'lists' => []];
        $limit = empty($param['limit']) ? 10 : $param['limit'];
        $start = strtotime(date('Y-m-d') . '00:00:00');
        $end = strtotime(date('Y-m-d') . '23:59:59');
        $lists = $this -> getRankData($start, $end, $limit);
        $result['lists'] = $lists;
        return $result;
    }

    /**
     * @周排行
     *
     * @author: zsl
     * @since: 2021/3/9 10:14
     */
    public function week($param)
    {
        $result = ['thead' => ["排名", "员工", "业绩"], 'lists' => []];
        $limit = empty($param['limit']) ? 10 : $param['limit'];
        $start = mktime(0, 0, 0, date('m'), date('d') - date('w') + 1, date('Y'));
        $end = mktime(23, 59, 59, date('m'), date('d') - date('w') + 7, date('Y'));
        $lists = $this -> getRankData($start, $end, $limit);
        $result['lists'] = $lists;
        return $result;
    }

    /**
     * @月排行
     *
     * @author: zsl
     * @since: 2021/3/9 10:19
     */
    public function month($param)
    {
        $result = ['thead' => ["排名", "员工", "业绩"], 'lists' => []];
        $limit = empty($param['limit']) ? 10 : $param['limit'];
        $start = mktime(0, 0, 0, date('m'), 1, date('Y'));
        $end = mktime(23, 59, 59, date('m'), date('t'), date('Y'));
        $lists = $this -> getRankData($start, $end, $limit);
        $result['lists'] = $lists;
        return $result;
    }

    /**
     * @季排行
     *
     * @author: zsl
     * @since: 2021/3/9 10:19
     */
    public function season($param)
    {
        $result = ['thead' => ["排名", "员工", "业绩"], 'lists' => []];
        $limit = empty($param['limit']) ? 10 : $param['limit'];
        $season = ceil(date('n') / 3);
        $start = mktime(0, 0, 0, $season * 3 - 3 + 1, 1, date('Y'));
        $end = mktime(23, 59, 59, $season * 3, date('t', mktime(0, 0, 0, $season * 3, 1, date("Y"))), date('Y'));
        $lists = $this -> getRankData($start, $end, $limit);
        $result['lists'] = $lists;
        return $result;
    }


    /**
     * @获取排行数据
     *
     * @author: zsl
     * @since: 2021/3/9 9:54
     */
    private function getRankData($start_time, $end_time, $limit)
    {

        $stat = new Stat();
        // 获取下级所有员工
        $managerId = $this -> getManagerId();
        if ($managerId == config('administrators_id')) {
            $managerIds = $stat -> getSubManagerIds(0);
        } else {
            $managerIds = $stat -> getSubManagerIds($this -> getManagerId());
        }
        //获取所有员工账号
        $managerLists = get_manager_lists();
        //获取不包含下级所有业绩数据
        $data = [];
        foreach ($managerIds as $k => $managerId) {
            if ($managerId != 0 && $managerId != config('administrators_id')) {
                // 获取员工自身业绩数据
                $data[$k] = $stat -> data($managerId, $start_time, $end_time, false);
                $data[$k]['manager_id'] = $managerId;
                $data[$k]['manager_name'] = $managerLists[$managerId];
            }
        }
        $data = array_merge($data);
        //根据字段recharge_pay_sum对数组$data进行降序排列
        $recharge_pay_sum = array_column($data, 'recharge_pay_sum');
        array_multisort($recharge_pay_sum, SORT_DESC, $data);
        $data = array_slice($data, 0, $limit);
        return $data;
    }


}
