<?php
/**
 * @Copyright (c) 2019  XIGU Inc. All rights reserved.
 * @Link https://www.vlcms.com
 * @License江苏溪谷网络科技有限公司版权所有
 */

namespace app\common\logic;

use app\common\model\Welfare as mWelfare;
use app\common\validate\Welfare as vWelfare;

class Welfare extends Base
{


    /**
     * @我的福利列表
     *
     * @author: zsl
     * @since: 2019/6/5 17:06
     */
    public function lists($param)
    {
        $result = ['code' => 200, 'msg' => '请求成功', 'data' => []];
        $page = empty($param['page']) ? 1 : $param['page'];
        $limit = empty($param['limit']) ? 1 : $param['limit'];
        $field = 'w.*,m.name as manager_name';
        $where = [];
        $where[] = ['w.status', 'in', '0,1'];
        $mWelare = new mWelfare();
        $result['count'] = $mWelare -> alias('w') -> where($where) -> count();
        $result['page'] = $page;
        $result['limit'] = $limit;
        $welareLists = $mWelare -> alias('w')
                -> field($field)
                -> join(['oa_manager' => 'm'], 'w.manager_id = m.id', 'left')
                -> where($where)
                -> page($page, $limit)
                -> order('w.create_time')
                -> select();
        if (!empty($welareLists)) {
            $result['data'] = $welareLists;
        }
        return $result;
    }

    /**
     * @添加福利
     *
     * @author: zsl
     * @since: 2019/6/5 17:11
     */
    public function create($param)
    {
        $result = ['code' => 200, 'msg' => '添加成功', 'data' => []];
        $vWelfare = new vWelfare();
        if (!$vWelfare -> scene('create') -> check($param)) {
            $result['code'] = 16001;
            $result['msg'] = $vWelfare -> getError();
            return $result;
        }
        try {
            $mWelfare = new mWelfare();
            $mWelfare -> name = $param['name'];
            $mWelfare -> required = $param['required'];
            $mWelfare -> start_time = empty($param['start_time']) ? 0 : $param['start_time'];
            $mWelfare -> end_time = empty($param['end_time']) ? 0 : $param['end_time'];
            $mWelfare -> manager_id = $this -> getManagerId();
            $mWelfare -> status = 1;
            $mWelfare -> isUpdate(false) -> save();

        } catch (\Exception $e) {
            $result['code'] = 16002;
            $result['msg'] = $this -> errorCode(16002);
        }
        return $result;
    }


    /**
     * @更新福利
     *
     * @author: zsl
     * @since: 2019/6/5 17:49
     */
    public function update($param)
    {
        $result = ['code' => 200, 'msg' => '更新成功', 'data' => []];
        $vWelfare = new vWelfare();
        if (!$vWelfare -> scene('update') -> check($param)) {
            $result['code'] = 16001;
            $result['msg'] = $vWelfare -> getError();
            return $result;
        }
        $mWelfare = $this -> detail(['id' => $param['id']]);
        if (empty($mWelfare)) {
            $result['code'] = 16005;
            $result['msg'] = $this -> errorCode(16005);
            return $result;
        }
        try {
            $mWelfare -> name = $param['name'];
            $mWelfare -> required = $param['required'];
            $mWelfare -> manager_id = $this -> getManagerId();
            if (isset($param['start_time'])) {
                $mWelfare -> start_time = empty($param['start_time']) ? 0 : $param['start_time'];
            }
            if (isset($param['end_time'])) {
                $mWelfare -> end_time = empty($param['end_time']) ? 0 : $param['end_time'];
            }
            $mWelfare -> isUpdate(true) -> save();
        } catch (\Exception $e) {
            $result['code'] = 16003;
            $result['msg'] = $this -> errorCode(16003);
        }
        return $result;
    }

    /**
     * @福利详情
     *
     * @author: zsl
     * @since: 2019/6/5 17:51
     */
    public function detail($param)
    {
        $detail = [];
        if (!empty($param['id'])) {
            $where = [];
            $where[] = ['id', '=', $param['id']];
            $where[] = ['status', 'in', '0,1'];
            $mWelfare = new mWelfare();
            $detail = $mWelfare -> where($where) -> find();
        }
        return $detail ? $detail : [];
    }


    public function delete($param)
    {
        $result = ['code' => 200, 'msg' => '福利删除成功', 'data' => []];
        $where = [];
        if (!empty($param['id'])) {
            $where[] = ['id', '=', $param['id']];
        }
        if (!$this -> reStatus($where, - 1)) {
            $result['code'] = 16004;
            $result['msg'] = $this -> errorCode(16004);
        }
        return $result;
    }


    private function reStatus($where, $status)
    {
        try {
            $mWelfare = new mWelfare();
            $mWelfare -> where($where) -> update(['status' => $status]);
            return true;
        } catch (\Exception $e) {
            return false;
        }
    }


    private function errorCode($code)
    {
        $errorCode = [
                16001 => '',
                16002 => '添加福利失败',
                16003 => '更新福利失败',
                16004 => '删除福利失败',
                16005 => '福利不存在或已删除',
        ];
        return empty($errorCode[$code]) ? '系统繁忙,请稍候再试' : $errorCode[$code];
    }

}