<?php
/**
 * @Copyright (c) 2019  XIGU Inc. All rights reserved.
 * @Link https://www.vlcms.com
 * @License江苏溪谷网络科技有限公司版权所有
 */

namespace app\common\validate;

use think\Validate;

class Honor extends Validate
{


    protected $rule = [
            'name' => 'require|unique:honor',
            'rank' => 'require',
            'honor_num' => 'require|number',
    ];

    protected $message = [
            'name' => [
                    'require' => '缺少name',
                    'unique' => '荣誉名称已存在',
            ],
            'rank.require' => '缺少rank',
            'honor_num' => [
                    'require' => '缺少honor_num',
                    'number' => '请填写正确荣誉值',
            ],
    ];


    public function sceneCreate()
    {
        return $this -> only(['name', 'rank', 'honor_num']);
    }

    public function sceneUpdate()
    {
        return $this -> only(['name', 'rank', 'honor_num', 'id'])
                -> append('id', 'require');
//                ->remove('name','unique');
    }

}