<?php
/**
 * @Copyright (c) 2019  XIGU Inc. All rights reserved.
 * @Link https://www.vlcms.com
 * @License江苏溪谷网络科技有限公司版权所有
 */

namespace app\common\validate;

use think\Validate;

class ManagerBank extends Validate
{


    protected $rule = [
            'manager_id' => 'require',
            'mobile' => 'require|mobile',
            'card_num' => 'require|number',
            'bank_name' => 'require',
            'card_name' => 'require|chs',
            'branch' => 'require|chsDash',
            'alipay_account' => 'require',
            'alipay_name' => 'require|chs',
    ];

    protected $message = [
            'manager_id' => [
                    'require' => '缺少manager_id',
            ],
            'mobile' => [
                    'require' => '请填写银行预留手机号',
                    'mobile' => '银行预留手机号格式错误',
            ],
            'card_num' => [
                    'require' => '请填写银行卡号',
                    'number' => '银行卡号格式错误',
            ],
            'bank_name' => [
                    'require' => '请填写收款银行',
            ],
            'card_name' => [
                    'require' => '请填写持卡人姓名',
                    'chs' => '持卡人姓名格式错误',
            ],
            'branch' => [
                    'require' => '请填写开户网点',
                    'chsDash' => '开户网点只能是汉字、字母、数字和下划线_及破折号-',
            ],
            'alipay_account' => [
                    'require' => '请填写支付宝账户',
            ],
            'alipay_name' => [
                    'require' => '请填写支付宝真实姓名',
                    'chs' => '请输入正确的姓名',
            ],
    ];


    public function sceneCreate()
    {
        return $this -> only(['manager_id', 'mobile', 'card_num', 'bank_name', 'card_name', 'branch']);
    }

    public function sceneUpdate()
    {
        return $this -> only(['mobile', 'card_num', 'bank_name', 'card_name', 'branch']);
    }

    public function sceneCreateStaff()
    {
        return $this -> only(['manager_id', 'mobile', 'card_num'])
                -> remove('mobile', 'require')
                -> remove('card_num', 'require');
    }

    public function sceneUpdateBank()
    {
        return $this -> only(['card_num', 'bank_name', 'card_name', 'mobile', 'branch']);
    }

    public function sceneUpdateAlipay()
    {
        return $this -> only(['alipay_account', 'alipay_name']);
    }
}
