<?php
/**
 * gitee: https://github.com/kyle-cao
 * Created by: admin.dadmin.cn
 * User: imdong
 * Date: 2019/1/14
 * Time: 14:42
 */

namespace app\common\validate;

use think\Validate;

class Role extends Validate
{
    protected $rule = [
            'id' => 'require',
            'name' => 'require|unique:role',
    ];
    protected $message = [
            'id.require' => '缺少字段id',
            'name.require' => '请填写角色名称',
            'name.unique' => '角色已存在',
    ];

    public function sceneCreate()
    {
        return $this -> only(['name']);
    }

    public function sceneUpdate()
    {
        return $this -> only(['id', 'name']);
    }

}