<?php
/**
 * @Copyright (c) 2019  XIGU Inc. All rights reserved.
 * @Link https://www.vlcms.com
 * @License江苏溪谷网络科技有限公司版权所有
 */

namespace app\common\validate;

use think\Validate;

class WageDiy extends Validate
{


    protected $rule = [
            'role_id' => 'require',
            'base_wage' => 'require|number',
            'spread' => 'require',
            'statement_date' => 'require',
            'ratio' => 'require',
            'elder_bonus' => 'require',
            'elder_time' => 'require',
    ];
    protected $message = [
            'role_id' => '缺少角色标识',
            'base_wage.require' => '请设置基本工资',
            'base_wage.number' => '请设置正确的基本工资',
            'spread' => '请设置推广人数奖',
            'statement_date' => '请设置出账日期',
            'ratio' => '请设置直充流水消费提成比例',
            'elder_bonus' => '请设置元老业绩奖金',
            'elder_time' => '请设置元老奖金入职时间要求',
    ];

}