<?php
/**
 * @Copyright (c) 2019  XIGU Inc. All rights reserved.
 * @Link https://www.vlcms.com
 * @License江苏溪谷网络科技有限公司版权所有
 */

namespace app\crontab\controller;

use app\common\api\PlatformApi;
use app\common\api\RedisApi;
use app\common\model\Manager;

/**
 * Class Pull
 *
 * 拉取数据类
 *
 * @package app\crontab\controller
 */
class Pull extends Base
{

    private $redis;

    public function __construct()
    {
        parent ::__construct();
        $this -> redis = new RedisApi();
    }


    /**
     * @拉取注册数据
     *
     * @author: zsl
     * @since: 2021/3/3 10:38
     */
    public function register()
    {
        set_time_limit(0);
        if ($this -> redis -> get('register_lock')) {
            return json(['code' => 0, 'msg' => '正在拉取数据,请稍后再试', 'data' => []]);
        }
        //加锁
        $this -> redis -> set('register_lock', '1');
        try {
            //获取所有绑定过账号的员工
            $mManager = new Manager();
            $field = "m.id,mp.platform_id,mp.manager_id,mp.promote_account";
            $where = [];
            $where[] = ['m.status', '=', 1];
            $managerLists = $mManager -> alias('m')
                    -> field($field)
                    -> join(['oa_manager_platform' => 'mp'], 'm.id = mp.manager_id', 'right')
                    -> where($where)
                    -> select();
            if (empty($managerLists)) {
                //解锁
                $this -> redis -> del('register_lock');
                return json(['code' => 0, 'msg' => '请先将员工绑定渠道', 'data' => []]);
            }
            //请求数据
            foreach ($managerLists as $manager) {
                $lastIdKey = "register_last_id_manager_{$manager['id']}_platform_{$manager['platform_id']}";
                $where = [];
                $where[] = ['manager_id', '=', $manager['id']];
                $where[] = ['platform_id', '=', $manager['platform_id']];
                $last_id = $mManager -> platform() -> where($where) -> value('register_last_id');
                //调用接口
                $param = [];
                $param['platform_id'] = $manager['platform_id'];
                $param['promote_account'] = $manager['promote_account'];
                $param['last_id'] = $last_id ? $last_id : 0;
                $api = new PlatformApi();
                $result = $api -> check($param) -> pullRegister($param);
                if (count($result['data']) > 0) {
                    //写入数据到redis
                    $data = $result['data'];
                    foreach ($data as $k => $v) {
                        $saveData = [];
                        $saveData['manager_id'] = $manager['id'];
                        $saveData['platform_id'] = $manager['platform_id'];
                        $saveData['game_id'] = $v['fgame_id'];
                        $saveData['platform_user_id'] = $v['id'];
                        $saveData['game_name'] = $v['fgame_name'];
                        $saveData['user_account'] = $v['account'];
                        $saveData['register_ip'] = $v['register_ip'];
                        $saveData['device_no'] = $v['equipment_num'];
                        $saveData['register_time'] = $v['register_time'];
                        $saveData['promote_id'] = $v['promote_id'];
                        $saveData['promote_account'] = $v['promote_account'];
                        //写入待插入数据
                        $this -> redis -> rPush('register_data', json_encode($saveData));
                        $last_id = $v['id'];
                    }
                }
                //写入最后插入数据id
                $mManager -> platform()
                        -> where(['manager_id' => $manager['id'], 'platform_id' => $manager['platform_id']])
                        -> setField('register_last_id', $last_id);
            }
            //解锁
            $this -> redis -> del('register_lock');
            return json(['code' => 1, 'msg' => '拉取完成', 'data' => []]);
        } catch (\Exception $e) {
            //解锁
            $this -> redis -> del('register_lock');
            return json(['code' => 0, 'msg' => $e -> getMessage(), 'data' => []]);
        }

    }


    /**
     * @拉取充值数据
     *
     * @author: zsl
     * @since: 2021/3/5 10:26
     */
    public function recharge()
    {
        set_time_limit(0);
        if ($this -> redis -> get('recharge_lock')) {
            return json(['code' => 0, 'msg' => '正在拉取数据,请稍后再试', 'data' => []]);
        }
        //加锁
        $this -> redis -> set('recharge_lock', '1');
        try {
            //获取所有绑定过账号的员工
            $mManager = new Manager();
            $field = "m.id,mp.platform_id,mp.manager_id,mp.promote_account";
            $where = [];
            $where[] = ['m.status', '=', 1];
            $managerLists = $mManager -> alias('m')
                    -> field($field)
                    -> join(['oa_manager_platform' => 'mp'], 'm.id = mp.manager_id', 'right')
                    -> where($where)
                    -> select();
            if (empty($managerLists)) {
                //解锁
                $this -> redis -> del('recharge_lock');
                return json(['code' => 0, 'msg' => '请先将员工绑定渠道', 'data' => []]);
            }
            //请求数据
            foreach ($managerLists as $manager) {
                $lastIdKey = "recharge_last_id_manager_{$manager['id']}_platform_{$manager['platform_id']}";
                $where = [];
                $where[] = ['manager_id', '=', $manager['id']];
                $where[] = ['platform_id', '=', $manager['platform_id']];
                $last_id = $mManager -> platform() -> where($where) -> value('recharge_last_id');
                //调用接口
                $param = [];
                $param['platform_id'] = $manager['platform_id'];
                $param['promote_account'] = $manager['promote_account'];
                $param['last_id'] = $last_id ? $last_id : 0;
                $api = new PlatformApi();
                $result = $api -> check($param) -> pullRecharge($param);
                if (count($result['data']) > 0) {
                    //写入数据到redis
                    $data = $result['data'];
                    foreach ($data as $k => $v) {
                        $saveData = [];
                        $saveData['manager_id'] = $manager['id'];
                        $saveData['platform_id'] = $manager['platform_id'];
                        $saveData['platform_order_id'] = $v['id'];
                        $saveData['game_id'] = $v['game_id'];
                        $saveData['game_name'] = $v['game_name'];
                        $saveData['server_id'] = $v['server_id'];
                        $saveData['server_name'] = $v['server_name'];
                        $saveData['user_account'] = $v['user_account'];
                        $saveData['player_name'] = $v['game_player_name'];
                        $saveData['promote_id'] = $v['promote_id'];
                        $saveData['promote_account'] = $v['promote_account'];
                        $saveData['order_no'] = $v['pay_order_number'];
                        $saveData['cost_amount'] = $v['pay_amount'] * 100;
                        $saveData['total_amount'] = $v['cost'] * 100;
                        $saveData['pay_ip'] = $v['spend_ip'];
                        $saveData['pay_time'] = $v['pay_time'];
                        $saveData['pay_way'] = $v['pay_way'];
                        $saveData['pay_way_str'] = $v['pay_way_str'];
                        //写入待插入数据
                        $this -> redis -> rPush('recharge_data', json_encode($saveData));
                        $last_id = $v['id'];
                    }
                }
                //写入最后插入数据id
                $mManager -> platform()
                        -> where(['manager_id' => $manager['id'], 'platform_id' => $manager['platform_id']])
                        -> setField('recharge_last_id', $last_id);
            }
            //解锁
            $this -> redis -> del('recharge_lock');
            return json(['code' => 1, 'msg' => '拉取完成', 'data' => []]);
        } catch (\Exception $e) {
            //解锁
            $this -> redis -> del('recharge_lock');
            return json(['code' => 0, 'msg' => $e -> getMessage(), 'data' => []]);
        }

    }

}

