import axios from "@/api/base";

export default {
    /**
     * 登录相关
     */
    getVerificationCode: data => {
        return axios.post('admin/login/verify', data)
    },
    login: data => {
        return axios.post('admin/login/login', data)
    },
    logout: data => {
        return axios.post('admin/login/logout', data)
    },
    refreshToekn: data => {
        return axios.post('admin/login/refreshToekn', data)
    },
    //清理缓存
    clearNowDataCache: data => {
        return axios.post('admin/index/clearCache', data)
    },
    clearReProduction: data => {
        return axios.post('admin/index/truncate', data)
    },
    // 获取未入库数据
    getUnStockData: data => {
        return axios.post('admin/index/getUnPutCount', data)
    },
    verifyImg: ()=> {
        return axios.defaults.baseURL + '/admin/login/verify'
    },
    uploadAvatar:() => {
        return axios.defaults.baseURL + '/admin/upload/oneImgUpload'
    },
    uploadExcel:() => {
        return axios.defaults.baseURL + '/admin/upload/uploadChannelTpl'
    },
    uploadIcon:() => {
        return axios.defaults.baseURL + '/admin/upload/oneImgUpload'
    },
    uploadImg:() => {
        return axios.defaults.baseURL + '/admin/upload/oneImgUpload'
    },
    uploadPowerIcon: () => {
        return axios.defaults.baseURL + '/admin/upload/oneImgUpload'
    },
    exportExcel:() => {
        return axios.defaults.baseURL + '/admin/wage/exportExcel/?'
    },
    // 获取网站头部的name
    getTitleInternet:(data) => {
        return  axios.post('home/index/siteName ', data)
    },
};