import axios from "@/api/base.js";

export default {
    /**
     * 员工列表相关
     */
    getAdminList: data => {
        return axios.post('admin/staff/lists', data);
    },
    addAdminList: data => {
        return axios.post('admin/staff/create', data)
    },
    getAdminDetail: data => {
        return axios.post('/admin/staff/detail', data)
    },
    editAdminInfo: data => {
        return axios.post('admin/staff/update', data)
    },
    disabledAdmin: data => {
        return axios.post('admin/staff/disable', data)
    },
    enableAdmin: data => {
        return axios.post('admin/staff/enable', data)
    },
    deleteAdmin: data => {
        return axios.post('admin/manager/delete', data)
    },
    getTypeNewListInfo: data => {
        return axios.post('admin/notic/categoryNotic', data)
    },
    getManagerSelectList: data => {
      return axios.post('admin/manager/select_lists', data)
    },
    getManagerDetail: data => {
      return axios.post('admin/staff/look ', data)
    },
    getManagerAccount: () => {
      return axios.post('admin/manager/info')
    },
    updateManagerAccount: data => {
      return axios.post('admin/manager/information_update', data)
    },
    // 更新基本信息
    updateBaseInfoData: data => {
        return axios.post('admin/manager/saveInfo', data)
    },
    // 更新银行信息
    updateBankAliData: data => {
        return axios.post('admin/manager/saveBankInfo', data)
    },
    // 更新密码
    updatePsdData: data => {
        return axios.post('admin/manager/modifypassword', data)
    },
    // 更新二级密码
    updateReconfirmPsd: data => {
        return axios.post('admin/manager/modifyVerifyPassword', data)
    },
    /**
     * 员工平台相关
     */
    getManagerChannelList: data => {
      return axios.post('admin/staff/bindPlatformLists', data)
    },
    getManagerChannelBind: data => {
      return axios.post('admin/staff/bindPlatform', data)
    },
    getManagerChannelDelete: data => {
      return axios.post('admin/staff/unbindPlatform', data)
    },
    getManagerSelectChannelList: data => {
      return axios.post('admin/manager/channel_select_lists', data)
    },
    /**
     * 部们列表相关
     */
    getDepartMentList: data => {
        return axios.post('admin/department/lists', data)
    },


    /**
     * 角色权限相关
     */
    getRoleList: data => {
        return axios.post('admin/role/lists', data);
    },
    addRoleInfo: data => {
        return axios.post('admin/role/add', data);
    },
    editRoleInfo: data => {
        return axios.post('admin/role/edit', data);
    },
    getRoleDetail: data => {
        return axios.post('admin/role/detail', data);
    },
    getAllAuth: data => {
        return axios.post('admin/auth/lists', data)
    },
    getUserMenu: data => {
        return axios.post('admin/auth/menu', data)
    },
    getAuthRole: data => {
        return axios.post('admin/role/auth', data)
    },
    setRuleRole: data => {
        return axios.post('admin/role/rule', data)
    },
    disabledRuleRole: data => {
        return axios.post('admin/role/disable', data)
    },
    enabledRuleRole: data => {
        return axios.post('admin/role/enable', data)
    },


    /**
     * 商务专员列表相关
     */
    getSaleList: data => {
        return axios.post('admin/business/lists', data);
    },
    getSaleSelectList: data => {
        return axios.post('admin/business/selectLists', data);
    },
    getSaleListDetail: data => {
        return axios.post('admin/business/detail', data);
    },
    addSaleList: data => {
        return axios.post('admin/business/create', data);
    },
    editSaleList: data => {
        return axios.post('admin/business/update', data)
    },
    enableSaleList: data => {
        return axios.post('admin/business/enable', data)
    },
    disableSaleList: data => {
        return axios.post('admin/business/disable', data)
    },
    /**
     * 公会列表相关
     */
    getGuildList: data => {
        return axios.post('admin/studio/lists', data);
    },
    addGuildInfo: data => {
        return axios.post('admin/studio/create', data);
    },
    editGuildInfo: data => {
        return axios.post('admin/studio/update', data);
    },
    enableGuild: data => {
        return axios.post('admin/department/enable', data);
    },
    disableGuildInfo: data => {
        return axios.post('admin/department/disable', data);
    },
    getAdminGuildDetail: data => {
        return axios.post('admin/studio/detail', data);
    },
    getBusinessStudio: data => {
        return axios.post('admin/studio/businessStudio', data);
    },
    getAllTeamList: data => {
        return axios.post('admin/studio/departmentTree', data)
    },
    getStudioSelectList: data => {
      return axios.post('admin/studio/select_lists', data)
    },
    /**
     * 公会平台相关
     */
    getStudioChannelList: data => {
      return axios.post('admin/studio/channel', data)
    },
    getStudioChannelBind: data => {
      return axios.post('admin/studio/channelBind', data)
    },
    getStudioChannelDelete: data => {
      return axios.post('admin/studio/channelDelete', data)
    },
    /**
     * 自定义工资相关
     */
    getCustomSalary: data => {
        return axios.post('admin/wage_diy/lists', data);
    },
    getCustomSalaryDetail: data => {
        return axios.post('admin/wage_diy/detail', data);
    },
    editListCustomSalaryInfo: data => {
        return axios.post('admin/wage_diy/update', data)
    },
    editDetailCustomSalaryInfo: data => {
        return axios.post('admin/wage_diy/update', data)
    },
};