/**
 * *权限控制 - 路由跳转前 设置（暂不需要）
 * 管理员角色id说明：
 * ********管理员    -> 1
 * ********商务专员  -> 2
 * ********团长      -> 3
 * ********组长      -> 4
 * ********推广员    -> 5
 */

import router from '@/router'
import store from '@/store/index'
import getSessionid from '@/assets/js/getSessionid'
import { Message } from 'iview'
import { getStore,isFirstLogin } from '@/utils/utils'
/* 路由跳转之前 */
router.beforeEach((to, from, next) => {
  let toName = to.name
  let toType = to.meta.Btype
  let toStype = to.meta.Stype
  let auth = to.meta.reqAuth
  const changeRoute = () => {
    if (toStype) {
      return store.commit('changeSaveRoute', {
        routeType: toType,
        activeSubmenu: [toStype],
        activeMenuItem: toName
      })
    }
  }
  if (!toName) {
    Message.warning('页面不存在')
    next('/err_404')
  }
  if (toName) {
    // 获取网站ico
    // if(!!!window.localStorage.getItem('logo_ico')){
    //   store.dispatch('getLogoIcoInfo')
    // }
    
    // 是否想去登录页面或404页面
    let toLoginOrErr = toName === 'login' || toName.includes('err')
    // 是否登录有效
    const ifLogin = !!getStore('userInfo')
    if (toLoginOrErr) {
      next({ replace: true })
    } else {
      if (ifLogin) {
        changeRoute()
        store.dispatch('updateUserInfo')
        // 判断是否首次打开页面 设置23：59：:59过期的cookie
        if(!!!isFirstLogin(store.state.adminInfo.nickname)&&toName!=='login'&&toName!=='index'){
          store.commit('changeFirstLogin',true)
          store.dispatch('setOneDayCookie')
        }else{
          store.commit('changeFirstLogin',false)
        }
        next()
        // let role_id=store.state.adminInfo.role_id
        // if(toName==='index'&&(role_id==1||role_id === 0)){
        //   next({path:'/data_sum',query:{is_open:true}})
        // }else if(toName==='index'&&role_id!==1&&role_id!==0){
        //   next({path:'/data_index',query:{is_open:true}})
        // }else{
        //   next()
        // }
      } else {
        next('/login')
      }
    }
  }
})
