# Introduction

This is a [Helm](https://helm.sh/) chart for installing Mastodon into a
Kubernetes cluster.  The basic usage is:

1. edit `values.yaml` or create a separate yaml file for custom values
1. `helm dep update`
1. `helm install --namespace mastodon --create-namespace my-mastodon ./ -f path/to/additional/values.yaml`

This chart has been tested on Helm 3.0.1 and above.

# Configuration

The variables that _must_ be configured are:

- password and keys in the `mastodon.secrets`, `postgresql`, and `redis` groups; if
  left blank, some of those values will be autogenerated, but will not persist
  across upgrades.

- SMTP settings for your mailer in the `mastodon.smtp` group.

# Missing features

Currently this chart does _not_ support:

- Hidden services
- Single Sign-On
- Swift
- configurations using `WEB_DOMAIN`

# Upgrading

Because database migrations are managed as a Job separate from the Rails and
Sidekiq deployments, it’s possible they will occur in the wrong order.  After
upgrading Mastodon versions, it may sometimes be necessary to manually delete
the Rails and Sidekiq pods so that they are recreated against the latest
migration.
