/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetWriter;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.jdbc.rowset.OracleCachedRowSetReader;
import oracle.jdbc.rowset.OracleRow;

public class OracleCachedRowSetWriter
implements RowSetWriter,
Serializable {
    private StringBuffer updateClause = new StringBuffer("");
    private StringBuffer deleteClause = new StringBuffer("");
    private StringBuffer insertClause = new StringBuffer("");
    private PreparedStatement insertStmt;
    private PreparedStatement updateStmt;
    private PreparedStatement deleteStmt;
    private ResultSetMetaData rsmd;
    private transient Connection connection;
    private int columnCount;

    private String getSchemaName(RowSet rowSet) throws SQLException {
        return rowSet.getUsername();
    }

    private String getTableName(RowSet rowSet) throws SQLException {
        String string = ((OracleCachedRowSet)rowSet).getTableName();
        if (string != null) {
            return string;
        }
        String string2 = rowSet.getCommand().toUpperCase();
        int n = string2.indexOf(" FROM ");
        if (n == -1) {
            throw new SQLException("Could not parse the SQL String to get the table name.\n" + (string2 != "" ? string2 : "Please use RowSet.setCommand (String) to set the SQL query string."));
        }
        String string3 = string2.substring(n + 6).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string3);
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        return string3;
    }

    private void initSQLStatement(RowSet rowSet) throws SQLException {
        int n;
        this.insertClause = new StringBuffer("INSERT INTO " + this.getTableName(rowSet) + "(");
        this.updateClause = new StringBuffer("UPDATE " + this.getTableName(rowSet) + " SET ");
        this.deleteClause = new StringBuffer("DELETE FROM " + this.getTableName(rowSet) + " WHERE ");
        this.rsmd = rowSet.getMetaData();
        this.columnCount = this.rsmd.getColumnCount();
        for (n = 0; n < this.columnCount; ++n) {
            if (n != 0) {
                this.insertClause.append(", ");
            }
            this.insertClause.append(this.rsmd.getColumnName(n + 1));
            if (n != 0) {
                this.updateClause.append(", ");
            }
            this.updateClause.append(this.rsmd.getColumnName(n + 1) + " = :" + n);
            if (n != 0) {
                this.deleteClause.append(" AND ");
            }
            this.deleteClause.append(this.rsmd.getColumnName(n + 1) + " = :" + n);
        }
        this.insertClause.append(") VALUES (");
        this.updateClause.append(" WHERE ");
        for (n = 0; n < this.columnCount; ++n) {
            if (n != 0) {
                this.insertClause.append(", ");
            }
            this.insertClause.append(":" + n);
            if (n != 0) {
                this.updateClause.append(" AND ");
            }
            this.updateClause.append(this.rsmd.getColumnName(n + 1) + " = :" + n);
        }
        this.insertClause.append(")");
        this.insertStmt = this.connection.prepareStatement(this.insertClause.substring(0, this.insertClause.length()));
        this.updateStmt = this.connection.prepareStatement(this.updateClause.substring(0, this.updateClause.length()));
        this.deleteStmt = this.connection.prepareStatement(this.deleteClause.substring(0, this.deleteClause.length()));
    }

    private boolean insertRow(OracleRow oracleRow) throws SQLException {
        this.insertStmt.clearParameters();
        for (int i = 1; i <= this.columnCount; ++i) {
            Object object = null;
            Object object2 = object = oracleRow.isColumnChanged(i) ? oracleRow.getModifiedColumn(i) : oracleRow.getColumn(i);
            if (object == null) {
                this.insertStmt.setNull(i, this.rsmd.getColumnType(i));
                oracleRow.markOriginalNull(i, true);
                continue;
            }
            this.insertStmt.setObject(i, object);
        }
        return this.insertStmt.executeUpdate() == 1;
    }

    private boolean updateRow(RowSet rowSet, OracleRow oracleRow) throws SQLException {
        int n;
        this.updateStmt.clearParameters();
        for (n = 1; n <= this.columnCount; ++n) {
            Object object = null;
            Object object2 = object = oracleRow.isColumnChanged(n) ? oracleRow.getModifiedColumn(n) : oracleRow.getColumn(n);
            if (object == null) {
                this.updateStmt.setNull(n, this.rsmd.getColumnType(n));
                continue;
            }
            this.updateStmt.setObject(n, object);
        }
        for (n = 1; n <= this.columnCount; ++n) {
            if (oracleRow.isOriginalNull(n)) {
                return this.updateRowWithNull(rowSet, oracleRow);
            }
            this.updateStmt.setObject(n + this.columnCount, oracleRow.getColumn(n));
        }
        return this.updateStmt.executeUpdate() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateRowWithNull(RowSet rowSet, OracleRow oracleRow) throws SQLException {
        int n;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer("UPDATE " + this.getTableName(rowSet) + " SET ");
        for (n = 1; n <= this.columnCount; ++n) {
            if (n != 1) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.rsmd.getColumnName(n) + " = :" + n);
        }
        stringBuffer.append(" WHERE ");
        for (n = 1; n <= this.columnCount; ++n) {
            if (n != 1) {
                stringBuffer.append(" AND ");
            }
            if (oracleRow.isOriginalNull(n)) {
                stringBuffer.append(this.rsmd.getColumnName(n) + " IS NULL ");
                continue;
            }
            stringBuffer.append(this.rsmd.getColumnName(n) + " = :" + n);
        }
        Statement statement = null;
        try {
            int n2;
            statement = this.connection.prepareStatement(stringBuffer.substring(0, stringBuffer.length()));
            for (n2 = 1; n2 <= this.columnCount; ++n2) {
                Object object = null;
                Object object2 = object = oracleRow.isColumnChanged(n2) ? oracleRow.getModifiedColumn(n2) : oracleRow.getColumn(n2);
                if (object == null) {
                    statement.setNull(n2, this.rsmd.getColumnType(n2));
                    continue;
                }
                statement.setObject(n2, object);
            }
            int n3 = 1;
            for (n2 = 1; n2 <= this.columnCount; ++n2) {
                if (oracleRow.isOriginalNull(n2)) continue;
                statement.setObject(n3 + this.columnCount, oracleRow.getColumn(n2));
                ++n3;
            }
            bl = statement.executeUpdate() == 1;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        return bl;
    }

    private boolean deleteRow(RowSet rowSet, OracleRow oracleRow) throws SQLException {
        this.deleteStmt.clearParameters();
        for (int i = 1; i <= this.columnCount; ++i) {
            if (oracleRow.isOriginalNull(i)) {
                return this.deleteRowWithNull(rowSet, oracleRow);
            }
            Object object = oracleRow.getColumn(i);
            if (object == null) {
                this.deleteStmt.setNull(i, this.rsmd.getColumnType(i));
                continue;
            }
            this.deleteStmt.setObject(i, object);
        }
        return this.deleteStmt.executeUpdate() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteRowWithNull(RowSet rowSet, OracleRow oracleRow) throws SQLException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer("DELETE FROM " + this.getTableName(rowSet) + " WHERE ");
        for (int i = 1; i <= this.columnCount; ++i) {
            if (i != 1) {
                stringBuffer.append(" AND ");
            }
            if (oracleRow.isOriginalNull(i)) {
                stringBuffer.append(this.rsmd.getColumnName(i) + " IS NULL ");
                continue;
            }
            stringBuffer.append(this.rsmd.getColumnName(i) + " = :" + i);
        }
        Statement statement = null;
        try {
            statement = this.connection.prepareStatement(stringBuffer.substring(0, stringBuffer.length()));
            int n = 1;
            for (int i = 1; i <= this.columnCount; ++i) {
                if (oracleRow.isOriginalNull(i)) continue;
                statement.setObject(n++, oracleRow.getColumn(i));
            }
            bl = statement.executeUpdate() == 1;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        return bl;
    }

    public synchronized boolean writeData(RowSetInternal rowSetInternal) throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)rowSetInternal;
        this.connection = ((OracleCachedRowSetReader)oracleCachedRowSet.getReader()).getConnection(rowSetInternal);
        if (this.connection == null) {
            throw new SQLException("Unable to get Connection");
        }
        if (this.connection.getAutoCommit()) {
            this.connection.setAutoCommit(false);
        }
        this.connection.setTransactionIsolation(oracleCachedRowSet.getTransactionIsolation());
        this.initSQLStatement(oracleCachedRowSet);
        if (this.columnCount < 1) {
            this.connection.close();
            return true;
        }
        boolean bl = oracleCachedRowSet.getShowDeleted();
        oracleCachedRowSet.setShowDeleted(true);
        oracleCachedRowSet.beforeFirst();
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        OracleRow oracleRow = null;
        while (oracleCachedRowSet.next()) {
            if (oracleCachedRowSet.rowInserted()) {
                if (oracleCachedRowSet.rowDeleted()) continue;
                oracleRow = oracleCachedRowSet.getCurrentRow();
                bl3 = this.insertRow(oracleRow) || bl3;
                continue;
            }
            if (oracleCachedRowSet.rowUpdated()) {
                oracleRow = oracleCachedRowSet.getCurrentRow();
                bl2 = this.updateRow(oracleCachedRowSet, oracleRow) || bl2;
                continue;
            }
            if (!oracleCachedRowSet.rowDeleted()) continue;
            oracleRow = oracleCachedRowSet.getCurrentRow();
            bl4 = this.deleteRow(oracleCachedRowSet, oracleRow) || bl4;
        }
        if (bl2 && bl3 && bl4) {
            this.connection.commit();
            oracleCachedRowSet.setOriginal();
        } else {
            this.connection.rollback();
        }
        this.insertStmt.close();
        this.updateStmt.close();
        this.deleteStmt.close();
        if (!oracleCachedRowSet.isConnectionStayingOpen()) {
            this.connection.close();
        }
        oracleCachedRowSet.setShowDeleted(bl);
        return true;
    }
}

