/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.Identifier;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;

final class Dot
extends Expression {
    private final Expression target;
    private final String key;

    Dot(Expression target, String key) {
        this.target = target;
        this.key = key;
    }

    @Override
    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        TemplateModel leftModel = this.target.getAsTemplateModel(env);
        if (leftModel instanceof TemplateHashModel) {
            return ((TemplateHashModel)leftModel).get(this.key);
        }
        if (env.getNullEnable().booleanValue() && leftModel == null) {
            return leftModel;
        }
        throw Dot.invalidTypeException(leftModel, this.target, env, "hash");
    }

    @Override
    public String getCanonicalForm() {
        return String.valueOf(this.target.getCanonicalForm()) + "." + this.key;
    }

    @Override
    boolean isLiteral() {
        return this.target.isLiteral();
    }

    @Override
    Expression _deepClone(String name, Expression subst) {
        return new Dot(this.target.deepClone(name, subst), this.key);
    }

    boolean onlyHasIdentifiers() {
        return this.target instanceof Identifier || this.target instanceof Dot && ((Dot)this.target).onlyHasIdentifiers();
    }
}

