/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.EvaluationUtil;
import freemarker.core.NonBooleanException;
import freemarker.core.NonStringException;
import freemarker.core.ParseException;
import freemarker.core.TemplateObject;
import freemarker.ext.beans.BeanModel;
import freemarker.template.Template;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;

public abstract class Expression
extends TemplateObject {
    TemplateModel constantValue;

    abstract TemplateModel _getAsTemplateModel(Environment var1) throws TemplateException;

    abstract boolean isLiteral();

    @Override
    void setLocation(Template template, int beginColumn, int beginLine, int endColumn, int endLine) throws ParseException {
        super.setLocation(template, beginColumn, beginLine, endColumn, endLine);
        if (this.isLiteral()) {
            try {
                this.constantValue = this._getAsTemplateModel(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final TemplateModel getAsTemplateModel(Environment env) throws TemplateException {
        return this.constantValue != null ? this.constantValue : this._getAsTemplateModel(env);
    }

    String getStringValue(Environment env) throws TemplateException {
        return Expression.getStringValue(this.getAsTemplateModel(env), this, env);
    }

    static String getStringValue(TemplateModel referentModel, Expression exp, Environment env) throws TemplateException {
        if (referentModel instanceof TemplateNumberModel) {
            return env.formatNumber(EvaluationUtil.getNumber((TemplateNumberModel)referentModel, exp, env));
        }
        if (referentModel instanceof TemplateDateModel) {
            TemplateDateModel dm = (TemplateDateModel)referentModel;
            return env.formatDate(EvaluationUtil.getDate(dm, exp, env), dm.getDateType());
        }
        if (referentModel instanceof TemplateScalarModel) {
            return EvaluationUtil.getString((TemplateScalarModel)referentModel, exp, env);
        }
        if (env.isClassicCompatible()) {
            if (referentModel instanceof TemplateBooleanModel) {
                return ((TemplateBooleanModel)referentModel).getAsBoolean() ? "true" : "";
            }
            if (referentModel == null) {
                return "";
            }
        }
        if (env.getNullEnable().booleanValue()) {
            if (referentModel instanceof TemplateBooleanModel) {
                return ((TemplateBooleanModel)referentModel).getAsBoolean() ? "true" : "";
            }
            if (referentModel == null) {
                return "";
            }
        }
        Expression.assertNonNull(referentModel, exp, env);
        String msg = "Error " + exp.getStartLocation() + "\nExpecting a string, " + (env.isClassicCompatible() ? "boolean, " : "") + "date or number here, Expression " + exp + " is instead a " + referentModel.getClass().getName();
        throw new NonStringException(msg, env);
    }

    Expression deepClone(String name, Expression subst) {
        Expression clone = this._deepClone(name, subst);
        clone.copyLocationFrom(this);
        return clone;
    }

    abstract Expression _deepClone(String var1, Expression var2);

    boolean isTrue(Environment env) throws TemplateException {
        TemplateModel referent = this.getAsTemplateModel(env);
        if (referent instanceof TemplateBooleanModel) {
            return ((TemplateBooleanModel)referent).getAsBoolean();
        }
        if (env.isClassicCompatible()) {
            return referent != null && !Expression.isEmpty(referent);
        }
        Expression.assertNonNull(referent, this, env);
        String msg = "Error " + this.getStartLocation() + "\nExpecting a boolean (true/false) expression here" + "\nExpression " + this + " does not evaluate to true/false " + "\nit is an instance of " + referent.getClass().getName();
        throw new NonBooleanException(msg, env);
    }

    static boolean isEmpty(TemplateModel model) throws TemplateModelException {
        if (model instanceof BeanModel) {
            return ((BeanModel)model).isEmpty();
        }
        if (model instanceof TemplateSequenceModel) {
            return ((TemplateSequenceModel)model).size() == 0;
        }
        if (model instanceof TemplateScalarModel) {
            String s = ((TemplateScalarModel)model).getAsString();
            return s == null || s.length() == 0;
        }
        if (model instanceof TemplateCollectionModel) {
            return !((TemplateCollectionModel)model).iterator().hasNext();
        }
        if (model instanceof TemplateHashModel) {
            return ((TemplateHashModel)model).isEmpty();
        }
        return !(model instanceof TemplateNumberModel) && !(model instanceof TemplateDateModel) && !(model instanceof TemplateBooleanModel);
    }
}

