/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.codegenerate.generate;

import freemarker.template.Configuration;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.jeecgframework.codegenerate.util.CodeResourceUtil;
import org.jeecgframework.codegenerate.util.CodeStringUtils;

public class BaseCodeFactory {
    protected String A;

    public Configuration getConfiguration() throws IOException {
        Configuration cfg = new Configuration();
        cfg.setClassForTemplateLoading(this.getClass(), CodeResourceUtil.FREEMARKER_CLASSPATH);
        cfg.setLocale(Locale.CHINA);
        cfg.setDefaultEncoding("UTF-8");
        return cfg;
    }

    public Configuration h() throws IOException {
        Configuration cfg = new Configuration();
        cfg.setClassForTemplateLoading(this.getClass(), CodeResourceUtil.FREEMARKER_CLASSPATH_USERDEFINED);
        cfg.setLocale(Locale.CHINA);
        cfg.setDefaultEncoding("UTF-8");
        return cfg;
    }

    public String a(String path, String type, String entityPackage, String entityName) {
        StringBuilder str = new StringBuilder();
        if (StringUtils.isNotBlank((String)type)) {
            String codeType = Enum.valueOf(CodeType.class, type).getValue();
            str.append(path);
            if ("jsp".equals(type) || "jspList".equals(type) || "js".equals(type) || "jsList".equals(type) || "jsp_add".equals(type) || "jsp_update".equals(type)) {
                str.append(CodeResourceUtil.JSPPATH);
            } else {
                str.append(CodeResourceUtil.CODEPATH);
            }
            str.append(StringUtils.lowerCase((String)entityPackage));
            str.append("/");
            if ("Action".equalsIgnoreCase(codeType)) {
                str.append(StringUtils.lowerCase((String)"action"));
            } else if ("ServiceImpl".equalsIgnoreCase(codeType)) {
                str.append(StringUtils.lowerCase((String)"service/impl"));
            } else if ("ServiceI".equalsIgnoreCase(codeType)) {
                str.append(StringUtils.lowerCase((String)"service"));
            } else if (!"List".equalsIgnoreCase(codeType)) {
                str.append(StringUtils.lowerCase((String)codeType));
            }
            str.append("/");
            if ("jsp".equals(type) || "jspList".equals(type)) {
                String jspName = StringUtils.capitalize((String)entityName);
                str.append(CodeStringUtils.getInitialSmall(jspName));
                str.append(codeType);
                str.append(".jsp");
            } else if ("jsp_add".equals(type) || "jspList_add".equals(type)) {
                String jsName = StringUtils.capitalize((String)entityName);
                str.append(CodeStringUtils.getInitialSmall(jsName));
                str.append(codeType);
                str.append("-add.jsp");
            } else if ("jsp_update".equals(type) || "jspList_update".equals(type)) {
                String jsName = StringUtils.capitalize((String)entityName);
                str.append(CodeStringUtils.getInitialSmall(jsName));
                str.append(codeType);
                str.append("-update.jsp");
            } else if ("js".equals(type) || "jsList".equals(type)) {
                String jsName = StringUtils.capitalize((String)entityName);
                str.append(CodeStringUtils.getInitialSmall(jsName));
                str.append(codeType);
                str.append(".js");
            } else {
                str.append(StringUtils.capitalize((String)entityName));
                str.append(codeType);
                str.append(".java");
            }
        } else {
            throw new IllegalArgumentException("type is null");
        }
        return str.toString();
    }

    public String b(String path, String type, String entityPackage, String entityName) {
        StringBuilder str = new StringBuilder();
        if (StringUtils.isNotBlank((String)type)) {
            String codeType = Enum.valueOf(CodeType.class, type).getValue();
            str.append(path);
            if ("jsp".equals(type) || "jspList".equals(type) || "js".equals(type) || "jsList".equals(type) || "jsp_add".equals(type) || "jsp_update".equals(type)) {
                str.append(CodeResourceUtil.JSPPATH);
            } else {
                str.append(CodeResourceUtil.CODEPATH);
            }
            if ("Action".equalsIgnoreCase(codeType)) {
                str.append(StringUtils.lowerCase((String)"action"));
            } else if ("ServiceImpl".equalsIgnoreCase(codeType)) {
                str.append(StringUtils.lowerCase((String)"service/impl"));
            } else if ("ServiceI".equalsIgnoreCase(codeType)) {
                str.append(StringUtils.lowerCase((String)"service"));
            } else if (!"List".equalsIgnoreCase(codeType)) {
                str.append(StringUtils.lowerCase((String)codeType));
            }
            str.append("/");
            str.append(StringUtils.lowerCase((String)entityPackage));
            str.append("/");
            if ("jsp".equals(type) || "jspList".equals(type)) {
                String jspName = StringUtils.capitalize((String)entityName);
                str.append(CodeStringUtils.getInitialSmall(jspName));
                str.append(codeType);
                str.append(".jsp");
            } else if ("jsp_add".equals(type) || "jspList_add".equals(type)) {
                String jsName = StringUtils.capitalize((String)entityName);
                str.append(CodeStringUtils.getInitialSmall(jsName));
                str.append(codeType);
                str.append("-add.jsp");
            } else if ("jsp_update".equals(type) || "jspList_update".equals(type)) {
                String jsName = StringUtils.capitalize((String)entityName);
                str.append(CodeStringUtils.getInitialSmall(jsName));
                str.append(codeType);
                str.append("-update.jsp");
            } else if ("js".equals(type) || "jsList".equals(type)) {
                String jsName = StringUtils.capitalize((String)entityName);
                str.append(CodeStringUtils.getInitialSmall(jsName));
                str.append(codeType);
                str.append(".js");
            } else {
                str.append(StringUtils.capitalize((String)entityName));
                str.append(codeType);
                str.append(".java");
            }
        } else {
            throw new IllegalArgumentException("type is null");
        }
        return str.toString();
    }

    public String getPackageStyle() {
        return this.A;
    }

    public void setPackageStyle(String packageStyle) {
        this.A = packageStyle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CodeType {
        serviceImpl("ServiceImpl"),
        dao("Dao"),
        service("ServiceI"),
        controller("Controller"),
        page("Page"),
        entity("Entity"),
        jsp(""),
        jsp_add(""),
        jsp_update(""),
        js(""),
        jsList("List"),
        jspList("List"),
        jspSubList("SubList");

        private String type;

        private CodeType(String type) {
            this.type = type;
        }

        public String getValue() {
            return this.type;
        }
    }
}

