/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.codegenerate.generate;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jeecgframework.codegenerate.generate.BaseCodeFactory;
import org.jeecgframework.codegenerate.generate.c;
import org.jeecgframework.codegenerate.util.CodeResourceUtil;
import org.jeecgframework.codegenerate.util.CodeStringUtils;

public class CodeFactory
extends BaseCodeFactory {
    private c l;

    public void a(String templateFileName, String type, Map data) {
        try {
            String entityPackage = data.get("entityPackage").toString();
            String entityName = data.get("entityName").toString();
            String fileNamePath = this.b(type, entityPackage, entityName);
            String fileDir = StringUtils.substringBeforeLast((String)fileNamePath, (String)"/");
            Template template = this.getConfiguration().getTemplate(templateFileName);
            FileUtils.forceMkdir((File)new File(fileDir + "/"));
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(fileNamePath), CodeResourceUtil.SYSTEM_ENCODING);
            template.process((Object)data, (Writer)out);
            ((Writer)out).close();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getProjectPath() {
        String path = System.getProperty("user.dir").replace("\\", "/") + "/";
        return path;
    }

    public String getClassPath() {
        String path = Thread.currentThread().getContextClassLoader().getResource("./").getPath();
        return path;
    }

    public static void main(String[] args) {
        System.out.println(CodeFactory.getProjectPath());
    }

    public String getTemplatePath() {
        String path = this.getClassPath() + CodeResourceUtil.TEMPLATEPATH;
        return path;
    }

    public String b(String type, String entityPackage, String entityName) {
        String path = CodeFactory.getProjectPath();
        StringBuilder str = new StringBuilder();
        if (StringUtils.isNotBlank((String)type)) {
            String codeType = Enum.valueOf(CodeType.class, type).getValue();
            str.append(path);
            if ("jsp".equals(type) || "jspList".equals(type)) {
                str.append(CodeResourceUtil.JSPPATH);
            } else {
                str.append(CodeResourceUtil.CODEPATH);
            }
            if ("Action".equalsIgnoreCase(codeType)) {
                str.append(StringUtils.lowerCase((String)"action"));
            } else if ("ServiceImpl".equalsIgnoreCase(codeType)) {
                str.append(StringUtils.lowerCase((String)"service/impl"));
            } else if ("ServiceI".equalsIgnoreCase(codeType)) {
                str.append(StringUtils.lowerCase((String)"service"));
            } else if (!"List".equalsIgnoreCase(codeType)) {
                str.append(StringUtils.lowerCase((String)codeType));
            }
            str.append("/");
            str.append(StringUtils.lowerCase((String)entityPackage));
            str.append("/");
            if ("jsp".equals(type) || "jspList".equals(type)) {
                String jspName = StringUtils.capitalize((String)entityName);
                str.append(CodeStringUtils.getInitialSmall(jspName));
                str.append(codeType);
                str.append(".jsp");
            } else {
                str.append(StringUtils.capitalize((String)entityName));
                str.append(codeType);
                str.append(".java");
            }
        } else {
            throw new IllegalArgumentException("type is null");
        }
        return str.toString();
    }

    public void b(String templateFileName, String type) {
        Map<Object, Object> data = new HashMap();
        data = this.l.e();
        this.a(templateFileName, type, data);
    }

    public c d() {
        return this.l;
    }

    public void a(c callBack) {
        this.l = callBack;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CodeType {
        serviceImpl("ServiceImpl"),
        service("ServiceI"),
        controller("Controller"),
        entity("Entity"),
        jsp(""),
        jspList("List");

        private String type;

        private CodeType(String type) {
            this.type = type;
        }

        public String getValue() {
            return this.type;
        }
    }
}

