/*!
 * jQuery UI Sortable 1.8.21
 *
 * Copyright 2012, AUTHORS.txt (http://jqueryui.com/about)
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 *
 * http://docs.jquery.com/UI/Sortables
 *
 * Depends:
 *	jquery.ui.core.js
 *	jquery.ui.mouse.js
 *	jquery.ui.widget.js
 */
(function(d,c){d.widget("ui.sortable",d.ui.mouse,{widgetEventPrefix:"sort",ready:false,options:{appendTo:"parent",axis:false,connectWith:false,containment:false,cursor:"auto",cursorAt:false,dropOnEmpty:true,forcePlaceholderSize:false,forceHelperSize:false,grid:false,handle:false,helper:"original",items:"> *",opacity:false,placeholder:false,revert:false,scroll:true,scrollSensitivity:20,scrollSpeed:20,scope:"default",tolerance:"intersect",zIndex:1000},_create:function(){var a=this.options;this.containerCache={};this.element.addClass("ui-sortable");this.refresh();this.floating=this.items.length?a.axis==="x"||(/left|right/).test(this.items[0].item.css("float"))||(/inline|table-cell/).test(this.items[0].item.css("display")):false;this.offset=this.element.offset();this._mouseInit();this.ready=true},destroy:function(){d.Widget.prototype.destroy.call(this);this.element.removeClass("ui-sortable ui-sortable-disabled");this._mouseDestroy();for(var a=this.items.length-1;a>=0;a--){this.items[a].item.removeData(this.widgetName+"-item")}return this},_setOption:function(b,a){if(b==="disabled"){this.options[b]=a;this.widget()[a?"addClass":"removeClass"]("ui-sortable-disabled")}else{d.Widget.prototype._setOption.apply(this,arguments)}},_mouseCapture:function(m,j){var k=this;if(this.reverting){return false}if(this.options.disabled||this.options.type=="static"){return false}this._refreshItems(m);var a=null,b=this,n=d(m.target).parents().each(function(){if(d.data(this,k.widgetName+"-item")==b){a=d(this);return false}});if(d.data(m.target,k.widgetName+"-item")==b){a=d(m.target)}if(!a){return false}if(this.options.handle&&!j){var l=false;d(this.options.handle,a).find("*").andSelf().each(function(){if(this==m.target){l=true}});if(!l){return false}}this.currentItem=a;this._removeCurrentsFromItems();return true},_mouseStart:function(j,k,b){var i=this.options,l=this;this.currentContainer=this;this.refreshPositions();this.helper=this._createHelper(j);this._cacheHelperProportions();this._cacheMargins();this.scrollParent=this.helper.scrollParent();this.offset=this.currentItem.offset();this.offset={top:this.offset.top-this.margins.top,left:this.offset.left-this.margins.left};d.extend(this.offset,{click:{left:j.pageX-this.offset.left,top:j.pageY-this.offset.top},parent:this._getParentOffset(),relative:this._getRelativeOffset()});this.helper.css("position","absolute");this.cssPosition=this.helper.css("position");this.originalPosition=this._generatePosition(j);this.originalPageX=j.pageX;this.originalPageY=j.pageY;(i.cursorAt&&this._adjustOffsetFromHelper(i.cursorAt));this.domPosition={prev:this.currentItem.prev()[0],parent:this.currentItem.parent()[0]};if(this.helper[0]!=this.currentItem[0]){this.currentItem.hide()}this._createPlaceholder();if(i.containment){this._setContainment()}if(i.cursor){if(d("body").css("cursor")){this._storedCursor=d("body").css("cursor")}d("body").css("cursor",i.cursor)}if(i.opacity){if(this.helper.css("opacity")){this._storedOpacity=this.helper.css("opacity")}this.helper.css("opacity",i.opacity)}if(i.zIndex){if(this.helper.css("zIndex")){this._storedZIndex=this.helper.css("zIndex")}this.helper.css("zIndex",i.zIndex)}if(this.scrollParent[0]!=document&&this.scrollParent[0].tagName!="HTML"){this.overflowOffset=this.scrollParent.offset()}this._trigger("start",j,this._uiHash());if(!this._preserveHelperProportions){this._cacheHelperProportions()}if(!b){for(var a=this.containers.length-1;a>=0;a--){this.containers[a]._trigger("activate",j,l._uiHash(this))}}if(d.ui.ddmanager){d.ui.ddmanager.current=this}if(d.ui.ddmanager&&!i.dropBehaviour){d.ui.ddmanager.prepareOffsets(this,j)}this.dragging=true;this.helper.addClass("ui-sortable-helper");this._mouseDrag(j);return true},_mouseDrag:function(m){this.position=this._generatePosition(m);this.positionAbs=this._convertPositionTo("absolute");if(!this.lastPositionAbs){this.lastPositionAbs=this.positionAbs}if(this.options.scroll){var i=this.options,n=false;if(this.scrollParent[0]!=document&&this.scrollParent[0].tagName!="HTML"){if((this.overflowOffset.top+this.scrollParent[0].offsetHeight)-m.pageY<i.scrollSensitivity){this.scrollParent[0].scrollTop=n=this.scrollParent[0].scrollTop+i.scrollSpeed}else{if(m.pageY-this.overflowOffset.top<i.scrollSensitivity){this.scrollParent[0].scrollTop=n=this.scrollParent[0].scrollTop-i.scrollSpeed}}if((this.overflowOffset.left+this.scrollParent[0].offsetWidth)-m.pageX<i.scrollSensitivity){this.scrollParent[0].scrollLeft=n=this.scrollParent[0].scrollLeft+i.scrollSpeed}else{if(m.pageX-this.overflowOffset.left<i.scrollSensitivity){this.scrollParent[0].scrollLeft=n=this.scrollParent[0].scrollLeft-i.scrollSpeed}}}else{if(m.pageY-d(document).scrollTop()<i.scrollSensitivity){n=d(document).scrollTop(d(document).scrollTop()-i.scrollSpeed)}else{if(d(window).height()-(m.pageY-d(document).scrollTop())<i.scrollSensitivity){n=d(document).scrollTop(d(document).scrollTop()+i.scrollSpeed)}}if(m.pageX-d(document).scrollLeft()<i.scrollSensitivity){n=d(document).scrollLeft(d(document).scrollLeft()-i.scrollSpeed)}else{if(d(window).width()-(m.pageX-d(document).scrollLeft())<i.scrollSensitivity){n=d(document).scrollLeft(d(document).scrollLeft()+i.scrollSpeed)}}}if(n!==false&&d.ui.ddmanager&&!i.dropBehaviour){d.ui.ddmanager.prepareOffsets(this,m)}}this.positionAbs=this._convertPositionTo("absolute");if(!this.options.axis||this.options.axis!="y"){this.helper[0].style.left=this.position.left+"px"}if(!this.options.axis||this.options.axis!="x"){this.helper[0].style.top=this.position.top+"px"}for(var a=this.items.length-1;a>=0;a--){var k=this.items[a],b=k.item[0],l=this._intersectsWithPointer(k);if(!l){continue}if(b!=this.currentItem[0]&&this.placeholder[l==1?"next":"prev"]()[0]!=b&&!d.ui.contains(this.placeholder[0],b)&&(this.options.type=="semi-dynamic"?!d.ui.contains(this.element[0],b):true)){this.direction=l==1?"down":"up";if(this.options.tolerance=="pointer"||this._intersectsWithSides(k)){this._rearrange(m,k)}else{break}this._trigger("change",m,this._uiHash());break}}this._contactContainers(m);if(d.ui.ddmanager){d.ui.ddmanager.drag(this,m)}this._trigger("sort",m,this._uiHash());this.lastPositionAbs=this.positionAbs;return false},_mouseStop:function(a,h){if(!a){return}if(d.ui.ddmanager&&!this.options.dropBehaviour){d.ui.ddmanager.drop(this,a)}if(this.options.revert){var b=this;var g=b.placeholder.offset();b.reverting=true;d(this.helper).animate({left:g.left-this.offset.parent.left-b.margins.left+(this.offsetParent[0]==document.body?0:this.offsetParent[0].scrollLeft),top:g.top-this.offset.parent.top-b.margins.top+(this.offsetParent[0]==document.body?0:this.offsetParent[0].scrollTop)},parseInt(this.options.revert,10)||500,function(){b._clear(a)})}else{this._clear(a,h)}return false},cancel:function(){var b=this;if(this.dragging){this._mouseUp({target:null});if(this.options.helper=="original"){this.currentItem.css(this._storedCSS).removeClass("ui-sortable-helper")}else{this.currentItem.show()}for(var a=this.containers.length-1;a>=0;a--){this.containers[a]._trigger("deactivate",null,b._uiHash(this));if(this.containers[a].containerCache.over){this.containers[a]._trigger("out",null,b._uiHash(this));this.containers[a].containerCache.over=0}}}if(this.placeholder){if(this.placeholder[0].parentNode){this.placeholder[0].parentNode.removeChild(this.placeholder[0])}if(this.options.helper!="original"&&this.helper&&this.helper[0].parentNode){this.helper.remove()}d.extend(this,{helper:null,dragging:false,reverting:false,_noFinalSort:null});if(this.domPosition.prev){d(this.domPosition.prev).after(this.currentItem)}else{d(this.domPosition.parent).prepend(this.currentItem)}}return this},serialize:function(f){var b=this._getItemsAsjQuery(f&&f.connected);var a=[];f=f||{};d(b).each(function(){var e=(d(f.item||this).attr(f.attribute||"id")||"").match(f.expression||(/(.+)[-=_](.+)/));if(e){a.push((f.key||e[1]+"[]")+"="+(f.key&&f.expression?e[1]:e[2]))}});if(!a.length&&f.key){a.push(f.key+"=")}return a.join("&")},toArray:function(f){var b=this._getItemsAsjQuery(f&&f.connected);var a=[];f=f||{};b.each(function(){a.push(d(f.item||this).attr(f.attribute||"id")||"")});return a},_intersectsWith:function(u){var p=this.positionAbs.left,q=p+this.helperProportions.width,v=this.positionAbs.top,w=v+this.helperProportions.height;var l=u.left,r=l+u.width,t=u.top,x=t+u.height;var s=this.offset.click.top,a=this.offset.click.left;var b=(v+s)>t&&(v+s)<x&&(p+a)>l&&(p+a)<r;if(this.options.tolerance=="pointer"||this.options.forcePointerForContainers||(this.options.tolerance!="pointer"&&this.helperProportions[this.floating?"width":"height"]>u[this.floating?"width":"height"])){return b}else{return(l<p+(this.helperProportions.width/2)&&q-(this.helperProportions.width/2)<r&&t<v+(this.helperProportions.height/2)&&w-(this.helperProportions.height/2)<x)}},_intersectsWithPointer:function(l){var j=(this.options.axis==="x")||d.ui.isOverAxis(this.positionAbs.top+this.offset.click.top,l.top,l.height),a=(this.options.axis==="y")||d.ui.isOverAxis(this.positionAbs.left+this.offset.click.left,l.left,l.width),b=j&&a,i=this._getDragVerticalDirection(),k=this._getDragHorizontalDirection();if(!b){return false}return this.floating?(((k&&k=="right")||i=="down")?2:1):(i&&(i=="down"?2:1))},_intersectsWithSides:function(b){var i=d.ui.isOverAxis(this.positionAbs.top+this.offset.click.top,b.top+(b.height/2),b.height),h=d.ui.isOverAxis(this.positionAbs.left+this.offset.click.left,b.left+(b.width/2),b.width),j=this._getDragVerticalDirection(),a=this._getDragHorizontalDirection();if(this.floating&&a){return((a=="right"&&h)||(a=="left"&&!h))}else{return j&&((j=="down"&&i)||(j=="up"&&!i))}},_getDragVerticalDirection:function(){var a=this.positionAbs.top-this.lastPositionAbs.top;return a!=0&&(a>0?"down":"up")},_getDragHorizontalDirection:function(){var a=this.positionAbs.left-this.lastPositionAbs.left;return a!=0&&(a>0?"right":"left")},refresh:function(a){this._refreshItems(a);this.refreshPositions();return this},_connectWith:function(){var a=this.options;return a.connectWith.constructor==String?[a.connectWith]:a.connectWith},_getItemsAsjQuery:function(r){var a=this;var j=[];var o=[];var i=this._connectWith();if(i&&r){for(var p=i.length-1;p>=0;p--){var b=d(i[p]);for(var q=b.length-1;q>=0;q--){var n=d.data(b[q],this.widgetName);if(n&&n!=this&&!n.options.disabled){o.push([d.isFunction(n.options.items)?n.options.items.call(n.element):d(n.options.items,n.element).not(".ui-sortable-helper").not(".ui-sortable-placeholder"),n])}}}}o.push([d.isFunction(this.options.items)?this.options.items.call(this.element,null,{options:this.options,item:this.currentItem}):d(this.options.items,this.element).not(".ui-sortable-helper").not(".ui-sortable-placeholder"),this]);for(var p=o.length-1;p>=0;p--){o[p][0].each(function(){j.push(this)})}return d(j)},_removeCurrentsFromItems:function(){var f=this.currentItem.find(":data("+this.widgetName+"-item)");for(var a=0;a<this.items.length;a++){for(var b=0;b<f.length;b++){if(f[b]==this.items[a].item[0]){this.items.splice(a,1)}}}},_refreshItems:function(r){this.items=[];this.containers=[this];var s=this.items;var x=this;var y=[[d.isFunction(this.options.items)?this.options.items.call(this.element[0],r,{item:this.currentItem}):d(this.options.items,this.element),this]];var w=this._connectWith();if(w&&this.ready){for(var z=w.length-1;z>=0;z--){var u=d(w[z]);for(var t=u.length-1;t>=0;t--){var v=d.data(u[t],this.widgetName);if(v&&v!=this&&!v.options.disabled){y.push([d.isFunction(v.options.items)?v.options.items.call(v.element[0],r,{item:this.currentItem}):d(v.options.items,v.element),v]);this.containers.push(v)}}}}for(var z=y.length-1;z>=0;z--){var a=y[z][1];var b=y[z][0];for(var t=0,i=b.length;t<i;t++){var j=d(b[t]);j.data(this.widgetName+"-item",a);s.push({item:j,instance:a,width:0,height:0,left:0,top:0})}}},refreshPositions:function(j){if(this.offsetParent&&this.helper){this.offset.parent=this._getParentOffset()}for(var h=this.items.length-1;h>=0;h--){var b=this.items[h];if(b.instance!=this.currentContainer&&this.currentContainer&&b.item[0]!=this.currentItem[0]){continue}var i=this.options.toleranceElement?d(this.options.toleranceElement,b.item):b.item;if(!j){b.width=i.outerWidth();b.height=i.outerHeight()}var a=i.offset();b.left=a.left;b.top=a.top}if(this.options.custom&&this.options.custom.refreshContainers){this.options.custom.refreshContainers.call(this)}else{for(var h=this.containers.length-1;h>=0;h--){var a=this.containers[h].element.offset();this.containers[h].containerCache.left=a.left;this.containers[h].containerCache.top=a.top;this.containers[h].containerCache.width=this.containers[h].element.outerWidth();this.containers[h].containerCache.height=this.containers[h].element.outerHeight()}}return this},_createPlaceholder:function(h){var b=h||this,g=b.options;if(!g.placeholder||g.placeholder.constructor==String){var a=g.placeholder;g.placeholder={element:function(){var e=d(document.createElement(b.currentItem[0].nodeName)).addClass(a||b.currentItem[0].className+" ui-sortable-placeholder").removeClass("ui-sortable-helper")[0];if(!a){e.style.visibility="hidden"}return e},update:function(f,e){if(a&&!g.forcePlaceholderSize){return}if(!e.height()){e.height(b.currentItem.innerHeight()-parseInt(b.currentItem.css("paddingTop")||0,10)-parseInt(b.currentItem.css("paddingBottom")||0,10))}if(!e.width()){e.width(b.currentItem.innerWidth()-parseInt(b.currentItem.css("paddingLeft")||0,10)-parseInt(b.currentItem.css("paddingRight")||0,10))}}}}b.placeholder=d(g.placeholder.element.call(b.element,b.currentItem));b.currentItem.after(b.placeholder);g.placeholder.update(b,b.placeholder)},_contactContainers:function(r){var p=null,b=null;for(var n=this.containers.length-1;n>=0;n--){if(d.ui.contains(this.currentItem[0],this.containers[n].element[0])){continue}if(this._intersectsWith(this.containers[n].containerCache)){if(p&&d.ui.contains(this.containers[n].element[0],p.element[0])){continue}p=this.containers[n];b=n}else{if(this.containers[n].containerCache.over){this.containers[n]._trigger("out",r,this._uiHash(this));this.containers[n].containerCache.over=0}}}if(!p){return}if(this.containers.length===1){this.containers[b]._trigger("over",r,this._uiHash(this));this.containers[b].containerCache.over=1}else{if(this.currentContainer!=this.containers[b]){var i=10000;var j=null;var q=this.positionAbs[this.containers[b].floating?"left":"top"];for(var o=this.items.length-1;o>=0;o--){if(!d.ui.contains(this.containers[b].element[0],this.items[o].item[0])){continue}var a=this.containers[b].floating?this.items[o].item.offset().left:this.items[o].item.offset().top;if(Math.abs(a-q)<i){i=Math.abs(a-q);j=this.items[o];this.direction=(a-q>0)?"down":"up"}}if(!j&&!this.options.dropOnEmpty){return}this.currentContainer=this.containers[b];j?this._rearrange(r,j,null,true):this._rearrange(r,null,this.containers[b].element,true);this._trigger("change",r,this._uiHash());this.containers[b]._trigger("change",r,this._uiHash(this));this.options.placeholder.update(this.currentContainer,this.placeholder);this.containers[b]._trigger("over",r,this._uiHash(this));this.containers[b].containerCache.over=1}}},_createHelper:function(a){var f=this.options;var b=d.isFunction(f.helper)?d(f.helper.apply(this.element[0],[a,this.currentItem])):(f.helper=="clone"?this.currentItem.clone():this.currentItem);if(!b.parents("body").length){d(f.appendTo!="parent"?f.appendTo:this.currentItem[0].parentNode)[0].appendChild(b[0])}if(b[0]==this.currentItem[0]){this._storedCSS={width:this.currentItem[0].style.width,height:this.currentItem[0].style.height,position:this.currentItem.css("position"),top:this.currentItem.css("top"),left:this.currentItem.css("left")}}if(b[0].style.width==""||f.forceHelperSize){b.width(this.currentItem.width())}if(b[0].style.height==""||f.forceHelperSize){b.height(this.currentItem.height())}return b},_adjustOffsetFromHelper:function(a){if(typeof a=="string"){a=a.split(" ")}if(d.isArray(a)){a={left:+a[0],top:+a[1]||0}}if("left" in a){this.offset.click.left=a.left+this.margins.left}if("right" in a){this.offset.click.left=this.helperProportions.width-a.right+this.margins.left}if("top" in a){this.offset.click.top=a.top+this.margins.top}if("bottom" in a){this.offset.click.top=this.helperProportions.height-a.bottom+this.margins.top}},_getParentOffset:function(){this.offsetParent=this.helper.offsetParent();var a=this.offsetParent.offset();if(this.cssPosition=="absolute"&&this.scrollParent[0]!=document&&d.ui.contains(this.scrollParent[0],this.offsetParent[0])){a.left+=this.scrollParent.scrollLeft();a.top+=this.scrollParent.scrollTop()}if((this.offsetParent[0]==document.body)||(this.offsetParent[0].tagName&&this.offsetParent[0].tagName.toLowerCase()=="html"&&d.browser.msie)){a={top:0,left:0}}return{top:a.top+(parseInt(this.offsetParent.css("borderTopWidth"),10)||0),left:a.left+(parseInt(this.offsetParent.css("borderLeftWidth"),10)||0)}},_getRelativeOffset:function(){if(this.cssPosition=="relative"){var a=this.currentItem.position();return{top:a.top-(parseInt(this.helper.css("top"),10)||0)+this.scrollParent.scrollTop(),left:a.left-(parseInt(this.helper.css("left"),10)||0)+this.scrollParent.scrollLeft()}}else{return{top:0,left:0}}},_cacheMargins:function(){this.margins={left:(parseInt(this.currentItem.css("marginLeft"),10)||0),top:(parseInt(this.currentItem.css("marginTop"),10)||0)}},_cacheHelperProportions:function(){this.helperProportions={width:this.helper.outerWidth(),height:this.helper.outerHeight()}},_setContainment:function(){var g=this.options;if(g.containment=="parent"){g.containment=this.helper[0].parentNode}if(g.containment=="document"||g.containment=="window"){this.containment=[0-this.offset.relative.left-this.offset.parent.left,0-this.offset.relative.top-this.offset.parent.top,d(g.containment=="document"?document:window).width()-this.helperProportions.width-this.margins.left,(d(g.containment=="document"?document:window).height()||document.body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top]}if(!(/^(document|window|parent)$/).test(g.containment)){var a=d(g.containment)[0];var h=d(g.containment).offset();var b=(d(a).css("overflow")!="hidden");this.containment=[h.left+(parseInt(d(a).css("borderLeftWidth"),10)||0)+(parseInt(d(a).css("paddingLeft"),10)||0)-this.margins.left,h.top+(parseInt(d(a).css("borderTopWidth"),10)||0)+(parseInt(d(a).css("paddingTop"),10)||0)-this.margins.top,h.left+(b?Math.max(a.scrollWidth,a.offsetWidth):a.offsetWidth)-(parseInt(d(a).css("borderLeftWidth"),10)||0)-(parseInt(d(a).css("paddingRight"),10)||0)-this.helperProportions.width-this.margins.left,h.top+(b?Math.max(a.scrollHeight,a.offsetHeight):a.offsetHeight)-(parseInt(d(a).css("borderTopWidth"),10)||0)-(parseInt(d(a).css("paddingBottom"),10)||0)-this.helperProportions.height-this.margins.top]}},_convertPositionTo:function(j,l){if(!l){l=this.position}var b=j=="absolute"?1:-1;var a=this.options,i=this.cssPosition=="absolute"&&!(this.scrollParent[0]!=document&&d.ui.contains(this.scrollParent[0],this.offsetParent[0]))?this.offsetParent:this.scrollParent,k=(/(html|body)/i).test(i[0].tagName);return{top:(l.top+this.offset.relative.top*b+this.offset.parent.top*b-(d.browser.safari&&this.cssPosition=="fixed"?0:(this.cssPosition=="fixed"?-this.scrollParent.scrollTop():(k?0:i.scrollTop()))*b)),left:(l.left+this.offset.relative.left*b+this.offset.parent.left*b-(d.browser.safari&&this.cssPosition=="fixed"?0:(this.cssPosition=="fixed"?-this.scrollParent.scrollLeft():k?0:i.scrollLeft())*b))}},_generatePosition:function(o){var p=this.options,b=this.cssPosition=="absolute"&&!(this.scrollParent[0]!=document&&d.ui.contains(this.scrollParent[0],this.offsetParent[0]))?this.offsetParent:this.scrollParent,k=(/(html|body)/i).test(b[0].tagName);if(this.cssPosition=="relative"&&!(this.scrollParent[0]!=document&&this.scrollParent[0]!=this.offsetParent[0])){this.offset.relative=this._getRelativeOffset()}var l=o.pageX;var m=o.pageY;if(this.originalPosition){if(this.containment){if(o.pageX-this.offset.click.left<this.containment[0]){l=this.containment[0]+this.offset.click.left}if(o.pageY-this.offset.click.top<this.containment[1]){m=this.containment[1]+this.offset.click.top}if(o.pageX-this.offset.click.left>this.containment[2]){l=this.containment[2]+this.offset.click.left}if(o.pageY-this.offset.click.top>this.containment[3]){m=this.containment[3]+this.offset.click.top}}if(p.grid){var a=this.originalPageY+Math.round((m-this.originalPageY)/p.grid[1])*p.grid[1];m=this.containment?(!(a-this.offset.click.top<this.containment[1]||a-this.offset.click.top>this.containment[3])?a:(!(a-this.offset.click.top<this.containment[1])?a-p.grid[1]:a+p.grid[1])):a;var n=this.originalPageX+Math.round((l-this.originalPageX)/p.grid[0])*p.grid[0];l=this.containment?(!(n-this.offset.click.left<this.containment[0]||n-this.offset.click.left>this.containment[2])?n:(!(n-this.offset.click.left<this.containment[0])?n-p.grid[0]:n+p.grid[0])):n}}return{top:(m-this.offset.click.top-this.offset.relative.top-this.offset.parent.top+(d.browser.safari&&this.cssPosition=="fixed"?0:(this.cssPosition=="fixed"?-this.scrollParent.scrollTop():(k?0:b.scrollTop())))),left:(l-this.offset.click.left-this.offset.relative.left-this.offset.parent.left+(d.browser.safari&&this.cssPosition=="fixed"?0:(this.cssPosition=="fixed"?-this.scrollParent.scrollLeft():k?0:b.scrollLeft())))}},_rearrange:function(b,j,l,k){l?l[0].appendChild(this.placeholder[0]):j.item[0].parentNode.insertBefore(this.placeholder[0],(this.direction=="down"?j.item[0]:j.item[0].nextSibling));this.counter=this.counter?++this.counter:1;var a=this,i=this.counter;window.setTimeout(function(){if(i==a.counter){a.refreshPositions(!k)}},0)},_clear:function(h,b){this.reverting=false;var a=[],j=this;if(!this._noFinalSort&&this.currentItem.parent().length){this.placeholder.before(this.currentItem)}this._noFinalSort=null;if(this.helper[0]==this.currentItem[0]){for(var i in this._storedCSS){if(this._storedCSS[i]=="auto"||this._storedCSS[i]=="static"){this._storedCSS[i]=""}}this.currentItem.css(this._storedCSS).removeClass("ui-sortable-helper")}else{this.currentItem.show()}if(this.fromOutside&&!b){a.push(function(e){this._trigger("receive",e,this._uiHash(this.fromOutside))})}if((this.fromOutside||this.domPosition.prev!=this.currentItem.prev().not(".ui-sortable-helper")[0]||this.domPosition.parent!=this.currentItem.parent()[0])&&!b){a.push(function(e){this._trigger("update",e,this._uiHash())})}if(!d.ui.contains(this.element[0],this.currentItem[0])){if(!b){a.push(function(e){this._trigger("remove",e,this._uiHash())})}for(var i=this.containers.length-1;i>=0;i--){if(d.ui.contains(this.containers[i].element[0],this.currentItem[0])&&!b){a.push((function(e){return function(f){e._trigger("receive",f,this._uiHash(this))}}).call(this,this.containers[i]));a.push((function(e){return function(f){e._trigger("update",f,this._uiHash(this))}}).call(this,this.containers[i]))}}}for(var i=this.containers.length-1;i>=0;i--){if(!b){a.push((function(e){return function(f){e._trigger("deactivate",f,this._uiHash(this))}}).call(this,this.containers[i]))}if(this.containers[i].containerCache.over){a.push((function(e){return function(f){e._trigger("out",f,this._uiHash(this))}}).call(this,this.containers[i]));this.containers[i].containerCache.over=0}}if(this._storedCursor){d("body").css("cursor",this._storedCursor)}if(this._storedOpacity){this.helper.css("opacity",this._storedOpacity)}if(this._storedZIndex){this.helper.css("zIndex",this._storedZIndex=="auto"?"":this._storedZIndex)}this.dragging=false;if(this.cancelHelperRemoval){if(!b){this._trigger("beforeStop",h,this._uiHash());for(var i=0;i<a.length;i++){a[i].call(this,h)}this._trigger("stop",h,this._uiHash())}return false}if(!b){this._trigger("beforeStop",h,this._uiHash())}this.placeholder[0].parentNode.removeChild(this.placeholder[0]);if(this.helper[0]!=this.currentItem[0]){this.helper.remove()}this.helper=null;if(!b){for(var i=0;i<a.length;i++){a[i].call(this,h)}this._trigger("stop",h,this._uiHash())}this.fromOutside=false;return true},_trigger:function(){if(d.Widget.prototype._trigger.apply(this,arguments)===false){this.cancel()}},_uiHash:function(a){var b=a||this;return{helper:b.helper,placeholder:b.placeholder||d([]),position:b.position,originalPosition:b.originalPosition,offset:b.positionAbs,item:b.currentItem,sender:a?a.element:null}}});d.extend(d.ui.sortable,{version:"1.8.21"})})(jQuery);