<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/context/mytags.jsp"%>
<!DOCTYPE html>
<html>
<head>
<script type="text/javascript" src="plug-in/echart/echarts.js"></script>
</head>
<body>
<div id="main" ></div>
    <script type="text/javascript">

    var echartsWarp= document.getElementById('main');     
    var resizeWorldMapContainer = function () {//用于使chart自适应高度和宽度,通过窗体高宽计算容器高宽  
        echartsWarp.style.width = window.innerWidth-20+'px';  
        echartsWarp.style.height = window.innerHeight-20+'px';  
    };        
    resizeWorldMapContainer ();//设置容器高宽  
    var myChart = echarts.init(echartsWarp);

    option = {
    		"animation": false,
    		"title": {
    			"text": "时间坐标散点图",
    			"subtext": "dataZoom支持"
    		},
    		"toolbox": {
    			"show": true,
    			"feature": {
    				"mark": {
    					"show": true,
    					"title": {
    						"markUndo": "删除辅助线",
    						"markClear": "清空辅助线",
    						"mark": "辅助线开关"
    					},
    					"lineStyle": {
    						"color": "#1e90ff",
    						"type": "dashed",
    						"width": 2
    					}
    				},
    				"dataView": {
    					"show": true,
    					"title": "数据视图",
    					"readOnly": false,
    					"lang": ["数据视图", "关闭", "刷新"]
    				},
    				"restore": {
    					"show": true,
    					"title": "还原"
    				},
    				"saveAsImage": {
    					"show": true,
    					"title": "保存为图片",
    					"type": "png",
    					"lang": ["点击保存"]
    				}
    			}
    		},
    		"tooltip": {
    			"trigger": "axis",
    			"axisPointer": {
    				"show": true,
    				"type": "cross",
    				"lineStyle": {
    					"type": "dashed",
    					"width": 1
    				}
    			}
    		},
    		"legend": {
    			"data": ["series1"]
    		},
    		"dataRange": {
    			"x": 30,
    			"y": "center",
    			"orient": "horizontal",
    			"min": 0,
    			"max": 100,
    			"splitNumber": 5,
    			"color": ["lightgreen", "orange"]
    		},
    		"dataZoom": [{
    			"show": true,
    			"start": 30,
    			"end": 70
    		}],
    		"grid": {
    			"y2": 80
    		},
    		"xAxis": [{
    			"type": "time",
    			"splitNumber": 10
    		}],
    		"yAxis": [{
    			"type": "value"
    		}],
    		"series": [{
    			"data": [
    				["2014-10-05 03:58", 8, 68],
    				["2014-10-04 13:22", 23, 9],
    				["2014-10-05 21:06", 11, 41],
    				["2014-10-01 14:49", 0, 74],
    				["2014-10-05 21:42", 20, 52],
    				["2014-10-07 07:50", 17, 66],
    				["2014-10-04 10:03", 20, 95],
    				["2014-10-03 18:32", 4, 9],
    				["2014-10-06 11:41", 21, 42],
    				["2014-10-06 01:13", 1, 34],
    				["2014-10-04 10:56", 10, 3],
    				["2014-10-05 06:13", 10, 10],
    				["2014-10-03 01:33", 24, 4],
    				["2014-10-06 18:36", 24, 29],
    				["2014-10-03 11:59", 23, 81],
    				["2014-10-02 01:36", 10, 41],
    				["2014-10-02 14:36", 22, 82],
    				["2014-10-06 17:29", 22, 8],
    				["2014-10-06 20:22", 17, 70],
    				["2014-10-01 18:35", 11, 97],
    				["2014-10-02 00:08", 6, 76],
    				["2014-10-05 17:58", 11, 57],
    				["2014-10-05 13:56", 14, 57],
    				["2014-10-03 12:56", 22, 8],
    				["2014-10-02 03:53", 4, 26],
    				["2014-10-07 13:20", 7, 95],
    				["2014-10-06 12:08", 2, 77],
    				["2014-10-05 06:14", 22, 84],
    				["2014-10-05 04:19", 12, 72],
    				["2014-10-02 09:32", 27, 71],
    				["2014-10-06 05:05", 13, 21],
    				["2014-10-04 07:41", 23, 65],
    				["2014-10-07 04:46", 19, 65],
    				["2014-10-05 17:53", 22, 100],
    				["2014-10-04 05:24", 4, 29],
    				["2014-10-03 13:18", 1, 32],
    				["2014-10-02 03:32", 7, 0],
    				["2014-10-07 15:15", 29, 39],
    				["2014-10-03 01:49", 0, 78],
    				["2014-10-01 20:51", 4, 90],
    				["2014-10-01 02:11", 24, 67],
    				["2014-10-04 08:27", 7, 82],
    				["2014-10-01 10:27", 11, 49],
    				["2014-10-05 21:59", 0, 78],
    				["2014-10-06 08:45", 14, 11],
    				["2014-10-06 08:18", 19, 96],
    				["2014-10-07 05:58", 9, 91],
    				["2014-10-02 07:58", 25, 3],
    				["2014-10-02 09:12", 28, 66],
    				["2014-10-02 00:53", 14, 54],
    				["2014-10-04 15:35", 26, 5],
    				["2014-10-02 21:58", 23, 91],
    				["2014-10-02 11:28", 30, 2],
    				["2014-10-07 17:42", 3, 81],
    				["2014-10-04 03:29", 29, 28],
    				["2014-10-02 10:26", 26, 73],
    				["2014-10-02 14:37", 29, 67],
    				["2014-10-07 19:03", 7, 25],
    				["2014-10-05 08:58", 16, 90],
    				["2014-10-05 07:00", 17, 99],
    				["2014-10-04 22:29", 24, 45],
    				["2014-10-01 08:22", 14, 56],
    				["2014-10-02 21:59", 14, 55],
    				["2014-10-02 10:06", 22, 18],
    				["2014-10-03 15:13", 26, 47],
    				["2014-10-02 03:49", 6, 72],
    				["2014-10-05 15:24", 11, 99],
    				["2014-10-03 20:49", 8, 67],
    				["2014-10-06 21:03", 16, 23],
    				["2014-10-04 23:21", 11, 21],
    				["2014-10-02 06:44", 24, 71],
    				["2014-10-04 02:38", 12, 88],
    				["2014-10-03 19:08", 16, 35],
    				["2014-10-04 06:36", 19, 71],
    				["2014-10-01 08:53", 28, 51],
    				["2014-10-06 20:24", 4, 73],
    				["2014-10-02 17:26", 6, 95],
    				["2014-10-03 15:10", 1, 37],
    				["2014-10-01 03:12", 22, 3],
    				["2014-10-05 10:29", 5, 92],
    				["2014-10-06 01:23", 7, 7],
    				["2014-10-03 03:08", 18, 8],
    				["2014-10-04 02:52", 2, 44],
    				["2014-10-07 01:00", 20, 89],
    				["2014-10-05 20:00", 18, 12],
    				["2014-10-04 01:51", 13, 19],
    				["2014-10-03 10:31", 15, 1],
    				["2014-10-04 13:52", 16, 83],
    				["2014-10-05 01:04", 16, 45],
    				["2014-10-06 02:26", 23, 46],
    				["2014-10-03 01:10", 6, 30],
    				["2014-10-04 00:33", 15, 78],
    				["2014-10-05 00:16", 16, 47],
    				["2014-10-07 09:41", 8, 68],
    				["2014-10-03 09:20", 12, 97],
    				["2014-10-07 16:07", 26, 32],
    				["2014-10-01 21:59", 11, 15],
    				["2014-10-01 07:38", 28, 23],
    				["2014-10-06 16:08", 15, 61],
    				["2014-10-06 18:08", 6, 59],
    				["2014-10-06 23:31", 16, 35],
    				["2014-10-02 17:47", 30, 47],
    				["2014-10-01 01:15", 13, 31],
    				["2014-10-01 03:27", 8, 54],
    				["2014-10-07 09:40", 5, 90],
    				["2014-10-07 02:34", 30, 13],
    				["2014-10-07 04:08", 4, 42],
    				["2014-10-06 06:12", 14, 15],
    				["2014-10-07 21:20", 3, 24],
    				["2014-10-03 08:36", 11, 32],
    				["2014-10-03 04:55", 9, 48],
    				["2014-10-04 04:20", 3, 57],
    				["2014-10-02 01:49", 29, 11],
    				["2014-10-01 13:38", 29, 75],
    				["2014-10-03 09:55", 20, 87],
    				["2014-10-06 23:33", 21, 14],
    				["2014-10-02 17:46", 11, 70],
    				["2014-10-02 10:20", 21, 76],
    				["2014-10-07 12:15", 18, 9],
    				["2014-10-06 02:41", 28, 37],
    				["2014-10-05 04:27", 14, 64],
    				["2014-10-06 05:35", 26, 56],
    				["2014-10-05 06:23", 11, 56],
    				["2014-10-05 20:26", 12, 99],
    				["2014-10-04 08:10", 20, 49],
    				["2014-10-05 05:59", 26, 72],
    				["2014-10-04 14:34", 25, 0],
    				["2014-10-04 22:24", 29, 35],
    				["2014-10-02 08:47", 5, 17],
    				["2014-10-02 06:37", 9, 39],
    				["2014-10-06 02:04", 19, 44],
    				["2014-10-04 03:20", 18, 65],
    				["2014-10-03 12:41", 27, 58],
    				["2014-10-04 16:36", 21, 17],
    				["2014-10-06 15:50", 1, 1],
    				["2014-10-03 19:40", 0, 24],
    				["2014-10-05 01:46", 25, 40],
    				["2014-10-05 07:22", 13, 53],
    				["2014-10-02 04:56", 11, 25],
    				["2014-10-07 02:00", 2, 96],
    				["2014-10-05 12:13", 6, 25],
    				["2014-10-04 15:31", 6, 98],
    				["2014-10-01 13:10", 0, 60],
    				["2014-10-04 18:33", 7, 6],
    				["2014-10-02 11:29", 7, 13],
    				["2014-10-01 12:45", 26, 73],
    				["2014-10-01 03:14", 17, 82],
    				["2014-10-02 16:30", 22, 73],
    				["2014-10-01 02:28", 4, 57],
    				["2014-10-03 08:40", 1, 53],
    				["2014-10-04 10:11", 22, 95],
    				["2014-10-05 13:34", 12, 30],
    				["2014-10-05 18:01", 3, 80],
    				["2014-10-05 07:48", 30, 85],
    				["2014-10-03 14:13", 19, 80],
    				["2014-10-03 02:06", 24, 57],
    				["2014-10-04 06:56", 27, 92],
    				["2014-10-03 04:49", 22, 85],
    				["2014-10-05 02:43", 16, 5],
    				["2014-10-07 20:48", 5, 47],
    				["2014-10-04 11:56", 27, 21],
    				["2014-10-06 23:35", 1, 0],
    				["2014-10-01 18:08", 27, 57],
    				["2014-10-04 11:37", 19, 95],
    				["2014-10-04 10:15", 11, 40],
    				["2014-10-03 22:20", 3, 24],
    				["2014-10-07 09:53", 15, 70],
    				["2014-10-04 12:33", 9, 91],
    				["2014-10-04 00:56", 26, 35],
    				["2014-10-04 17:19", 19, 28],
    				["2014-10-03 03:29", 0, 35],
    				["2014-10-01 03:20", 1, 22],
    				["2014-10-02 17:34", 12, 14],
    				["2014-10-07 19:43", 4, 78],
    				["2014-10-03 21:29", 3, 58],
    				["2014-10-05 23:09", 1, 28],
    				["2014-10-01 11:19", 6, 61],
    				["2014-10-04 06:38", 12, 52],
    				["2014-10-01 00:29", 17, 92],
    				["2014-10-03 03:49", 16, 59],
    				["2014-10-05 16:24", 25, 2],
    				["2014-10-04 02:14", 17, 2],
    				["2014-10-02 09:43", 15, 91],
    				["2014-10-07 17:26", 12, 20],
    				["2014-10-03 05:42", 8, 85],
    				["2014-10-03 02:04", 13, 76],
    				["2014-10-01 09:06", 0, 38],
    				["2014-10-02 14:39", 13, 11],
    				["2014-10-02 14:20", 16, 32],
    				["2014-10-06 03:24", 0, 81],
    				["2014-10-06 21:09", 9, 30],
    				["2014-10-04 05:02", 4, 7],
    				["2014-10-01 04:11", 25, 7],
    				["2014-10-05 14:28", 13, 13],
    				["2014-10-03 03:36", 23, 70],
    				["2014-10-07 19:37", 24, 26],
    				["2014-10-04 21:35", 4, 8],
    				["2014-10-01 10:33", 8, 19],
    				["2014-10-02 17:30", 21, 64],
    				["2014-10-02 18:02", 21, 82],
    				["2014-10-06 07:02", 20, 64],
    				["2014-10-06 20:41", 14, 56],
    				["2014-10-03 11:14", 20, 36],
    				["2014-10-03 13:54", 1, 77],
    				["2014-10-04 04:08", 11, 52],
    				["2014-10-02 02:42", 4, 59],
    				["2014-10-05 15:02", 4, 33],
    				["2014-10-07 16:41", 3, 26],
    				["2014-10-05 04:17", 3, 24],
    				["2014-10-01 06:18", 6, 38],
    				["2014-10-04 11:19", 30, 0],
    				["2014-10-02 07:33", 11, 66],
    				["2014-10-06 09:38", 28, 49],
    				["2014-10-04 00:18", 3, 90],
    				["2014-10-05 05:32", 28, 18],
    				["2014-10-01 11:23", 25, 33],
    				["2014-10-04 05:21", 2, 23],
    				["2014-10-05 18:38", 3, 75],
    				["2014-10-06 17:29", 0, 97],
    				["2014-10-05 15:40", 4, 63],
    				["2014-10-02 22:47", 16, 2],
    				["2014-10-04 02:31", 6, 17],
    				["2014-10-05 00:44", 28, 69],
    				["2014-10-06 23:07", 8, 30],
    				["2014-10-02 06:56", 20, 92],
    				["2014-10-05 05:33", 4, 64],
    				["2014-10-03 21:49", 25, 30],
    				["2014-10-03 07:11", 15, 31],
    				["2014-10-04 10:24", 20, 42],
    				["2014-10-05 12:00", 12, 87],
    				["2014-10-07 04:21", 0, 55],
    				["2014-10-04 15:25", 27, 75],
    				["2014-10-04 22:22", 24, 84],
    				["2014-10-06 19:21", 22, 49],
    				["2014-10-02 00:13", 11, 34],
    				["2014-10-05 18:37", 9, 7],
    				["2014-10-01 12:29", 30, 21],
    				["2014-10-03 16:57", 13, 6],
    				["2014-10-01 04:42", 26, 69],
    				["2014-10-07 14:06", 18, 94],
    				["2014-10-07 13:42", 2, 24],
    				["2014-10-03 17:46", 9, 99],
    				["2014-10-04 19:53", 16, 25],
    				["2014-10-05 05:17", 7, 36],
    				["2014-10-03 02:20", 11, 36],
    				["2014-10-04 23:02", 7, 0],
    				["2014-10-03 05:55", 6, 12],
    				["2014-10-01 20:17", 19, 80],
    				["2014-10-01 17:25", 30, 29],
    				["2014-10-04 03:34", 11, 67],
    				["2014-10-06 08:46", 1, 88],
    				["2014-10-03 05:01", 28, 59],
    				["2014-10-05 10:36", 1, 13],
    				["2014-10-04 05:45", 2, 88],
    				["2014-10-07 01:12", 4, 30],
    				["2014-10-03 03:18", 12, 81],
    				["2014-10-04 14:47", 28, 70],
    				["2014-10-04 19:12", 6, 2],
    				["2014-10-04 18:04", 25, 90],
    				["2014-10-03 06:23", 15, 37],
    				["2014-10-04 15:15", 20, 67],
    				["2014-10-05 01:45", 24, 63],
    				["2014-10-07 15:33", 3, 2],
    				["2014-10-03 09:56", 14, 28],
    				["2014-10-03 01:10", 3, 76],
    				["2014-10-06 17:34", 13, 47],
    				["2014-10-05 11:28", 0, 17],
    				["2014-10-06 07:33", 29, 40],
    				["2014-10-06 13:00", 26, 35],
    				["2014-10-05 06:11", 16, 35],
    				["2014-10-04 05:10", 17, 87],
    				["2014-10-06 02:51", 29, 98],
    				["2014-10-02 20:37", 28, 99],
    				["2014-10-04 15:12", 2, 41],
    				["2014-10-04 04:53", 9, 68],
    				["2014-10-07 10:31", 27, 27],
    				["2014-10-04 05:57", 21, 11],
    				["2014-10-06 07:30", 6, 53],
    				["2014-10-07 18:49", 16, 71],
    				["2014-10-03 13:21", 16, 9],
    				["2014-10-01 22:06", 14, 95],
    				["2014-10-01 17:35", 5, 16],
    				["2014-10-03 17:48", 1, 49],
    				["2014-10-07 21:42", 8, 16],
    				["2014-10-05 17:47", 2, 61],
    				["2014-10-02 00:46", 25, 100],
    				["2014-10-05 03:33", 14, 90],
    				["2014-10-01 11:05", 21, 86],
    				["2014-10-05 01:41", 7, 88],
    				["2014-10-06 10:25", 11, 44],
    				["2014-10-03 09:57", 27, 70],
    				["2014-10-02 14:40", 0, 9],
    				["2014-10-01 20:51", 10, 87],
    				["2014-10-07 10:06", 11, 62],
    				["2014-10-05 13:06", 28, 16],
    				["2014-10-03 04:43", 24, 46],
    				["2014-10-06 14:18", 14, 14],
    				["2014-10-03 09:41", 23, 83],
    				["2014-10-04 22:24", 13, 24],
    				["2014-10-02 01:32", 6, 18],
    				["2014-10-02 11:52", 3, 63],
    				["2014-10-03 12:36", 23, 98],
    				["2014-10-06 19:00", 20, 14],
    				["2014-10-06 14:12", 3, 2],
    				["2014-10-06 13:31", 6, 77],
    				["2014-10-04 15:40", 28, 25],
    				["2014-10-04 06:47", 7, 89],
    				["2014-10-03 21:23", 16, 9],
    				["2014-10-06 14:06", 11, 67],
    				["2014-10-01 19:18", 17, 48],
    				["2014-10-03 23:27", 4, 34],
    				["2014-10-05 17:08", 3, 77],
    				["2014-10-03 23:28", 9, 57],
    				["2014-10-03 04:37", 24, 43],
    				["2014-10-03 07:48", 17, 13],
    				["2014-10-04 06:16", 21, 70],
    				["2014-10-02 21:53", 12, 78],
    				["2014-10-02 20:33", 22, 77],
    				["2014-10-05 21:34", 14, 75],
    				["2014-10-05 10:39", 21, 55],
    				["2014-10-01 19:28", 5, 37],
    				["2014-10-07 17:08", 14, 4],
    				["2014-10-07 03:18", 28, 44],
    				["2014-10-02 09:48", 20, 54],
    				["2014-10-02 11:14", 26, 26],
    				["2014-10-01 01:38", 29, 40],
    				["2014-10-05 05:47", 0, 38],
    				["2014-10-02 22:41", 8, 61],
    				["2014-10-05 02:10", 8, 74],
    				["2014-10-05 04:07", 0, 68],
    				["2014-10-02 14:30", 1, 30],
    				["2014-10-01 19:34", 11, 66],
    				["2014-10-01 10:28", 14, 90],
    				["2014-10-07 21:49", 23, 98],
    				["2014-10-03 02:06", 17, 77],
    				["2014-10-02 22:39", 11, 6],
    				["2014-10-01 22:22", 17, 95],
    				["2014-10-05 10:17", 19, 7],
    				["2014-10-05 19:15", 20, 3],
    				["2014-10-06 09:45", 17, 86],
    				["2014-10-04 05:52", 15, 2],
    				["2014-10-05 20:35", 21, 41],
    				["2014-10-02 13:02", 26, 81],
    				["2014-10-03 12:44", 3, 44],
    				["2014-10-02 11:15", 28, 9],
    				["2014-10-04 10:02", 4, 29],
    				["2014-10-03 13:35", 20, 6],
    				["2014-10-04 21:01", 18, 55],
    				["2014-10-02 01:02", 23, 97],
    				["2014-10-03 14:37", 20, 90],
    				["2014-10-06 01:30", 3, 66],
    				["2014-10-02 01:08", 22, 41],
    				["2014-10-04 00:46", 2, 79],
    				["2014-10-02 14:51", 7, 53],
    				["2014-10-05 05:54", 12, 47],
    				["2014-10-07 11:42", 2, 55],
    				["2014-10-04 23:05", 5, 4],
    				["2014-10-03 20:10", 5, 76],
    				["2014-10-04 04:40", 26, 64],
    				["2014-10-02 21:53", 19, 45],
    				["2014-10-02 16:00", 22, 57],
    				["2014-10-02 02:27", 2, 5],
    				["2014-10-05 17:26", 17, 70],
    				["2014-10-06 22:22", 15, 76],
    				["2014-10-06 01:12", 15, 95],
    				["2014-10-02 02:44", 6, 32],
    				["2014-10-07 16:26", 22, 20],
    				["2014-10-04 00:30", 3, 9],
    				["2014-10-06 03:34", 10, 23],
    				["2014-10-04 09:01", 11, 16],
    				["2014-10-02 19:35", 6, 0],
    				["2014-10-07 10:30", 14, 37],
    				["2014-10-06 13:18", 18, 11],
    				["2014-10-05 06:25", 23, 38],
    				["2014-10-03 00:26", 22, 54],
    				["2014-10-02 14:47", 29, 2],
    				["2014-10-05 09:35", 4, 49],
    				["2014-10-05 04:29", 29, 32],
    				["2014-10-05 11:43", 19, 81],
    				["2014-10-04 03:47", 13, 1],
    				["2014-10-04 17:20", 7, 43],
    				["2014-10-03 20:19", 7, 2],
    				["2014-10-04 20:52", 21, 34],
    				["2014-10-07 16:03", 14, 17],
    				["2014-10-01 19:31", 15, 84],
    				["2014-10-05 00:55", 11, 94],
    				["2014-10-05 22:39", 8, 10],
    				["2014-10-04 22:05", 8, 31],
    				["2014-10-04 20:50", 28, 38],
    				["2014-10-01 12:29", 17, 82],
    				["2014-10-05 16:15", 26, 74],
    				["2014-10-05 22:00", 20, 46],
    				["2014-10-02 06:07", 30, 42],
    				["2014-10-07 06:47", 24, 24],
    				["2014-10-01 06:42", 4, 74],
    				["2014-10-07 15:04", 27, 26],
    				["2014-10-07 22:23", 9, 53],
    				["2014-10-04 18:29", 4, 54],
    				["2014-10-06 05:30", 29, 53],
    				["2014-10-04 00:41", 19, 7],
    				["2014-10-06 08:05", 11, 26],
    				["2014-10-05 04:27", 26, 34],
    				["2014-10-06 11:35", 24, 94],
    				["2014-10-01 02:07", 9, 87],
    				["2014-10-02 01:26", 22, 87],
    				["2014-10-02 21:24", 26, 15],
    				["2014-10-07 08:11", 21, 13],
    				["2014-10-07 05:21", 18, 22],
    				["2014-10-05 08:49", 23, 32],
    				["2014-10-02 17:27", 28, 43],
    				["2014-10-02 04:29", 12, 61],
    				["2014-10-03 06:05", 26, 67],
    				["2014-10-01 05:42", 2, 51],
    				["2014-10-04 18:44", 29, 56],
    				["2014-10-04 03:31", 13, 94],
    				["2014-10-04 17:34", 26, 80],
    				["2014-10-07 03:47", 11, 8],
    				["2014-10-04 13:50", 20, 71],
    				["2014-10-05 10:00", 12, 23],
    				["2014-10-06 17:37", 27, 12],
    				["2014-10-01 05:25", 22, 61],
    				["2014-10-06 07:14", 19, 36],
    				["2014-10-05 10:40", 6, 0],
    				["2014-10-06 11:03", 6, 48],
    				["2014-10-05 09:14", 22, 62],
    				["2014-10-02 15:28", 2, 44],
    				["2014-10-01 21:43", 16, 34],
    				["2014-10-01 19:30", 11, 14],
    				["2014-10-01 11:57", 6, 70],
    				["2014-10-06 19:01", 4, 66],
    				["2014-10-05 01:00", 30, 16],
    				["2014-10-03 07:58", 24, 6],
    				["2014-10-01 11:05", 4, 48],
    				["2014-10-02 06:34", 19, 25],
    				["2014-10-01 03:19", 4, 93],
    				["2014-10-05 20:32", 0, 2],
    				["2014-10-07 13:42", 28, 67],
    				["2014-10-07 12:38", 14, 68],
    				["2014-10-07 09:28", 29, 7],
    				["2014-10-03 06:55", 16, 21],
    				["2014-10-01 01:37", 7, 68],
    				["2014-10-07 20:26", 3, 58],
    				["2014-10-04 18:43", 18, 30],
    				["2014-10-01 23:34", 16, 82],
    				["2014-10-06 04:40", 14, 11],
    				["2014-10-03 01:15", 21, 68],
    				["2014-10-03 05:43", 30, 85],
    				["2014-10-05 00:34", 6, 80],
    				["2014-10-06 11:39", 2, 85],
    				["2014-10-07 10:13", 17, 2],
    				["2014-10-07 06:28", 23, 15],
    				["2014-10-04 02:11", 27, 56],
    				["2014-10-04 20:39", 20, 77],
    				["2014-10-05 20:43", 20, 43],
    				["2014-10-07 22:11", 5, 11],
    				["2014-10-02 09:56", 8, 54],
    				["2014-10-06 18:46", 25, 8],
    				["2014-10-04 13:45", 15, 62],
    				["2014-10-03 06:51", 24, 97],
    				["2014-10-01 18:54", 30, 21],
    				["2014-10-06 13:43", 24, 35],
    				["2014-10-07 16:40", 30, 33],
    				["2014-10-06 01:45", 8, 76],
    				["2014-10-03 05:09", 18, 65],
    				["2014-10-04 07:19", 3, 18],
    				["2014-10-01 16:34", 23, 71],
    				["2014-10-06 06:33", 8, 99],
    				["2014-10-05 19:01", 9, 12],
    				["2014-10-07 20:38", 24, 86],
    				["2014-10-04 16:31", 0, 80],
    				["2014-10-02 01:31", 9, 79],
    				["2014-10-05 16:53", 2, 67],
    				["2014-10-06 15:23", 15, 36],
    				["2014-10-07 06:34", 18, 79],
    				["2014-10-07 14:20", 21, 26],
    				["2014-10-06 09:34", 22, 27],
    				["2014-10-05 13:57", 24, 29],
    				["2014-10-07 02:06", 9, 60],
    				["2014-10-02 14:37", 20, 80],
    				["2014-10-03 15:43", 15, 76],
    				["2014-10-05 03:28", 28, 48],
    				["2014-10-02 14:04", 29, 30],
    				["2014-10-02 01:05", 10, 65],
    				["2014-10-06 12:44", 14, 73],
    				["2014-10-06 17:20", 0, 27],
    				["2014-10-04 11:05", 8, 16],
    				["2014-10-02 11:23", 20, 25],
    				["2014-10-01 11:43", 13, 1],
    				["2014-10-04 14:01", 18, 54],
    				["2014-10-06 06:12", 7, 64],
    				["2014-10-05 18:11", 27, 78],
    				["2014-10-01 00:07", 3, 5],
    				["2014-10-02 10:29", 12, 99],
    				["2014-10-05 00:45", 16, 23],
    				["2014-10-04 10:15", 4, 45],
    				["2014-10-02 08:51", 15, 61],
    				["2014-10-03 12:09", 6, 85],
    				["2014-10-02 02:20", 22, 48],
    				["2014-10-01 08:38", 13, 30],
    				["2014-10-04 12:10", 19, 50],
    				["2014-10-01 06:03", 9, 70],
    				["2014-10-05 12:16", 26, 23],
    				["2014-10-02 03:13", 20, 83],
    				["2014-10-03 04:00", 29, 98],
    				["2014-10-07 05:07", 5, 17],
    				["2014-10-04 01:04", 17, 33],
    				["2014-10-03 17:18", 13, 78],
    				["2014-10-03 08:50", 18, 38],
    				["2014-10-02 19:08", 2, 30],
    				["2014-10-06 13:45", 25, 11],
    				["2014-10-02 05:40", 12, 16],
    				["2014-10-04 04:41", 2, 13],
    				["2014-10-04 04:57", 0, 75],
    				["2014-10-06 05:03", 5, 7],
    				["2014-10-04 00:31", 2, 38],
    				["2014-10-06 13:37", 4, 88],
    				["2014-10-03 12:16", 9, 94],
    				["2014-10-03 06:09", 19, 86],
    				["2014-10-03 21:00", 27, 50],
    				["2014-10-01 16:13", 15, 91],
    				["2014-10-05 08:32", 25, 8],
    				["2014-10-05 02:46", 30, 61],
    				["2014-10-02 22:29", 29, 4],
    				["2014-10-05 01:41", 15, 9],
    				["2014-10-02 12:11", 12, 83],
    				["2014-10-06 09:47", 20, 72],
    				["2014-10-01 12:18", 2, 23],
    				["2014-10-02 01:47", 5, 83],
    				["2014-10-03 17:34", 24, 75],
    				["2014-10-05 06:10", 13, 11],
    				["2014-10-05 04:34", 1, 63],
    				["2014-10-04 12:19", 14, 25],
    				["2014-10-05 06:59", 1, 41],
    				["2014-10-07 02:40", 14, 72],
    				["2014-10-02 05:12", 2, 45],
    				["2014-10-01 23:28", 5, 71],
    				["2014-10-06 10:25", 28, 66],
    				["2014-10-04 04:09", 11, 31],
    				["2014-10-02 06:05", 13, 51],
    				["2014-10-06 07:44", 12, 28],
    				["2014-10-03 21:59", 20, 63],
    				["2014-10-06 03:57", 16, 38],
    				["2014-10-01 17:40", 9, 51],
    				["2014-10-03 21:19", 15, 28],
    				["2014-10-06 18:47", 0, 59],
    				["2014-10-03 12:29", 4, 98],
    				["2014-10-06 10:11", 4, 46],
    				["2014-10-01 13:41", 9, 20],
    				["2014-10-04 05:05", 16, 26],
    				["2014-10-03 04:56", 18, 39],
    				["2014-10-04 06:47", 16, 45],
    				["2014-10-01 04:39", 18, 55],
    				["2014-10-03 01:24", 15, 91],
    				["2014-10-04 03:44", 10, 53],
    				["2014-10-06 19:20", 11, 78],
    				["2014-10-01 23:24", 23, 4],
    				["2014-10-05 17:45", 7, 7],
    				["2014-10-01 13:27", 27, 73],
    				["2014-10-06 00:55", 7, 70],
    				["2014-10-06 03:53", 16, 49],
    				["2014-10-05 01:53", 19, 73],
    				["2014-10-07 10:18", 22, 17],
    				["2014-10-04 04:08", 9, 12],
    				["2014-10-02 04:56", 27, 18],
    				["2014-10-01 15:12", 15, 56],
    				["2014-10-03 07:02", 22, 58],
    				["2014-10-03 00:06", 23, 30],
    				["2014-10-02 03:19", 28, 35],
    				["2014-10-06 07:42", 5, 96],
    				["2014-10-04 23:34", 29, 33],
    				["2014-10-05 15:57", 4, 33],
    				["2014-10-05 12:41", 2, 38],
    				["2014-10-04 16:25", 2, 56],
    				["2014-10-05 09:11", 12, 92],
    				["2014-10-02 05:34", 12, 44],
    				["2014-10-01 10:13", 17, 77],
    				["2014-10-05 05:47", 12, 6],
    				["2014-10-03 13:39", 30, 13],
    				["2014-10-07 19:29", 9, 27],
    				["2014-10-03 11:55", 17, 90],
    				["2014-10-03 15:12", 15, 82],
    				["2014-10-02 18:03", 8, 69],
    				["2014-10-03 07:17", 23, 7],
    				["2014-10-03 05:29", 2, 34],
    				["2014-10-01 10:07", 11, 38],
    				["2014-10-01 05:13", 11, 13],
    				["2014-10-05 02:07", 15, 69],
    				["2014-10-03 12:21", 4, 48],
    				["2014-10-05 07:53", 14, 44],
    				["2014-10-05 14:47", 22, 96],
    				["2014-10-02 00:36", 11, 97],
    				["2014-10-01 21:12", 28, 43],
    				["2014-10-05 01:10", 12, 33],
    				["2014-10-06 09:20", 0, 68],
    				["2014-10-07 08:46", 18, 22],
    				["2014-10-05 09:40", 6, 100],
    				["2014-10-07 16:29", 20, 69],
    				["2014-10-03 22:34", 23, 38],
    				["2014-10-07 11:58", 20, 46],
    				["2014-10-02 22:58", 27, 30],
    				["2014-10-02 17:14", 28, 96],
    				["2014-10-06 00:49", 22, 54],
    				["2014-10-02 18:08", 0, 30],
    				["2014-10-03 10:21", 4, 16],
    				["2014-10-07 00:54", 10, 72],
    				["2014-10-01 01:42", 28, 91],
    				["2014-10-03 00:12", 12, 64],
    				["2014-10-06 11:09", 22, 92],
    				["2014-10-04 21:07", 1, 54],
    				["2014-10-05 10:59", 23, 62],
    				["2014-10-05 11:28", 24, 62],
    				["2014-10-01 18:00", 30, 54],
    				["2014-10-06 07:19", 27, 5],
    				["2014-10-04 04:42", 28, 66],
    				["2014-10-05 02:05", 29, 87],
    				["2014-10-01 13:50", 6, 96],
    				["2014-10-03 07:56", 6, 25],
    				["2014-10-07 16:45", 12, 2],
    				["2014-10-03 16:49", 5, 30],
    				["2014-10-05 02:32", 14, 77],
    				["2014-10-06 02:14", 26, 98],
    				["2014-10-06 20:50", 18, 21],
    				["2014-10-01 21:13", 26, 88],
    				["2014-10-05 00:22", 19, 88],
    				["2014-10-02 06:09", 3, 11],
    				["2014-10-03 05:42", 30, 79],
    				["2014-10-06 00:35", 12, 90],
    				["2014-10-04 00:24", 3, 75],
    				["2014-10-04 03:34", 30, 16],
    				["2014-10-07 12:40", 20, 88],
    				["2014-10-05 01:53", 25, 68],
    				["2014-10-03 10:52", 0, 8],
    				["2014-10-03 07:59", 28, 66],
    				["2014-10-07 21:41", 7, 87],
    				["2014-10-05 00:43", 28, 0],
    				["2014-10-03 02:42", 22, 16],
    				["2014-10-02 15:00", 8, 9],
    				["2014-10-05 11:42", 2, 72],
    				["2014-10-06 20:26", 3, 18],
    				["2014-10-02 06:20", 25, 59],
    				["2014-10-07 16:10", 26, 14],
    				["2014-10-01 00:30", 14, 37],
    				["2014-10-04 11:24", 3, 3],
    				["2014-10-04 03:50", 28, 60],
    				["2014-10-03 11:48", 29, 27],
    				["2014-10-07 21:39", 25, 24],
    				["2014-10-03 06:18", 15, 22],
    				["2014-10-02 17:56", 19, 66],
    				["2014-10-01 22:45", 28, 21],
    				["2014-10-06 12:43", 2, 6],
    				["2014-10-01 11:39", 7, 38],
    				["2014-10-02 21:30", 8, 20],
    				["2014-10-01 22:14", 5, 15],
    				["2014-10-06 13:30", 30, 7],
    				["2014-10-04 00:21", 29, 40],
    				["2014-10-02 12:48", 19, 33],
    				["2014-10-01 21:01", 29, 23],
    				["2014-10-05 22:44", 28, 68],
    				["2014-10-04 07:58", 11, 15],
    				["2014-10-04 23:03", 26, 56],
    				["2014-10-03 03:56", 12, 28],
    				["2014-10-03 03:38", 24, 26],
    				["2014-10-05 22:01", 14, 89],
    				["2014-10-04 11:42", 29, 82],
    				["2014-10-05 19:58", 5, 86],
    				["2014-10-05 17:45", 17, 49],
    				["2014-10-01 11:13", 27, 8],
    				["2014-10-05 10:37", 28, 26],
    				["2014-10-06 16:25", 6, 17],
    				["2014-10-03 14:57", 13, 66],
    				["2014-10-06 06:50", 22, 11],
    				["2014-10-07 06:53", 23, 20],
    				["2014-10-04 16:40", 23, 50],
    				["2014-10-07 00:17", 6, 15],
    				["2014-10-07 13:10", 13, 39],
    				["2014-10-03 07:27", 21, 30],
    				["2014-10-07 12:04", 28, 86],
    				["2014-10-01 07:36", 22, 74],
    				["2014-10-02 08:04", 15, 3],
    				["2014-10-01 04:31", 14, 87],
    				["2014-10-01 08:29", 6, 62],
    				["2014-10-02 04:04", 24, 95],
    				["2014-10-01 09:48", 8, 61],
    				["2014-10-05 16:00", 11, 35],
    				["2014-10-03 14:12", 27, 7],
    				["2014-10-04 20:48", 21, 86],
    				["2014-10-07 16:29", 17, 35],
    				["2014-10-01 04:38", 16, 73],
    				["2014-10-01 23:46", 17, 25],
    				["2014-10-06 20:55", 0, 80],
    				["2014-10-03 05:55", 24, 69],
    				["2014-10-06 06:51", 26, 53],
    				["2014-10-07 02:52", 24, 63],
    				["2014-10-02 01:35", 1, 63],
    				["2014-10-07 16:36", 3, 95],
    				["2014-10-05 16:43", 14, 99],
    				["2014-10-05 11:10", 12, 3],
    				["2014-10-05 09:41", 22, 60],
    				["2014-10-05 07:29", 24, 97],
    				["2014-10-01 00:15", 12, 16],
    				["2014-10-03 09:01", 1, 37],
    				["2014-10-02 12:59", 21, 3],
    				["2014-10-06 06:31", 20, 28],
    				["2014-10-06 14:06", 20, 6],
    				["2014-10-05 00:00", 23, 67],
    				["2014-10-01 19:35", 27, 93],
    				["2014-10-06 19:09", 0, 74],
    				["2014-10-07 02:36", 0, 70],
    				["2014-10-04 09:39", 14, 77],
    				["2014-10-05 06:10", 6, 45],
    				["2014-10-06 02:24", 11, 63],
    				["2014-10-04 20:39", 9, 9],
    				["2014-10-04 04:33", 5, 59],
    				["2014-10-02 21:00", 3, 13],
    				["2014-10-02 15:50", 21, 46],
    				["2014-10-06 19:19", 11, 74],
    				["2014-10-05 18:16", 8, 12],
    				["2014-10-02 11:11", 18, 69],
    				["2014-10-01 21:14", 23, 35],
    				["2014-10-01 10:46", 26, 89],
    				["2014-10-02 12:10", 4, 26],
    				["2014-10-03 15:32", 29, 27],
    				["2014-10-06 22:18", 2, 93],
    				["2014-10-07 18:51", 13, 96],
    				["2014-10-03 21:12", 15, 72],
    				["2014-10-01 12:33", 21, 66],
    				["2014-10-05 16:39", 27, 65],
    				["2014-10-04 03:37", 15, 37],
    				["2014-10-04 09:50", 4, 46],
    				["2014-10-06 14:39", 8, 42],
    				["2014-10-05 08:50", 25, 97],
    				["2014-10-05 11:13", 2, 16],
    				["2014-10-03 23:05", 6, 69],
    				["2014-10-06 01:25", 14, 40],
    				["2014-10-06 23:29", 10, 36],
    				["2014-10-02 23:49", 9, 90],
    				["2014-10-03 17:57", 20, 34],
    				["2014-10-02 18:37", 23, 39],
    				["2014-10-04 20:36", 28, 42],
    				["2014-10-01 15:16", 28, 96],
    				["2014-10-05 16:18", 11, 28],
    				["2014-10-03 21:30", 18, 46],
    				["2014-10-07 18:43", 5, 84],
    				["2014-10-06 23:46", 26, 96],
    				["2014-10-01 01:16", 14, 19],
    				["2014-10-04 17:23", 17, 89],
    				["2014-10-01 10:27", 28, 39],
    				["2014-10-06 14:52", 27, 72],
    				["2014-10-04 09:23", 20, 68],
    				["2014-10-03 21:20", 7, 94],
    				["2014-10-04 12:04", 5, 98],
    				["2014-10-07 20:10", 18, 12],
    				["2014-10-01 22:11", 6, 19],
    				["2014-10-01 00:11", 25, 55],
    				["2014-10-03 02:52", 20, 21],
    				["2014-10-02 11:54", 20, 81],
    				["2014-10-05 11:02", 9, 82],
    				["2014-10-05 21:25", 4, 62],
    				["2014-10-04 16:15", 7, 98],
    				["2014-10-01 16:52", 24, 30],
    				["2014-10-02 00:42", 22, 65],
    				["2014-10-01 16:59", 9, 39],
    				["2014-10-02 09:00", 19, 53],
    				["2014-10-06 07:44", 14, 19],
    				["2014-10-02 13:21", 10, 68],
    				["2014-10-05 01:26", 5, 11],
    				["2014-10-02 04:09", 17, 21],
    				["2014-10-07 12:30", 23, 63],
    				["2014-10-07 14:42", 20, 32],
    				["2014-10-06 09:02", 15, 76],
    				["2014-10-03 02:11", 29, 38],
    				["2014-10-06 00:38", 2, 98],
    				["2014-10-04 10:24", 18, 94],
    				["2014-10-01 11:23", 29, 75],
    				["2014-10-02 17:58", 13, 41],
    				["2014-10-01 05:30", 12, 62],
    				["2014-10-03 06:45", 15, 100],
    				["2014-10-05 03:21", 26, 73],
    				["2014-10-07 08:04", 2, 21],
    				["2014-10-01 16:13", 17, 59],
    				["2014-10-01 22:57", 30, 23],
    				["2014-10-01 17:51", 5, 86],
    				["2014-10-06 01:05", 3, 25],
    				["2014-10-06 09:19", 23, 22],
    				["2014-10-02 18:42", 9, 39],
    				["2014-10-07 09:19", 8, 40],
    				["2014-10-07 18:10", 2, 26],
    				["2014-10-04 15:44", 30, 36],
    				["2014-10-05 00:51", 14, 11],
    				["2014-10-07 20:37", 5, 55],
    				["2014-10-04 15:57", 22, 61],
    				["2014-10-07 02:58", 21, 13],
    				["2014-10-07 16:45", 27, 93],
    				["2014-10-03 22:58", 22, 73],
    				["2014-10-05 10:42", 7, 78],
    				["2014-10-01 18:09", 22, 1],
    				["2014-10-03 01:18", 22, 57],
    				["2014-10-04 06:12", 9, 5],
    				["2014-10-07 03:01", 26, 38],
    				["2014-10-03 18:09", 1, 43],
    				["2014-10-06 08:53", 7, 21],
    				["2014-10-06 13:01", 17, 88],
    				["2014-10-05 09:42", 1, 82],
    				["2014-10-04 01:32", 28, 19],
    				["2014-10-02 17:39", 18, 86],
    				["2014-10-04 08:48", 11, 53],
    				["2014-10-02 23:30", 2, 63],
    				["2014-10-05 11:45", 25, 32],
    				["2014-10-01 02:10", 2, 86],
    				["2014-10-04 06:28", 3, 0],
    				["2014-10-05 23:01", 23, 80],
    				["2014-10-03 15:24", 19, 98],
    				["2014-10-07 11:13", 22, 64],
    				["2014-10-04 08:27", 5, 52],
    				["2014-10-05 08:22", 5, 24],
    				["2014-10-06 05:27", 15, 57],
    				["2014-10-04 22:28", 6, 44],
    				["2014-10-05 11:31", 26, 4],
    				["2014-10-07 03:54", 12, 94],
    				["2014-10-03 00:25", 13, 21],
    				["2014-10-05 05:11", 5, 98],
    				["2014-10-06 01:45", 8, 72],
    				["2014-10-02 09:03", 7, 64],
    				["2014-10-05 05:59", 6, 97],
    				["2014-10-06 17:56", 3, 42],
    				["2014-10-01 04:07", 15, 15],
    				["2014-10-02 11:06", 23, 29],
    				["2014-10-06 10:38", 15, 80],
    				["2014-10-06 03:09", 13, 75],
    				["2014-10-02 02:13", 25, 75],
    				["2014-10-04 22:08", 3, 1],
    				["2014-10-04 05:45", 15, 1],
    				["2014-10-01 18:52", 15, 35],
    				["2014-10-07 17:44", 15, 49],
    				["2014-10-02 23:23", 15, 99],
    				["2014-10-02 12:46", 17, 63],
    				["2014-10-06 00:11", 19, 16],
    				["2014-10-04 21:02", 13, 84],
    				["2014-10-04 14:56", 24, 18],
    				["2014-10-04 04:27", 25, 29],
    				["2014-10-06 18:43", 2, 91],
    				["2014-10-01 03:43", 13, 76],
    				["2014-10-06 13:11", 28, 97],
    				["2014-10-04 07:30", 14, 52],
    				["2014-10-03 12:08", 25, 69],
    				["2014-10-02 14:55", 27, 91],
    				["2014-10-05 08:54", 5, 12],
    				["2014-10-06 14:02", 11, 58],
    				["2014-10-07 13:31", 5, 27],
    				["2014-10-07 20:47", 19, 62],
    				["2014-10-06 03:11", 22, 18],
    				["2014-10-06 03:58", 16, 42],
    				["2014-10-06 07:47", 1, 71],
    				["2014-10-03 16:58", 13, 40],
    				["2014-10-01 08:20", 13, 63],
    				["2014-10-04 06:16", 9, 69],
    				["2014-10-04 13:02", 26, 9],
    				["2014-10-01 08:37", 16, 82],
    				["2014-10-01 15:50", 19, 14],
    				["2014-10-03 13:28", 16, 86],
    				["2014-10-04 22:12", 11, 39],
    				["2014-10-07 01:49", 29, 54],
    				["2014-10-05 14:52", 21, 83],
    				["2014-10-04 10:13", 29, 17],
    				["2014-10-03 12:17", 16, 8],
    				["2014-10-05 01:52", 25, 77],
    				["2014-10-02 08:46", 27, 31],
    				["2014-10-01 00:21", 14, 28],
    				["2014-10-05 05:56", 22, 73],
    				["2014-10-01 11:49", 4, 37],
    				["2014-10-05 22:18", 16, 31],
    				["2014-10-03 07:44", 8, 81],
    				["2014-10-02 10:55", 14, 85],
    				["2014-10-05 12:32", 21, 88],
    				["2014-10-01 02:46", 11, 62],
    				["2014-10-04 21:01", 22, 71],
    				["2014-10-05 06:30", 0, 93],
    				["2014-10-01 03:36", 20, 40],
    				["2014-10-03 18:27", 0, 27],
    				["2014-10-07 03:59", 20, 39],
    				["2014-10-05 21:31", 18, 47],
    				["2014-10-03 06:37", 2, 85],
    				["2014-10-01 08:52", 4, 23],
    				["2014-10-06 05:52", 7, 1],
    				["2014-10-03 09:15", 2, 29],
    				["2014-10-01 19:19", 26, 73],
    				["2014-10-02 22:23", 5, 85],
    				["2014-10-01 08:37", 13, 9],
    				["2014-10-02 20:21", 16, 23],
    				["2014-10-03 17:18", 15, 67],
    				["2014-10-05 11:44", 3, 19],
    				["2014-10-02 16:43", 27, 65],
    				["2014-10-03 06:49", 23, 37],
    				["2014-10-07 06:30", 5, 18],
    				["2014-10-02 23:17", 17, 48],
    				["2014-10-07 19:49", 14, 58],
    				["2014-10-05 21:11", 5, 16],
    				["2014-10-07 19:58", 3, 21],
    				["2014-10-06 18:47", 2, 72],
    				["2014-10-05 02:17", 20, 61],
    				["2014-10-02 15:47", 14, 18],
    				["2014-10-06 23:57", 26, 57],
    				["2014-10-06 01:54", 4, 17],
    				["2014-10-03 23:34", 26, 59],
    				["2014-10-07 12:53", 19, 43],
    				["2014-10-02 16:50", 20, 47],
    				["2014-10-01 15:55", 5, 19],
    				["2014-10-05 05:52", 15, 2],
    				["2014-10-03 07:28", 13, 66],
    				["2014-10-02 11:07", 18, 33],
    				["2014-10-06 01:10", 6, 76],
    				["2014-10-06 09:08", 11, 72],
    				["2014-10-03 15:08", 25, 88],
    				["2014-10-01 19:03", 9, 97],
    				["2014-10-05 06:29", 22, 10],
    				["2014-10-06 22:01", 10, 63],
    				["2014-10-05 16:11", 26, 55],
    				["2014-10-01 07:18", 9, 4],
    				["2014-10-06 00:14", 18, 73],
    				["2014-10-05 17:36", 9, 43],
    				["2014-10-05 16:54", 25, 3],
    				["2014-10-06 02:29", 0, 87],
    				["2014-10-07 01:28", 25, 60],
    				["2014-10-02 06:30", 7, 3],
    				["2014-10-01 00:42", 26, 50],
    				["2014-10-04 00:05", 12, 60],
    				["2014-10-02 07:59", 19, 11],
    				["2014-10-04 06:29", 2, 81],
    				["2014-10-01 04:17", 2, 44],
    				["2014-10-02 04:20", 29, 60],
    				["2014-10-05 23:57", 8, 25],
    				["2014-10-06 13:55", 6, 42],
    				["2014-10-04 06:52", 9, 14],
    				["2014-10-02 17:59", 17, 97],
    				["2014-10-05 17:46", 17, 44],
    				["2014-10-05 08:01", 5, 38],
    				["2014-10-02 04:12", 26, 27],
    				["2014-10-03 14:47", 7, 41],
    				["2014-10-02 18:54", 15, 27],
    				["2014-10-02 01:37", 19, 35],
    				["2014-10-05 05:01", 12, 28],
    				["2014-10-06 20:51", 29, 94],
    				["2014-10-05 17:35", 12, 1],
    				["2014-10-01 07:31", 29, 7],
    				["2014-10-06 05:04", 5, 40],
    				["2014-10-05 10:14", 6, 92],
    				["2014-10-01 23:56", 29, 34],
    				["2014-10-04 10:55", 24, 52],
    				["2014-10-02 10:53", 21, 50],
    				["2014-10-06 19:21", 14, 24],
    				["2014-10-01 11:06", 6, 71],
    				["2014-10-07 17:10", 1, 15],
    				["2014-10-06 05:11", 19, 52],
    				["2014-10-07 05:50", 7, 52],
    				["2014-10-02 05:08", 22, 64],
    				["2014-10-02 07:23", 11, 81],
    				["2014-10-01 18:59", 24, 91],
    				["2014-10-05 15:24", 11, 91],
    				["2014-10-01 16:47", 18, 18],
    				["2014-10-05 11:09", 1, 66],
    				["2014-10-01 13:26", 20, 90],
    				["2014-10-05 23:23", 25, 38],
    				["2014-10-02 17:48", 18, 93],
    				["2014-10-07 02:46", 24, 94],
    				["2014-10-07 11:03", 6, 69],
    				["2014-10-05 19:29", 13, 79],
    				["2014-10-02 10:17", 28, 26],
    				["2014-10-02 10:14", 21, 80],
    				["2014-10-05 04:20", 7, 84],
    				["2014-10-06 05:25", 5, 31],
    				["2014-10-01 13:02", 20, 57],
    				["2014-10-02 08:52", 19, 58],
    				["2014-10-02 14:46", 13, 81],
    				["2014-10-07 02:31", 24, 53],
    				["2014-10-07 22:07", 1, 77],
    				["2014-10-03 07:26", 22, 17],
    				["2014-10-01 23:24", 12, 10],
    				["2014-10-01 05:30", 9, 78],
    				["2014-10-02 12:21", 11, 93],
    				["2014-10-05 06:34", 21, 69],
    				["2014-10-06 19:49", 15, 98],
    				["2014-10-04 07:02", 15, 54],
    				["2014-10-03 03:01", 5, 14],
    				["2014-10-05 05:13", 13, 83],
    				["2014-10-02 20:14", 19, 69],
    				["2014-10-03 19:12", 11, 73],
    				["2014-10-03 07:22", 11, 71],
    				["2014-10-05 01:12", 5, 44],
    				["2014-10-01 17:44", 26, 71],
    				["2014-10-02 06:46", 16, 69],
    				["2014-10-02 05:50", 26, 51],
    				["2014-10-05 21:31", 3, 67],
    				["2014-10-07 04:32", 24, 78],
    				["2014-10-07 04:12", 17, 19],
    				["2014-10-06 02:21", 28, 80],
    				["2014-10-01 21:05", 18, 9],
    				["2014-10-03 20:17", 5, 11],
    				["2014-10-05 21:11", 21, 75],
    				["2014-10-01 11:34", 5, 31],
    				["2014-10-06 13:16", 8, 45],
    				["2014-10-07 20:28", 14, 74],
    				["2014-10-07 07:46", 20, 58],
    				["2014-10-05 04:12", 14, 99],
    				["2014-10-04 04:50", 16, 52],
    				["2014-10-02 12:29", 20, 70],
    				["2014-10-05 13:31", 20, 86],
    				["2014-10-05 23:41", 22, 27],
    				["2014-10-06 16:45", 7, 57],
    				["2014-10-07 12:39", 6, 53],
    				["2014-10-04 18:48", 19, 42],
    				["2014-10-04 03:14", 7, 59],
    				["2014-10-03 13:23", 2, 39],
    				["2014-10-04 02:32", 12, 49],
    				["2014-10-03 02:10", 0, 44],
    				["2014-10-04 01:51", 4, 59],
    				["2014-10-04 03:13", 11, 45],
    				["2014-10-03 13:08", 20, 88],
    				["2014-10-03 00:36", 20, 81],
    				["2014-10-06 03:37", 1, 61],
    				["2014-10-03 10:14", 19, 11],
    				["2014-10-07 20:07", 26, 97],
    				["2014-10-04 16:00", 29, 52],
    				["2014-10-06 17:05", 20, 61],
    				["2014-10-01 00:37", 3, 93],
    				["2014-10-03 20:44", 15, 8],
    				["2014-10-01 06:13", 14, 65],
    				["2014-10-05 19:34", 18, 32],
    				["2014-10-06 16:07", 12, 11],
    				["2014-10-05 01:44", 12, 91],
    				["2014-10-01 04:06", 14, 19],
    				["2014-10-01 00:03", 22, 17],
    				["2014-10-04 20:29", 27, 29],
    				["2014-10-06 18:31", 9, 23],
    				["2014-10-02 04:10", 17, 79],
    				["2014-10-05 20:25", 16, 13],
    				["2014-10-06 19:23", 0, 2],
    				["2014-10-04 16:53", 9, 91],
    				["2014-10-05 11:04", 26, 78],
    				["2014-10-01 15:59", 8, 69],
    				["2014-10-07 20:19", 4, 64],
    				["2014-10-03 17:46", 2, 30],
    				["2014-10-01 05:52", 17, 51],
    				["2014-10-07 08:30", 29, 17],
    				["2014-10-02 06:25", 13, 79],
    				["2014-10-06 02:18", 3, 31],
    				["2014-10-03 04:04", 11, 95],
    				["2014-10-04 02:39", 27, 37],
    				["2014-10-06 14:09", 23, 83],
    				["2014-10-03 21:26", 1, 45],
    				["2014-10-02 10:18", 20, 78],
    				["2014-10-07 06:43", 24, 11],
    				["2014-10-05 23:21", 2, 94],
    				["2014-10-02 06:34", 25, 84],
    				["2014-10-01 12:14", 14, 75],
    				["2014-10-05 15:59", 18, 24],
    				["2014-10-07 05:16", 27, 9],
    				["2014-10-04 01:13", 24, 26],
    				["2014-10-02 13:51", 16, 46],
    				["2014-10-03 21:31", 29, 95],
    				["2014-10-03 09:59", 4, 36],
    				["2014-10-07 14:28", 10, 99],
    				["2014-10-01 07:04", 7, 38],
    				["2014-10-06 07:19", 20, 3],
    				["2014-10-04 23:43", 15, 21],
    				["2014-10-03 14:21", 0, 98],
    				["2014-10-06 17:19", 20, 34],
    				["2014-10-05 18:00", 13, 87],
    				["2014-10-01 16:39", 0, 37],
    				["2014-10-01 18:10", 14, 14],
    				["2014-10-03 18:12", 21, 14],
    				["2014-10-06 01:26", 14, 84],
    				["2014-10-05 03:14", 0, 68],
    				["2014-10-05 10:32", 12, 95],
    				["2014-10-06 04:19", 18, 60],
    				["2014-10-06 15:47", 3, 43],
    				["2014-10-01 04:13", 29, 96],
    				["2014-10-02 22:17", 5, 87],
    				["2014-10-05 20:32", 25, 2],
    				["2014-10-04 05:18", 21, 22],
    				["2014-10-07 20:47", 21, 39],
    				["2014-10-01 14:34", 6, 64],
    				["2014-10-05 22:07", 18, 10],
    				["2014-10-02 03:04", 3, 70],
    				["2014-10-07 22:27", 28, 53],
    				["2014-10-05 20:11", 0, 99],
    				["2014-10-01 21:17", 7, 55],
    				["2014-10-07 02:56", 9, 24],
    				["2014-10-07 00:43", 12, 72],
    				["2014-10-06 07:51", 0, 16],
    				["2014-10-01 21:22", 2, 68],
    				["2014-10-06 06:30", 18, 98],
    				["2014-10-05 10:33", 11, 40],
    				["2014-10-07 22:33", 13, 21],
    				["2014-10-04 03:15", 11, 12],
    				["2014-10-04 10:36", 22, 47],
    				["2014-10-05 03:39", 6, 90],
    				["2014-10-06 14:47", 7, 9],
    				["2014-10-05 03:41", 10, 29],
    				["2014-10-02 05:15", 11, 31],
    				["2014-10-07 02:22", 11, 90],
    				["2014-10-01 16:05", 5, 46],
    				["2014-10-06 15:17", 2, 98],
    				["2014-10-07 15:22", 22, 7],
    				["2014-10-07 14:20", 22, 36],
    				["2014-10-07 19:35", 25, 95],
    				["2014-10-03 03:26", 22, 64],
    				["2014-10-03 21:02", 7, 99],
    				["2014-10-07 11:08", 16, 1],
    				["2014-10-06 22:06", 15, 36],
    				["2014-10-05 10:37", 11, 27],
    				["2014-10-02 19:56", 16, 36],
    				["2014-10-02 00:14", 14, 14],
    				["2014-10-05 22:24", 20, 73],
    				["2014-10-06 22:54", 2, 71],
    				["2014-10-05 18:30", 4, 65],
    				["2014-10-05 18:37", 12, 69],
    				["2014-10-04 04:22", 27, 30],
    				["2014-10-02 23:24", 14, 13],
    				["2014-10-05 10:23", 9, 56],
    				["2014-10-07 07:41", 2, 77],
    				["2014-10-05 03:56", 5, 26],
    				["2014-10-02 00:56", 7, 29],
    				["2014-10-02 07:10", 5, 65],
    				["2014-10-06 10:41", 7, 28],
    				["2014-10-05 16:27", 21, 5],
    				["2014-10-02 04:57", 21, 60],
    				["2014-10-02 22:57", 1, 66],
    				["2014-10-07 11:55", 22, 98],
    				["2014-10-06 05:32", 26, 39],
    				["2014-10-03 08:29", 5, 48],
    				["2014-10-02 10:29", 24, 95],
    				["2014-10-06 23:26", 23, 92],
    				["2014-10-03 13:12", 26, 4],
    				["2014-10-05 01:20", 14, 85],
    				["2014-10-04 12:02", 9, 55],
    				["2014-10-03 15:21", 28, 37],
    				["2014-10-04 00:43", 22, 14],
    				["2014-10-01 01:01", 11, 60],
    				["2014-10-02 11:09", 20, 54],
    				["2014-10-06 09:26", 20, 63],
    				["2014-10-07 21:30", 14, 60],
    				["2014-10-03 08:51", 19, 96],
    				["2014-10-07 15:09", 26, 75],
    				["2014-10-03 01:37", 10, 87],
    				["2014-10-07 01:11", 3, 45],
    				["2014-10-01 04:27", 0, 21],
    				["2014-10-05 23:15", 4, 26],
    				["2014-10-06 11:19", 20, 48],
    				["2014-10-07 16:51", 25, 78],
    				["2014-10-01 04:42", 8, 33],
    				["2014-10-07 10:56", 14, 62],
    				["2014-10-01 21:39", 11, 40],
    				["2014-10-02 10:50", 25, 11],
    				["2014-10-06 17:34", 7, 2],
    				["2014-10-01 13:59", 14, 49],
    				["2014-10-07 14:28", 20, 18],
    				["2014-10-01 09:26", 24, 68],
    				["2014-10-04 15:27", 24, 47],
    				["2014-10-07 21:05", 25, 70],
    				["2014-10-05 12:15", 0, 29],
    				["2014-10-07 18:05", 14, 89],
    				["2014-10-07 17:08", 6, 93],
    				["2014-10-05 02:26", 22, 5],
    				["2014-10-02 20:01", 26, 80],
    				["2014-10-02 20:16", 21, 26],
    				["2014-10-07 14:12", 24, 54],
    				["2014-10-03 14:49", 20, 58],
    				["2014-10-07 21:10", 19, 37],
    				["2014-10-04 13:01", 7, 20],
    				["2014-10-02 23:04", 16, 47],
    				["2014-10-03 12:03", 17, 34],
    				["2014-10-03 03:39", 23, 66],
    				["2014-10-06 14:48", 23, 11],
    				["2014-10-03 07:17", 27, 19],
    				["2014-10-07 12:11", 11, 56],
    				["2014-10-05 13:19", 5, 66],
    				["2014-10-02 18:51", 24, 60],
    				["2014-10-07 19:41", 26, 42],
    				["2014-10-01 06:25", 4, 43],
    				["2014-10-03 19:47", 3, 46],
    				["2014-10-02 02:37", 18, 72],
    				["2014-10-05 02:17", 1, 36],
    				["2014-10-04 21:43", 1, 86],
    				["2014-10-05 08:40", 22, 3],
    				["2014-10-06 20:46", 28, 2],
    				["2014-10-04 03:00", 16, 37],
    				["2014-10-03 01:25", 13, 91],
    				["2014-10-04 17:07", 20, 17],
    				["2014-10-03 02:17", 4, 11],
    				["2014-10-05 09:11", 5, 15],
    				["2014-10-03 10:55", 11, 27],
    				["2014-10-07 20:34", 7, 57],
    				["2014-10-03 10:24", 20, 64],
    				["2014-10-05 16:12", 5, 41],
    				["2014-10-04 16:16", 19, 35],
    				["2014-10-04 19:07", 29, 41],
    				["2014-10-05 06:11", 16, 96],
    				["2014-10-05 13:51", 29, 95],
    				["2014-10-01 00:09", 23, 41],
    				["2014-10-05 13:36", 13, 13],
    				["2014-10-02 15:09", 6, 57],
    				["2014-10-04 12:00", 5, 35],
    				["2014-10-03 10:26", 12, 91],
    				["2014-10-03 22:44", 19, 17],
    				["2014-10-01 08:33", 0, 55],
    				["2014-10-01 00:30", 23, 39],
    				["2014-10-01 17:44", 6, 92],
    				["2014-10-02 05:12", 23, 59],
    				["2014-10-06 05:38", 7, 93],
    				["2014-10-02 09:52", 0, 7],
    				["2014-10-06 02:52", 23, 44],
    				["2014-10-05 02:55", 0, 19],
    				["2014-10-04 20:34", 9, 16],
    				["2014-10-01 08:14", 25, 83],
    				["2014-10-03 23:52", 26, 52],
    				["2014-10-05 06:34", 18, 65],
    				["2014-10-07 04:40", 0, 5],
    				["2014-10-07 16:45", 5, 95],
    				["2014-10-07 11:59", 25, 4],
    				["2014-10-04 21:10", 1, 33],
    				["2014-10-06 19:06", 18, 74],
    				["2014-10-01 16:11", 24, 47],
    				["2014-10-03 01:23", 8, 49],
    				["2014-10-01 10:42", 28, 25],
    				["2014-10-01 18:30", 2, 68],
    				["2014-10-03 13:31", 1, 38],
    				["2014-10-04 08:03", 12, 91],
    				["2014-10-03 13:53", 14, 71],
    				["2014-10-07 16:00", 27, 0],
    				["2014-10-02 11:16", 11, 23],
    				["2014-10-05 07:07", 7, 7],
    				["2014-10-02 20:58", 17, 95],
    				["2014-10-04 03:25", 16, 47],
    				["2014-10-07 17:46", 24, 98],
    				["2014-10-07 10:40", 12, 2],
    				["2014-10-05 18:18", 6, 57],
    				["2014-10-03 23:22", 5, 24],
    				["2014-10-03 18:56", 15, 99],
    				["2014-10-03 04:09", 11, 97],
    				["2014-10-03 12:36", 23, 73],
    				["2014-10-06 11:57", 3, 33],
    				["2014-10-04 04:10", 16, 85],
    				["2014-10-02 04:29", 17, 97],
    				["2014-10-03 23:23", 6, 1],
    				["2014-10-05 06:35", 24, 51],
    				["2014-10-05 19:25", 4, 4],
    				["2014-10-01 06:17", 25, 76],
    				["2014-10-06 10:44", 27, 30],
    				["2014-10-02 23:08", 24, 19],
    				["2014-10-01 15:21", 26, 0],
    				["2014-10-03 23:07", 27, 86],
    				["2014-10-03 06:25", 6, 2],
    				["2014-10-06 11:19", 3, 8],
    				["2014-10-07 09:41", 26, 50],
    				["2014-10-04 14:35", 0, 5],
    				["2014-10-06 12:33", 12, 61],
    				["2014-10-03 00:23", 7, 31],
    				["2014-10-03 15:52", 28, 5],
    				["2014-10-02 20:03", 23, 34],
    				["2014-10-06 16:35", 1, 65],
    				["2014-10-01 14:50", 11, 12],
    				["2014-10-03 07:06", 24, 19],
    				["2014-10-07 11:26", 8, 67],
    				["2014-10-02 13:54", 13, 33],
    				["2014-10-03 10:07", 24, 27],
    				["2014-10-02 05:13", 12, 36],
    				["2014-10-02 21:09", 16, 94],
    				["2014-10-01 18:09", 23, 10],
    				["2014-10-02 04:17", 20, 11],
    				["2014-10-02 21:10", 7, 45],
    				["2014-10-01 10:59", 8, 7],
    				["2014-10-03 08:36", 15, 39],
    				["2014-10-07 13:08", 11, 18],
    				["2014-10-05 07:27", 0, 58],
    				["2014-10-02 11:42", 9, 37],
    				["2014-10-03 12:06", 13, 3],
    				["2014-10-03 15:24", 22, 54],
    				["2014-10-05 06:15", 23, 50],
    				["2014-10-02 19:00", 12, 94],
    				["2014-10-07 10:48", 15, 90],
    				["2014-10-02 01:30", 21, 82],
    				["2014-10-06 00:39", 20, 28],
    				["2014-10-06 14:36", 11, 50],
    				["2014-10-03 05:25", 14, 52],
    				["2014-10-05 19:27", 19, 73],
    				["2014-10-05 15:10", 26, 60],
    				["2014-10-03 07:02", 22, 61],
    				["2014-10-01 13:11", 14, 8],
    				["2014-10-04 04:20", 27, 66],
    				["2014-10-03 20:20", 0, 77],
    				["2014-10-03 23:50", 23, 15],
    				["2014-10-06 22:39", 21, 33],
    				["2014-10-06 08:02", 29, 88],
    				["2014-10-05 19:46", 14, 98],
    				["2014-10-07 22:16", 28, 73],
    				["2014-10-02 06:55", 12, 88],
    				["2014-10-02 15:34", 4, 5],
    				["2014-10-03 04:40", 16, 69],
    				["2014-10-03 21:13", 15, 84],
    				["2014-10-02 06:39", 27, 50],
    				["2014-10-06 20:31", 6, 74],
    				["2014-10-03 09:21", 28, 39],
    				["2014-10-04 09:41", 22, 32],
    				["2014-10-01 23:16", 23, 55],
    				["2014-10-06 07:53", 21, 2],
    				["2014-10-06 05:57", 27, 80],
    				["2014-10-06 04:03", 20, 23],
    				["2014-10-06 13:02", 11, 42],
    				["2014-10-03 09:44", 18, 49],
    				["2014-10-04 23:03", 4, 69],
    				["2014-10-03 12:21", 27, 20],
    				["2014-10-06 15:36", 5, 31],
    				["2014-10-06 05:28", 30, 43],
    				["2014-10-04 20:28", 13, 0],
    				["2014-10-02 22:46", 17, 88],
    				["2014-10-03 11:27", 6, 80],
    				["2014-10-03 21:52", 17, 62],
    				["2014-10-07 01:18", 25, 79],
    				["2014-10-06 00:26", 3, 40],
    				["2014-10-02 14:14", 8, 89],
    				["2014-10-05 18:51", 16, 41],
    				["2014-10-05 22:01", 30, 66],
    				["2014-10-07 00:56", 13, 43],
    				["2014-10-01 06:54", 6, 35],
    				["2014-10-06 05:36", 8, 6],
    				["2014-10-07 08:52", 11, 94],
    				["2014-10-03 12:57", 22, 94],
    				["2014-10-01 08:12", 22, 52],
    				["2014-10-05 03:08", 7, 45],
    				["2014-10-01 09:19", 20, 59],
    				["2014-10-07 10:52", 8, 56],
    				["2014-10-02 01:22", 9, 100],
    				["2014-10-03 21:47", 10, 79],
    				["2014-10-07 03:26", 26, 12],
    				["2014-10-04 16:42", 29, 30],
    				["2014-10-02 21:55", 20, 63],
    				["2014-10-07 07:46", 1, 45],
    				["2014-10-03 23:41", 23, 44],
    				["2014-10-03 15:03", 6, 15],
    				["2014-10-07 13:42", 12, 87],
    				["2014-10-05 02:46", 12, 53],
    				["2014-10-01 14:52", 25, 11],
    				["2014-10-02 23:00", 11, 27],
    				["2014-10-03 01:16", 24, 59],
    				["2014-10-05 04:57", 28, 57],
    				["2014-10-07 17:28", 6, 26],
    				["2014-10-01 01:49", 2, 52],
    				["2014-10-07 20:03", 23, 61],
    				["2014-10-03 13:08", 2, 49],
    				["2014-10-06 00:22", 29, 34],
    				["2014-10-05 22:12", 24, 10],
    				["2014-10-05 13:42", 17, 91],
    				["2014-10-06 10:56", 4, 83],
    				["2014-10-04 19:27", 18, 46],
    				["2014-10-05 15:59", 3, 79],
    				["2014-10-04 10:55", 2, 47],
    				["2014-10-01 07:03", 5, 15],
    				["2014-10-06 09:18", 29, 78],
    				["2014-10-04 07:47", 17, 9],
    				["2014-10-02 12:32", 24, 84],
    				["2014-10-03 09:16", 23, 73],
    				["2014-10-04 17:01", 28, 47],
    				["2014-10-06 19:38", 14, 60],
    				["2014-10-04 16:55", 12, 45],
    				["2014-10-05 01:34", 1, 53],
    				["2014-10-04 07:53", 7, 33],
    				["2014-10-03 21:20", 2, 8],
    				["2014-10-04 18:25", 3, 47],
    				["2014-10-04 02:53", 23, 22],
    				["2014-10-03 00:45", 4, 83],
    				["2014-10-04 04:43", 14, 75],
    				["2014-10-07 05:18", 13, 42],
    				["2014-10-02 02:39", 0, 43],
    				["2014-10-06 16:30", 1, 54],
    				["2014-10-01 21:46", 7, 55],
    				["2014-10-05 19:29", 13, 56],
    				["2014-10-07 08:52", 7, 3],
    				["2014-10-02 05:13", 4, 50],
    				["2014-10-02 05:30", 11, 67],
    				["2014-10-01 22:53", 5, 80],
    				["2014-10-07 06:48", 28, 65],
    				["2014-10-07 17:06", 8, 61],
    				["2014-10-07 06:22", 24, 0],
    				["2014-10-06 14:42", 3, 72],
    				["2014-10-06 04:44", 9, 4],
    				["2014-10-07 08:15", 13, 68],
    				["2014-10-02 16:40", 12, 47],
    				["2014-10-01 19:59", 2, 47],
    				["2014-10-03 14:35", 10, 19],
    				["2014-10-05 19:16", 27, 100],
    				["2014-10-03 04:03", 20, 25],
    				["2014-10-01 14:26", 21, 81],
    				["2014-10-03 16:33", 26, 9],
    				["2014-10-05 08:25", 26, 29],
    				["2014-10-06 12:56", 10, 28],
    				["2014-10-07 06:16", 10, 85],
    				["2014-10-03 04:36", 20, 80],
    				["2014-10-01 13:22", 6, 6],
    				["2014-10-03 10:13", 20, 51],
    				["2014-10-01 12:46", 12, 52],
    				["2014-10-04 09:27", 13, 69],
    				["2014-10-07 05:08", 13, 97],
    				["2014-10-03 01:53", 11, 1],
    				["2014-10-07 16:33", 26, 41],
    				["2014-10-05 16:59", 16, 50],
    				["2014-10-01 22:34", 28, 58],
    				["2014-10-07 17:37", 27, 38],
    				["2014-10-03 19:38", 7, 56],
    				["2014-10-02 15:07", 22, 37],
    				["2014-10-05 03:05", 7, 37],
    				["2014-10-02 21:02", 23, 62],
    				["2014-10-01 06:01", 11, 92],
    				["2014-10-01 10:28", 14, 96],
    				["2014-10-01 13:53", 22, 11],
    				["2014-10-03 09:19", 8, 34],
    				["2014-10-03 07:56", 7, 3],
    				["2014-10-04 11:05", 11, 54],
    				["2014-10-04 01:51", 27, 93],
    				["2014-10-05 15:31", 0, 78],
    				["2014-10-01 07:05", 26, 32],
    				["2014-10-07 21:13", 21, 78],
    				["2014-10-04 04:30", 5, 49],
    				["2014-10-02 20:55", 0, 21],
    				["2014-10-06 09:40", 25, 71],
    				["2014-10-03 17:43", 2, 31],
    				["2014-10-04 04:05", 19, 41],
    				["2014-10-04 15:00", 26, 28],
    				["2014-10-07 07:52", 11, 99],
    				["2014-10-05 17:30", 24, 1],
    				["2014-10-03 01:22", 27, 90],
    				["2014-10-04 07:57", 24, 64],
    				["2014-10-05 14:22", 23, 37],
    				["2014-10-01 01:27", 17, 43],
    				["2014-10-06 07:39", 1, 1],
    				["2014-10-05 13:19", 1, 74],
    				["2014-10-02 22:26", 2, 77],
    				["2014-10-02 16:38", 30, 71],
    				["2014-10-07 22:01", 15, 42],
    				["2014-10-06 18:12", 23, 66],
    				["2014-10-06 11:03", 5, 57],
    				["2014-10-03 11:20", 13, 50],
    				["2014-10-04 10:11", 27, 79],
    				["2014-10-05 11:24", 21, 34],
    				["2014-10-03 08:25", 14, 0],
    				["2014-10-04 06:31", 23, 4],
    				["2014-10-05 20:15", 16, 89],
    				["2014-10-05 02:04", 19, 96],
    				["2014-10-04 18:26", 0, 25],
    				["2014-10-06 21:32", 2, 96],
    				["2014-10-05 09:51", 22, 58],
    				["2014-10-03 05:17", 12, 74],
    				["2014-10-03 10:31", 5, 55],
    				["2014-10-05 08:35", 8, 40],
    				["2014-10-02 13:26", 16, 48],
    				["2014-10-03 06:02", 23, 18],
    				["2014-10-02 01:10", 29, 23],
    				["2014-10-06 18:37", 14, 50],
    				["2014-10-02 01:58", 11, 84],
    				["2014-10-04 03:56", 2, 31],
    				["2014-10-04 23:37", 8, 43],
    				["2014-10-07 09:01", 30, 64],
    				["2014-10-07 11:53", 27, 47],
    				["2014-10-01 16:42", 27, 54],
    				["2014-10-03 00:19", 20, 45],
    				["2014-10-07 16:12", 2, 15],
    				["2014-10-06 02:24", 25, 0],
    				["2014-10-04 07:57", 15, 40],
    				["2014-10-05 08:06", 27, 52],
    				["2014-10-04 19:35", 6, 20],
    				["2014-10-01 07:27", 7, 86],
    				["2014-10-07 18:33", 7, 65],
    				["2014-10-02 19:05", 3, 39],
    				["2014-10-04 09:29", 21, 78],
    				["2014-10-07 01:03", 3, 20],
    				["2014-10-03 04:42", 8, 30],
    				["2014-10-04 18:16", 19, 66],
    				["2014-10-04 19:50", 10, 80],
    				["2014-10-02 17:21", 17, 5],
    				["2014-10-01 05:21", 18, 17],
    				["2014-10-01 09:58", 4, 31],
    				["2014-10-06 01:13", 8, 8],
    				["2014-10-03 00:47", 13, 60],
    				["2014-10-05 23:55", 23, 2],
    				["2014-10-01 07:57", 19, 87],
    				["2014-10-06 09:08", 11, 96],
    				["2014-10-05 23:37", 28, 68],
    				["2014-10-03 21:04", 9, 71],
    				["2014-10-01 06:26", 14, 97],
    				["2014-10-02 17:43", 23, 27],
    				["2014-10-07 01:49", 23, 65],
    				["2014-10-05 20:34", 22, 11],
    				["2014-10-06 10:44", 7, 66],
    				["2014-10-06 03:52", 2, 71],
    				["2014-10-06 12:45", 26, 12],
    				["2014-10-01 17:40", 14, 30],
    				["2014-10-07 16:37", 1, 100],
    				["2014-10-05 06:43", 7, 80],
    				["2014-10-04 11:44", 26, 88],
    				["2014-10-07 05:29", 0, 13],
    				["2014-10-04 15:35", 14, 55]
    			],
    			"name": "series1",
    			"type": "scatter",
    			"tooltip": {
    				"formatter": "function(params){                    var date = new Date(params.value[0]);                    return params.seriesName                            + ' （'                           + date.getFullYear() + '-'                           + (date.getMonth() + 1) + '-'                           + date.getDate() + ' '                           + date.getHours() + ':'                           + date.getMinutes()                           +  '）<br/>'                           + params.value[1] + ', '                            + params.value[2];                }"
    			},
    			"symbolSize": "function (value){                return Math.round(value[2]/10);            }"
    		}]
    	}
    	
    myChart.setOption(option);
    </script>
</body>
</html>