/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgRecv;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.dbaccess.DmdbRwAutoDistribute;
import dm.jdbc.dbaccess.Request_Response;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.jdbc.log.ILogger;
import dm.jdbc.log.LogFactory;
import java.io.IOException;
import java.sql.SQLException;

public class DmdbRwUserDistribute {
    static ILogger LOG = LogFactory.getLog(DmdbRwAutoDistribute.class);

    public static DmMsgRecv accessToServer(DmMsgSend msg, DmdbConnection_bs conn, DmdbStatement_bs stmt) throws SQLException {
        short cmdType = msg.req_get_cmd();
        DmMsgRecv recvMsg = null;
        try {
            switch (cmdType) {
                case 3: {
                    DmMsgRecv recvMsgS;
                    recvMsg = DmdbRwUserDistribute.sendMsgToPrimary(msg, conn, stmt);
                    if (!conn.getDbAccess().isStandbyAlive() || (recvMsgS = DmdbRwUserDistribute.sendMsgToStandby(msg, conn, stmt)) == null) break;
                    stmt.setHandleForStandby(Request_Response.resp_stmt_alloc(recvMsgS, stmt));
                    break;
                }
                case 4: 
                case 8: 
                case 9: 
                case 17: 
                case 27: 
                case 52: {
                    recvMsg = DmdbRwUserDistribute.sendMsgToPrimary(msg, conn, stmt);
                    if (!conn.getDbAccess().isStandbyAlive()) break;
                    DmdbRwUserDistribute.sendMsgToStandby(msg, conn, stmt);
                    break;
                }
                case 5: 
                case 6: 
                case 13: 
                case 91: {
                    recvMsg = DmdbRwUserDistribute.sendMsgToServer(msg, conn, stmt, DmdbRwUserDistribute.rwDistribute(conn, stmt.getOriginalSql()));
                    break;
                }
                default: {
                    recvMsg = DmdbRwUserDistribute.sendMsgToServer(msg, conn, stmt, DmdbRwUserDistribute.rwDistribute(conn, null));
                }
            }
            DmdbRwUserDistribute.afterAccessToServer(msg, stmt, recvMsg);
            short retType = recvMsg.res_execute_get_ret_type();
            switch (retType) {
                case 147: 
                case 148: 
                case 153: 
                case 165: 
                case 166: {
                    boolean fromStandby = recvMsg.getFromStandby();
                    if (fromStandby) {
                        DmdbRwUserDistribute.sendMsgToPrimary(msg, conn, stmt);
                        break;
                    }
                    if (conn.getDbAccess().isStandbyAlive()) {
                        DmdbRwUserDistribute.sendMsgToStandby(msg, conn, stmt);
                    }
                    break;
                }
            }
        }
        catch (IOException iOException) {
            conn.setClosed(true);
            DBError.throwSQLException(6001);
        }
        return recvMsg;
    }

    public static DmMsgRecv accessToServer(DmMsgSend msg, DmdbConnection_bs conn, DmdbStatement_bs stmt, int rwDestType) throws SQLException {
        DmMsgRecv recvMsg = null;
        try {
            recvMsg = rwDestType == 1 ? DmdbRwUserDistribute.sendMsgToPrimary(msg, conn, stmt) : DmdbRwUserDistribute.sendMsgToStandby(msg, conn, stmt);
            DmdbRwUserDistribute.afterAccessToServer(msg, stmt, recvMsg);
        }
        catch (IOException iOException) {
            conn.setClosed(true);
            DBError.throwSQLException(6001);
        }
        return recvMsg;
    }

    private static void afterAccessToServer(DmMsgSend msg, DmdbStatement_bs stmt, DmMsgRecv recvMsg) {
        if (stmt == null || recvMsg == null) {
            return;
        }
        short cmdType = msg.req_get_cmd();
        switch (cmdType) {
            case 5: {
                if (msg.req_prepare_get_exec_direct() == 1) {
                    stmt.setExecFromStandby(recvMsg.getFromStandby());
                    break;
                }
                stmt.setPrepareFromStandby(recvMsg.getFromStandby());
                break;
            }
            case 6: 
            case 13: 
            case 91: {
                stmt.setExecFromStandby(recvMsg.getFromStandby());
                break;
            }
        }
    }

    private static int rwDistribute(DmdbConnection_bs conn, String sql) {
        if (!conn.getRwSeparate()) {
            return 1;
        }
        if (conn.isReadOnly()) {
            return 0;
        }
        return 1;
    }

    private static final DmMsgRecv sendMsgToServer(DmMsgSend sendMsg, DmdbConnection_bs conn, DmdbStatement_bs stmt, int rwDestType) throws SQLException, IOException {
        DmMsgRecv recvMsg = null;
        if (rwDestType == 1) {
            recvMsg = DmdbRwUserDistribute.sendMsgToPrimary(sendMsg, conn, stmt);
        } else {
            try {
                recvMsg = DmdbRwUserDistribute.sendMsgToStandby(sendMsg, conn, stmt);
                Request_Response.resp_checkErr(recvMsg, conn);
            }
            catch (SQLException sqle) {
                throw sqle;
            }
            catch (IOException ioe) {
                throw ioe;
            }
        }
        return recvMsg;
    }

    private static final DmMsgRecv sendMsgToPrimary(DmMsgSend sendMsg, DmdbConnection_bs conn, DmdbStatement_bs stmt) throws SQLException, IOException {
        short cmdType = sendMsg.req_get_cmd();
        DmMsgRecv retMsg = null;
        IOException ioEx = null;
        try {
            sendMsg.req_set_stmtid(stmt == null ? 0 : stmt.getHandle());
            retMsg = conn.getDbAccess().accessPrimary(sendMsg, conn.getComprMsg());
        }
        catch (IOException e) {
            ioEx = e;
        }
        switch (cmdType) {
            case 1: 
            case 200: {
                break;
            }
            default: {
                if (!conn.needSwitchForConnError() || ioEx == null && (!conn.getRwSeparate() || !DmdbRwUserDistribute.primaryStandbyChanged(conn, retMsg))) break;
                LOG.debug((Object)conn, "DmdbCSI.sendMsgToPrimary()", "doswitch because of " + (ioEx != null ? "IOException" : "primaryStandbyChanged"));
                conn.reset();
                DBError.throwSQLException(20000);
            }
        }
        if (ioEx != null) {
            throw ioEx;
        }
        return retMsg;
    }

    private static final DmMsgRecv sendMsgToStandby(DmMsgSend sendMsg, DmdbConnection_bs conn, DmdbStatement_bs stmt) throws SQLException, IOException {
        DmMsgRecv recv = null;
        try {
            sendMsg.req_set_stmtid(stmt == null ? 0 : stmt.getHandleForStandby());
            recv = conn.getDbAccess().accessStandby(sendMsg, conn.getComprMsg());
        }
        catch (IOException e) {
            LOG.debug((Object)conn, "DmdbCSI.sendMsgToStandby()", "standby IOException:[" + conn.getStandbyHost() + ":" + conn.getStandbyPort() + "]");
            throw e;
        }
        return recv;
    }

    private static final boolean primaryStandbyChanged(DmdbConnection_bs conn, DmMsgRecv recvMsg) {
        short svrMode = Request_Response.resp_svr_mode(recvMsg);
        return svrMode == 2 && conn.getSvrMode() == 1 || svrMode == 1 && conn.getSvrMode() == 2;
    }
}

