/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess.ssl;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DbAccessPure;
import dm.jdbc.dbaccess.ssl.SSLHandshakeCompletedListener;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.Properties;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class MakeSSLSocket {
    private volatile boolean handshakeCompleted = false;

    public void convert(DbAccessPure dbPureAccess, Properties prop, boolean useSSLSocket) throws IOException, SQLException {
        SSLSocketFactory factory = null;
        try {
            Class<?> factoryClass = Class.forName("dm.jdbc.dbaccess.ssl.FullDuplexValidatingFactory");
            Constructor<?> ctor = factoryClass.getConstructor(Properties.class);
            factory = (SSLSocketFactory)ctor.newInstance(prop);
        }
        catch (Exception exception) {
            DBError.throwSQLException(20002);
        }
        SSLSocket sslSocket = (SSLSocket)factory.createSocket(dbPureAccess.getSocket(), dbPureAccess.getHostName(), dbPureAccess.getPortNumber(), true);
        sslSocket.setSoTimeout(dbPureAccess.getSocket().getSoTimeout());
        String[] enableProtocols = new String[]{"TLSv1"};
        sslSocket.setEnabledProtocols(enableProtocols);
        sslSocket.addHandshakeCompletedListener(new SSLHandshakeCompletedListener(this));
        try {
            sslSocket.startHandshake();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        this.sharkehand(dbPureAccess, sslSocket, useSSLSocket);
    }

    private void sharkehand(DbAccessPure dbPureAccess, SSLSocket sslSocket, boolean useSSLSocket) throws IOException, SQLException {
        long timeIsOver = System.currentTimeMillis() + 5000L;
        while (!this.handshakeCompleted && timeIsOver - System.currentTimeMillis() > 0L) {
        }
        if (this.handshakeCompleted) {
            if (useSSLSocket) {
                dbPureAccess.changeSocket(sslSocket);
            } else {
                dbPureAccess.setSslSocket(sslSocket);
            }
        } else {
            DBError.throwSQLException(20002);
        }
    }

    public void setHandshakeCompleted(boolean completed) {
        this.handshakeCompleted = completed;
    }
}

