/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbDataTypeMetaData;
import dm.jdbc.driver.DmdbInfo;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbType;
import java.sql.ParameterMetaData;
import java.sql.SQLException;

public class DmdbParameterMetaData_bs
extends DmdbDataTypeMetaData
implements ParameterMetaData {
    DmdbInfo m_dbInfo = null;
    private boolean comOra = false;
    int parameterNoNulls = 0;
    int parameterNullable = 1;
    int parameterNullableUnknown = 2;
    int parameterModeUnknown = 0;
    int parameterModeIn = 1;
    int parameterModeInOut = 2;
    int parameterModeOut = 4;

    DmdbParameterMetaData_bs(DmdbPreparedStatement_bs pstmt, boolean comOra) {
        this.m_dbInfo = pstmt.getDmdbInfo();
        this.comOra = comOra;
    }

    public int getParameterCount() throws SQLException {
        return this.m_dbInfo.getParameterCount();
    }

    public int isNullable(int param) throws SQLException {
        this.checkIndex(param);
        boolean nullable = this.m_dbInfo.getParamsInfo()[param - 1].getNullable();
        return nullable ? this.parameterNullable : this.parameterNoNulls;
    }

    public boolean isSigned(int param) throws SQLException {
        int jsqlType = this.getParameterType(param);
        return this.signed(jsqlType);
    }

    public int getPrecision(int param) throws SQLException {
        this.checkIndex(param);
        return this.m_dbInfo.getParamsInfo()[param - 1].getPrec();
    }

    public int getScale(int param) throws SQLException {
        this.checkIndex(param);
        return this.m_dbInfo.getParamsInfo()[param - 1].getScale();
    }

    public int getDType(int param) throws SQLException {
        this.checkIndex(param);
        int dType = this.m_dbInfo.getParamsInfo()[param - 1].getDType();
        if (DmdbType.isComplexType(dType, this.m_dbInfo.getParamsInfo()[param - 1].getScale())) {
            dType = this.m_dbInfo.getParamsInfo()[param - 1].getTypeDescriptor().getDType();
        }
        return dType;
    }

    public int getParameterType(int param) throws SQLException {
        this.checkIndex(param);
        int dType = this.getDType(param);
        String typeName = this.m_dbInfo.getParamsInfo()[param - 1].getTypeName();
        if (DmdbType.isComplexType(this.m_dbInfo.getParamsInfo()[param - 1].getDType(), this.m_dbInfo.getParamsInfo()[param - 1].getScale())) {
            typeName = this.m_dbInfo.getParamsInfo()[param - 1].getTypeDescriptor().getFulName();
        }
        int type = DmdbType.dtypeToSqlType(dType, typeName);
        if (this.comOra && DmdbType.isNUMERICtype(type)) {
            return 2;
        }
        return type;
    }

    public String getParameterTypeName(int param) throws SQLException {
        this.checkIndex(param);
        String typeName = this.m_dbInfo.getParamsInfo()[param - 1].getTypeName();
        if (typeName == null || typeName.equals("")) {
            typeName = "VARCHAR";
        }
        return typeName;
    }

    public String getParameterClassName(int param) throws SQLException {
        int dataType = this.getParameterType(param);
        return this.getClassName(dataType, this.getDType(param));
    }

    public int getParameterMode(int param) throws SQLException {
        this.checkIndex(param);
        int jdbcInOutType = 0;
        byte dmInOutType = this.m_dbInfo.getParamsInfo()[param - 1].getIOType();
        switch (dmInOutType) {
            case 0: {
                if (this.m_dbInfo.getRetStmtType() == 157) {
                    jdbcInOutType = 0;
                    break;
                }
                jdbcInOutType = 1;
                break;
            }
            case 1: {
                jdbcInOutType = 4;
                break;
            }
            case 2: {
                jdbcInOutType = 2;
                break;
            }
        }
        return jdbcInOutType;
    }

    void checkIndex(int i) throws SQLException {
        if (i < 1 || i > this.getParameterCount()) {
            DBError.throwSQLException(6032);
        }
    }

    public String getParameterName(int param) throws SQLException {
        this.checkIndex(param);
        return this.m_dbInfo.getParamsInfo()[param - 1].getName();
    }
}

