/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.AbstractProxy;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbResultSetMetaData_bs;
import dm.jdbc.driver.DmdbResultSet_bs;
import dm.jdbc.driver.DmdbRowId;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.stat.SqlStat;
import dm.sql.DmdbIntervalDT;
import dm.sql.DmdbIntervalYM;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class DmdbResultSet
extends AbstractProxy<DmdbResultSet_bs>
implements ResultSet,
Cloneable {
    private DmdbResultSet_bs rRs = null;
    private DmdbStatement curstmt = null;
    private String sql;
    protected int cursorIndex = 0;
    protected long constructNano;
    protected SqlStat sqlStat;
    private int closeCount = 0;
    private long readStringLength = 0L;
    private long readBytesLength = 0L;
    private int openInputStreamCount = 0;
    private int openReaderCount = 0;
    private static AtomicLong index = new AtomicLong(0L);

    DmdbResultSet(DmdbResultSet_bs rs, DmdbStatement stmt) {
        super(rs);
        this.rRs = rs;
        this.curstmt = stmt;
        this.ID = index.incrementAndGet();
    }

    public DmdbResultSet(DmdbResultSet_bs rs) {
        super(rs);
        this.rRs = rs;
        this.ID = index.incrementAndGet();
    }

    public DmdbResultSet_bs getRealRs() {
        return this.rRs;
    }

    @Override
    public boolean next() throws SQLException {
        return this.createChain().ResultSet_next(this);
    }

    @Override
    public void close() throws SQLException {
        this.createChain().ResultSet_close(this);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.createChain().ResultSet_wasNull(this);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getString(this, columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getBoolean(this, columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getByte(this, columnIndex);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getShort(this, columnIndex);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getInt(this, columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getLong(this, columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getFloat(this, columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getDouble(this, columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.createChain().ResultSet_getBigDecimal(this, columnIndex, scale);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getBytes(this, columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getDate(this, columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getTime(this, columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getTimestamp(this, columnIndex);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getAsciiStream(this, columnIndex);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getUnicodeStream(this, columnIndex);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getBinaryStream(this, columnIndex);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getString(this, columnLabel);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getBoolean(this, columnLabel);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getByte(this, columnLabel);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getShort(this, columnLabel);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getInt(this, columnLabel);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getLong(this, columnLabel);
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getFloat(this, columnLabel);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getDouble(this, columnLabel);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.createChain().ResultSet_getBigDecimal(this, columnLabel, scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getBytes(this, columnLabel);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getDate(this, columnLabel);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getTime(this, columnLabel);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getTimestamp(this, columnLabel);
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getAsciiStream(this, columnLabel);
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getUnicodeStream(this, columnLabel);
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getBinaryStream(this, columnLabel);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.createChain().ResultSet_getWarnings(this);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.createChain().ResultSet_clearWarnings(this);
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.createChain().ResultSet_getCursorName(this);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.createChain().ResultSet_getMetaData(this);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getObject(this, columnIndex);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getObject(this, columnLabel);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_findColumn(this, columnLabel);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getCharacterStream(this, columnIndex);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getCharacterStream(this, columnLabel);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getBigDecimal(this, columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getBigDecimal(this, columnLabel);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.createChain().ResultSet_isBeforeFirst(this);
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.createChain().ResultSet_isAfterLast(this);
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.createChain().ResultSet_isFirst(this);
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.createChain().ResultSet_isLast(this);
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.createChain().ResultSet_beforeFirst(this);
    }

    @Override
    public void afterLast() throws SQLException {
        this.createChain().ResultSet_afterLast(this);
    }

    @Override
    public boolean first() throws SQLException {
        return this.createChain().ResultSet_first(this);
    }

    @Override
    public boolean last() throws SQLException {
        return this.createChain().ResultSet_last(this);
    }

    @Override
    public int getRow() throws SQLException {
        return this.createChain().ResultSet_getRow(this);
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        return this.createChain().ResultSet_absolute(this, row);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        return this.createChain().ResultSet_relative(this, rows);
    }

    @Override
    public boolean previous() throws SQLException {
        return this.createChain().ResultSet_previous(this);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.createChain().ResultSet_setFetchDirection(this, direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.createChain().ResultSet_getFetchDirection(this);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.createChain().ResultSet_setFetchSize(this, rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.createChain().ResultSet_getFetchSize(this);
    }

    @Override
    public int getType() throws SQLException {
        return this.createChain().ResultSet_getType(this);
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.createChain().ResultSet_getConcurrency(this);
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.createChain().ResultSet_rowUpdated(this);
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.createChain().ResultSet_rowInserted(this);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.createChain().ResultSet_rowDeleted(this);
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.createChain().ResultSet_updateNull(this, columnIndex);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.createChain().ResultSet_updateBoolean(this, columnIndex, x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.createChain().ResultSet_updateByte(this, columnIndex, x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.createChain().ResultSet_updateShort(this, columnIndex, x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.createChain().ResultSet_updateInt(this, columnIndex, x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.createChain().ResultSet_updateLong(this, columnIndex, x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.createChain().ResultSet_updateFloat(this, columnIndex, x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.createChain().ResultSet_updateDouble(this, columnIndex, x);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.createChain().ResultSet_updateBigDecimal(this, columnIndex, x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.createChain().ResultSet_updateString(this, columnIndex, x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.createChain().ResultSet_updateBytes(this, columnIndex, x);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.createChain().ResultSet_updateDate(this, columnIndex, x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.createChain().ResultSet_updateTime(this, columnIndex, x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.createChain().ResultSet_updateTimestamp(this, columnIndex, x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.createChain().ResultSet_updateAsciiStream(this, columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.createChain().ResultSet_updateBinaryStream(this, columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.createChain().ResultSet_updateCharacterStream(this, columnIndex, x, length);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        this.createChain().ResultSet_updateObject(this, columnIndex, x, scaleOrLength);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.createChain().ResultSet_updateObject(this, columnIndex, x);
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.createChain().ResultSet_updateNull(this, columnLabel);
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.createChain().ResultSet_updateBoolean(this, columnLabel, x);
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.createChain().ResultSet_updateByte(this, columnLabel, x);
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.createChain().ResultSet_updateShort(this, columnLabel, x);
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.createChain().ResultSet_updateInt(this, columnLabel, x);
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.createChain().ResultSet_updateLong(this, columnLabel, x);
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.createChain().ResultSet_updateFloat(this, columnLabel, x);
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.createChain().ResultSet_updateDouble(this, columnLabel, x);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.createChain().ResultSet_updateBigDecimal(this, columnLabel, x);
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.createChain().ResultSet_updateString(this, columnLabel, x);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.createChain().ResultSet_updateBytes(this, columnLabel, x);
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.createChain().ResultSet_updateDate(this, columnLabel, x);
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.createChain().ResultSet_updateTime(this, columnLabel, x);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.createChain().ResultSet_updateTimestamp(this, columnLabel, x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.createChain().ResultSet_updateAsciiStream(this, columnLabel, x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.createChain().ResultSet_updateBinaryStream(this, columnLabel, x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.createChain().ResultSet_updateCharacterStream(this, columnLabel, reader, length);
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.createChain().ResultSet_updateObject(this, columnLabel, x, scaleOrLength);
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.createChain().ResultSet_updateObject(this, columnLabel, x);
    }

    @Override
    public void insertRow() throws SQLException {
        this.createChain().ResultSet_insertRow(this);
    }

    @Override
    public void updateRow() throws SQLException {
        this.createChain().ResultSet_updateRow(this);
    }

    @Override
    public void deleteRow() throws SQLException {
        this.createChain().ResultSet_deleteRow(this);
    }

    @Override
    public void refreshRow() throws SQLException {
        this.createChain().ResultSet_refreshRow(this);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.createChain().ResultSet_cancelRowUpdates(this);
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.createChain().ResultSet_moveToInsertRow(this);
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.createChain().ResultSet_moveToCurrentRow(this);
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.createChain().ResultSet_getStatement(this);
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return this.createChain().ResultSet_getObject(this, columnIndex, map);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getRef(this, columnIndex);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getBlob(this, columnIndex);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getClob(this, columnIndex);
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getArray(this, columnIndex);
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.createChain().ResultSet_getObject(this, columnLabel, map);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getRef(this, columnLabel);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getBlob(this, columnLabel);
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getClob(this, columnLabel);
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getArray(this, columnLabel);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.createChain().ResultSet_getDate(this, columnIndex, cal);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.createChain().ResultSet_getDate(this, columnLabel, cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.createChain().ResultSet_getTime(this, columnIndex, cal);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.createChain().ResultSet_getTime(this, columnLabel, cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.createChain().ResultSet_getTimestamp(this, columnIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.createChain().ResultSet_getTimestamp(this, columnLabel, cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getURL(this, columnIndex);
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getURL(this, columnLabel);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.createChain().ResultSet_updateRef(this, columnIndex, x);
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        this.createChain().ResultSet_updateRef(this, columnLabel, x);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.createChain().ResultSet_updateBlob(this, columnIndex, x);
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        this.createChain().ResultSet_updateBlob(this, columnLabel, x);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.createChain().ResultSet_updateClob(this, columnIndex, x);
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        this.createChain().ResultSet_updateClob(this, columnLabel, x);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.createChain().ResultSet_updateArray(this, columnIndex, x);
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        this.createChain().ResultSet_updateArray(this, columnLabel, x);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getRowId(this, columnIndex);
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getRowId(this, columnLabel);
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.createChain().ResultSet_updateRowId(this, columnIndex, x);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.createChain().ResultSet_updateRowId(this, columnLabel, x);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.createChain().ResultSet_getHoldability(this);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.createChain().ResultSet_isClosed(this);
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.createChain().ResultSet_updateNString(this, columnIndex, nString);
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.createChain().ResultSet_updateNString(this, columnLabel, nString);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.createChain().ResultSet_updateNClob(this, columnIndex, nClob);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.createChain().ResultSet_updateNClob(this, columnLabel, nClob);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getNClob(this, columnIndex);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getNClob(this, columnLabel);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getSQLXML(this, columnIndex);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getSQLXML(this, columnLabel);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.createChain().ResultSet_updateSQLXML(this, columnIndex, xmlObject);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.createChain().ResultSet_updateSQLXML(this, columnLabel, xmlObject);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getNString(this, columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getNString(this, columnLabel);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.createChain().ResultSet_getNCharacterStream(this, columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.createChain().ResultSet_getNCharacterStream(this, columnLabel);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.createChain().ResultSet_updateNCharacterStream(this, columnIndex, x, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.createChain().ResultSet_updateNCharacterStream(this, columnLabel, reader, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.createChain().ResultSet_updateAsciiStream(this, columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.createChain().ResultSet_updateBinaryStream(this, columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.createChain().ResultSet_updateCharacterStream(this, columnIndex, x, length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.createChain().ResultSet_updateAsciiStream(this, columnLabel, x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.createChain().ResultSet_updateBinaryStream(this, columnLabel, x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.createChain().ResultSet_updateCharacterStream(this, columnLabel, reader, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.createChain().ResultSet_updateBlob(this, columnIndex, inputStream, length);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.createChain().ResultSet_updateBlob(this, columnLabel, inputStream, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.createChain().ResultSet_updateClob(this, columnIndex, reader, length);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.createChain().ResultSet_updateClob(this, columnLabel, reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.createChain().ResultSet_updateNClob(this, columnIndex, reader, length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.createChain().ResultSet_updateNClob(this, columnLabel, reader, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.createChain().ResultSet_updateNCharacterStream(this, columnIndex, x);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.createChain().ResultSet_updateNCharacterStream(this, columnLabel, reader);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.createChain().ResultSet_updateAsciiStream(this, columnIndex, x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.createChain().ResultSet_updateBinaryStream(this, columnIndex, x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.createChain().ResultSet_updateCharacterStream(this, columnIndex, x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.createChain().ResultSet_updateAsciiStream(this, columnLabel, x);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.createChain().ResultSet_updateBinaryStream(this, columnLabel, x);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.createChain().ResultSet_updateCharacterStream(this, columnLabel, reader);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.createChain().ResultSet_updateBlob(this, columnIndex, inputStream);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.createChain().ResultSet_updateBlob(this, columnLabel, inputStream);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.createChain().ResultSet_updateClob(this, columnIndex, reader);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.createChain().ResultSet_updateClob(this, columnLabel, reader);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.createChain().ResultSet_updateNClob(this, columnIndex, reader);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.createChain().ResultSet_updateNClob(this, columnLabel, reader);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    public boolean do_next() throws SQLException {
        return this.rRs.next();
    }

    public void do_close() throws SQLException {
        this.rRs.close();
    }

    public boolean do_wasNull() throws SQLException {
        return this.rRs.wasNull();
    }

    public String do_getString(int columnIndex) throws SQLException {
        return this.rRs.getString(columnIndex);
    }

    public boolean do_getBoolean(int columnIndex) throws SQLException {
        return this.rRs.getBoolean(columnIndex);
    }

    public byte do_getByte(int columnIndex) throws SQLException {
        return this.rRs.getByte(columnIndex);
    }

    public short do_getShort(int columnIndex) throws SQLException {
        return this.rRs.getShort(columnIndex);
    }

    public int do_getInt(int columnIndex) throws SQLException {
        return this.rRs.getInt(columnIndex);
    }

    public long do_getLong(int columnIndex) throws SQLException {
        return this.rRs.getLong(columnIndex);
    }

    public float do_getFloat(int columnIndex) throws SQLException {
        return this.rRs.getFloat(columnIndex);
    }

    public double do_getDouble(int columnIndex) throws SQLException {
        return this.rRs.getDouble(columnIndex);
    }

    public BigDecimal do_getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.rRs.getBigDecimal(columnIndex, scale);
    }

    public byte[] do_getBytes(int columnIndex) throws SQLException {
        return this.rRs.getBytes(columnIndex);
    }

    public Date do_getDate(int columnIndex) throws SQLException {
        return this.rRs.getDate(columnIndex);
    }

    public Time do_getTime(int columnIndex) throws SQLException {
        return this.rRs.getTime(columnIndex);
    }

    public Timestamp do_getTimestamp(int columnIndex) throws SQLException {
        return this.rRs.getTimestamp(columnIndex);
    }

    public InputStream do_getAsciiStream(int columnIndex) throws SQLException {
        return this.rRs.getAsciiStream(columnIndex);
    }

    public InputStream do_getUnicodeStream(int columnIndex) throws SQLException {
        return this.rRs.getUnicodeStream(columnIndex);
    }

    public InputStream do_getBinaryStream(int columnIndex) throws SQLException {
        return this.rRs.getBinaryStream(columnIndex);
    }

    public String do_getString(String columnName) throws SQLException {
        return this.rRs.getString(columnName);
    }

    public boolean do_getBoolean(String columnName) throws SQLException {
        return this.rRs.getBoolean(columnName);
    }

    public byte do_getByte(String columnName) throws SQLException {
        return this.rRs.getByte(columnName);
    }

    public short do_getShort(String columnName) throws SQLException {
        return this.rRs.getShort(columnName);
    }

    public int do_getInt(String columnName) throws SQLException {
        return this.rRs.getInt(columnName);
    }

    public long do_getLong(String columnName) throws SQLException {
        return this.rRs.getLong(columnName);
    }

    public float do_getFloat(String columnName) throws SQLException {
        return this.rRs.getFloat(columnName);
    }

    public double do_getDouble(String columnName) throws SQLException {
        return this.rRs.getDouble(columnName);
    }

    public BigDecimal do_getBigDecimal(String columnName, int scale) throws SQLException {
        return this.rRs.getBigDecimal(columnName, scale);
    }

    public byte[] do_getBytes(String columnName) throws SQLException {
        return this.rRs.getBytes(columnName);
    }

    public Date do_getDate(String columnName) throws SQLException {
        return this.rRs.getDate(columnName);
    }

    public Time do_getTime(String columnName) throws SQLException {
        return this.rRs.getTime(columnName);
    }

    public Timestamp do_getTimestamp(String columnName) throws SQLException {
        return this.rRs.getTimestamp(columnName);
    }

    public InputStream do_getAsciiStream(String columnName) throws SQLException {
        return this.rRs.getAsciiStream(columnName);
    }

    public InputStream do_getUnicodeStream(String columnName) throws SQLException {
        return this.rRs.getUnicodeStream(columnName);
    }

    public InputStream do_getBinaryStream(String columnName) throws SQLException {
        return this.rRs.getBinaryStream(columnName);
    }

    public SQLWarning do_getWarnings() throws SQLException {
        return this.rRs.getWarnings();
    }

    public void do_clearWarnings() throws SQLException {
        this.rRs.clearWarnings();
    }

    public String do_getCursorName() throws SQLException {
        return this.rRs.getCursorName();
    }

    public ResultSetMetaData do_getMetaData() throws SQLException {
        DmdbResultSetMetaData_bs bs = (DmdbResultSetMetaData_bs)this.rRs.getMetaData();
        if (bs == null) {
            return null;
        }
        return new DmdbResultSetMetaData(bs, this);
    }

    public Object do_getObject(int columnIndex) throws SQLException {
        return this.rRs.getObject(columnIndex);
    }

    public Object do_getObject(String columnName) throws SQLException {
        return this.rRs.getObject(columnName);
    }

    public int do_findColumn(String columnName) throws SQLException {
        return this.rRs.findColumn(columnName);
    }

    public Reader do_getCharacterStream(int columnIndex) throws SQLException {
        return this.rRs.getCharacterStream(columnIndex);
    }

    public Reader do_getCharacterStream(String columnName) throws SQLException {
        return this.rRs.getCharacterStream(columnName);
    }

    public BigDecimal do_getBigDecimal(int columnIndex) throws SQLException {
        return this.rRs.getBigDecimal(columnIndex);
    }

    public BigDecimal do_getBigDecimal(String columnName) throws SQLException {
        return this.rRs.getBigDecimal(columnName);
    }

    public boolean do_isBeforeFirst() throws SQLException {
        return this.rRs.isBeforeFirst();
    }

    public boolean do_isAfterLast() throws SQLException {
        return this.rRs.isAfterLast();
    }

    public boolean do_isFirst() throws SQLException {
        return this.rRs.isFirst();
    }

    public boolean do_isLast() throws SQLException {
        return this.rRs.isLast();
    }

    public void do_beforeFirst() throws SQLException {
        this.rRs.beforeFirst();
    }

    public void do_afterLast() throws SQLException {
        this.rRs.afterLast();
    }

    public boolean do_first() throws SQLException {
        return this.rRs.first();
    }

    public boolean do_last() throws SQLException {
        return this.rRs.last();
    }

    public int do_getRow() throws SQLException {
        return this.rRs.getRow();
    }

    public boolean do_absolute(int rows) throws SQLException {
        return this.rRs.absolute(rows);
    }

    public boolean do_relative(int rows) throws SQLException {
        return this.rRs.relative(rows);
    }

    public boolean do_previous() throws SQLException {
        return this.rRs.previous();
    }

    public void do_setFetchDirection(int direction) throws SQLException {
        this.rRs.setFetchDirection(direction);
    }

    public int do_getFetchDirection() throws SQLException {
        return this.rRs.getFetchDirection();
    }

    public void do_setFetchSize(int rows) throws SQLException {
        this.rRs.setFetchSize(rows);
    }

    public int do_getFetchSize() throws SQLException {
        return this.rRs.getFetchSize();
    }

    public int do_getType() throws SQLException {
        return this.rRs.getType();
    }

    public int do_getConcurrency() throws SQLException {
        return this.rRs.getConcurrency();
    }

    public boolean do_rowUpdated() throws SQLException {
        return this.rRs.rowUpdated();
    }

    public boolean do_rowInserted() throws SQLException {
        return this.rRs.rowInserted();
    }

    public boolean do_rowDeleted() throws SQLException {
        return this.rRs.rowDeleted();
    }

    public void do_updateNull(int columnIndex) throws SQLException {
        this.rRs.updateNull(columnIndex);
    }

    public void do_updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.rRs.updateBoolean(columnIndex, x);
    }

    public void do_updateByte(int columnIndex, byte x) throws SQLException {
        this.rRs.updateByte(columnIndex, x);
    }

    public void do_updateShort(int columnIndex, short x) throws SQLException {
        this.rRs.updateShort(columnIndex, x);
    }

    public void do_updateInt(int columnIndex, int x) throws SQLException {
        this.rRs.updateInt(columnIndex, x);
    }

    public void do_updateLong(int columnIndex, long x) throws SQLException {
        this.rRs.updateLong(columnIndex, x);
    }

    public void do_updateFloat(int columnIndex, float x) throws SQLException {
        this.rRs.updateFloat(columnIndex, x);
    }

    public void do_updateDouble(int columnIndex, double x) throws SQLException {
        this.rRs.updateDouble(columnIndex, x);
    }

    public void do_updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.rRs.updateBigDecimal(columnIndex, x);
    }

    public void do_updateString(int columnIndex, String x) throws SQLException {
        this.rRs.updateString(columnIndex, x);
    }

    public void do_updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.rRs.updateBytes(columnIndex, x);
    }

    public void do_updateDate(int columnIndex, Date x) throws SQLException {
        this.rRs.updateDate(columnIndex, x);
    }

    public void do_updateTime(int columnIndex, Time x) throws SQLException {
        this.rRs.updateTime(columnIndex, x);
    }

    public void do_updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.rRs.updateTimestamp(columnIndex, x);
    }

    public void do_updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.rRs.updateAsciiStream(columnIndex, x, length);
    }

    public void do_updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.rRs.updateBinaryStream(columnIndex, x, length);
    }

    public void do_updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.rRs.updateCharacterStream(columnIndex, x, length);
    }

    public void do_updateObject(int columnIndex, Object x, int scale) throws SQLException {
        if (x instanceof DmdbRowId) {
            this.rRs.updateLong(columnIndex, ((DmdbRowId)x).getValue());
        } else {
            this.rRs.updateObject(columnIndex, x, scale);
        }
    }

    public void do_updateObject(int columnIndex, Object x) throws SQLException {
        this.rRs.updateObject(columnIndex, x);
    }

    public void do_updateNull(String columnName) throws SQLException {
        this.rRs.updateNull(columnName);
    }

    public void do_updateBoolean(String columnName, boolean x) throws SQLException {
        this.rRs.updateBoolean(columnName, x);
    }

    public void do_updateByte(String columnName, byte x) throws SQLException {
        this.rRs.updateByte(columnName, x);
    }

    public void do_updateShort(String columnName, short x) throws SQLException {
        this.rRs.updateShort(columnName, x);
    }

    public void do_updateInt(String columnName, int x) throws SQLException {
        this.rRs.updateInt(columnName, x);
    }

    public void do_updateLong(String columnName, long x) throws SQLException {
        this.rRs.updateLong(columnName, x);
    }

    public void do_updateFloat(String columnName, float x) throws SQLException {
        this.rRs.updateFloat(columnName, x);
    }

    public void do_updateDouble(String columnName, double x) throws SQLException {
        this.rRs.updateDouble(columnName, x);
    }

    public void do_updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.rRs.updateBigDecimal(columnName, x);
    }

    public void do_updateString(String columnName, String x) throws SQLException {
        this.rRs.updateString(columnName, x);
    }

    public void do_updateBytes(String columnName, byte[] x) throws SQLException {
        this.rRs.updateBytes(columnName, x);
    }

    public void do_updateDate(String columnName, Date x) throws SQLException {
        this.rRs.updateDate(columnName, x);
    }

    public void do_updateTime(String columnName, Time x) throws SQLException {
        this.rRs.updateTime(columnName, x);
    }

    public void do_updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.rRs.updateTimestamp(columnName, x);
    }

    public void do_updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.rRs.updateAsciiStream(columnName, x, length);
    }

    public void do_updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.rRs.updateBinaryStream(columnName, x, length);
    }

    public void do_updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.rRs.updateCharacterStream(columnName, reader, length);
    }

    public void do_updateObject(String columnName, Object x, int scale) throws SQLException {
        this.rRs.updateObject(columnName, x, scale);
    }

    public void do_updateObject(String columnName, Object x) throws SQLException {
        this.rRs.updateObject(columnName, x);
    }

    public void do_insertRow() throws SQLException {
        this.rRs.insertRow();
    }

    public void do_updateRow() throws SQLException {
        this.rRs.updateRow();
    }

    public void do_deleteRow() throws SQLException {
        this.rRs.deleteRow();
    }

    public void do_refreshRow() throws SQLException {
        this.rRs.refreshRow();
    }

    public void do_cancelRowUpdates() throws SQLException {
        this.rRs.cancelRowUpdates();
    }

    public void do_moveToInsertRow() throws SQLException {
        this.rRs.moveToInsertRow();
    }

    public void do_moveToCurrentRow() throws SQLException {
        this.rRs.moveToCurrentRow();
    }

    public DmdbStatement do_getStatement() {
        return this.curstmt;
    }

    public Object do_getObject(int i, Map<String, Class<?>> map) throws SQLException {
        return this.rRs.getObject(i, map);
    }

    public Ref do_getRef(int i) throws SQLException {
        return this.rRs.getRef(i);
    }

    public Blob do_getBlob(int i) throws SQLException {
        return this.rRs.getBlob(i);
    }

    public Clob do_getClob(int i) throws SQLException {
        return this.rRs.getClob(i);
    }

    public Array do_getArray(int i) throws SQLException {
        return this.rRs.getArray(i);
    }

    public Object do_getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        return this.rRs.getObject(colName, map);
    }

    public Ref do_getRef(String colName) throws SQLException {
        return this.rRs.getRef(colName);
    }

    public Blob do_getBlob(String colName) throws SQLException {
        return this.rRs.getBlob(colName);
    }

    public Clob do_getClob(String colName) throws SQLException {
        return this.rRs.getClob(colName);
    }

    public Array do_getArray(String colName) throws SQLException {
        return this.rRs.getArray(colName);
    }

    public Date do_getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.rRs.getDate(columnIndex, cal);
    }

    public Date do_getDate(String columnName, Calendar cal) throws SQLException {
        return this.rRs.getDate(columnName, cal);
    }

    public Time do_getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.rRs.getTime(columnIndex, cal);
    }

    public Time do_getTime(String columnName, Calendar cal) throws SQLException {
        return this.rRs.getTime(columnName, cal);
    }

    public Timestamp do_getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.rRs.getTimestamp(columnIndex, cal);
    }

    public Timestamp do_getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.rRs.getTimestamp(columnName, cal);
    }

    public URL do_getURL(int columnIndex) throws SQLException {
        return this.rRs.getURL(columnIndex);
    }

    public URL do_getURL(String columnName) throws SQLException {
        return this.rRs.getURL(columnName);
    }

    public void do_updateRef(int columnIndex, Ref x) throws SQLException {
        this.rRs.updateRef(columnIndex, x);
    }

    public void do_updateRef(String columnName, Ref x) throws SQLException {
        this.rRs.updateRef(columnName, x);
    }

    public void do_updateBlob(int columnIndex, Blob x) throws SQLException {
        this.rRs.updateBlob(columnIndex, x);
    }

    public void do_updateBlob(String columnName, Blob x) throws SQLException {
        this.rRs.updateBlob(columnName, x);
    }

    public void do_updateClob(int columnIndex, Clob x) throws SQLException {
        this.rRs.updateClob(columnIndex, x);
    }

    public void do_updateClob(String columnName, Clob x) throws SQLException {
        this.rRs.updateClob(columnName, x);
    }

    public void do_updateArray(int columnIndex, Array x) throws SQLException {
        this.rRs.updateArray(columnIndex, x);
    }

    public void do_updateArray(String columnName, Array x) throws SQLException {
        this.rRs.updateArray(columnName, x);
    }

    public void updateINTERVALYM(int i, DmdbIntervalYM ym) throws SQLException {
        this.rRs.updateINTERVALYM(i, ym);
    }

    public void updateINTERVALYM(String s, DmdbIntervalYM ym) throws SQLException {
        this.rRs.updateINTERVALYM(s, ym);
    }

    public void updateINTERVALDT(int i, DmdbIntervalDT dt) throws SQLException {
        this.rRs.updateINTERVALDT(i, dt);
    }

    public void updateINTERVALDT(String s, DmdbIntervalDT dt) throws SQLException {
        this.rRs.updateINTERVALDT(s, dt);
    }

    public long getRowid() {
        return this.rRs.getRowid();
    }

    public long getRowCount() throws SQLException {
        return this.rRs.getRowCount();
    }

    public final Object clone() {
        return this.rRs.clone();
    }

    public void setRsId(short resId) {
        this.rRs.setRsId(resId);
    }

    public RowId do_getRowId(int columnIndex) throws SQLException {
        long val = this.do_getLong(columnIndex);
        String schema = this.rRs.colInfo[columnIndex - 1].getDesc().getSchName();
        String table = this.rRs.colInfo[columnIndex - 1].getDesc().getTabName();
        DmdbRowId rowId = new DmdbRowId(val, schema, table);
        return rowId;
    }

    public RowId do_getRowId(String columnName) throws SQLException {
        return this.do_getRowId(this.do_findColumn(columnName));
    }

    public void do_updateRowId(int columnIndex, RowId x) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void do_updateRowId(String columnName, RowId x) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public int do_getHoldability() throws SQLException {
        return this.rRs.getHoldability();
    }

    public boolean do_isClosed() throws SQLException {
        return this.rRs.isClosed();
    }

    public void do_updateNString(int columnIndex, String nString) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void do_updateNString(String columnName, String nString) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void do_updateNClob(int columnIndex, NClob nClob) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void do_updateNClob(String columnName, NClob nClob) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public NClob do_getNClob(int columnIndex) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public NClob do_getNClob(String columnName) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public SQLXML do_getSQLXML(int columnIndex) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public SQLXML do_getSQLXML(String columnName) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public void do_updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void do_updateSQLXML(String columnName, SQLXML xmlObject) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public String do_getNString(int columnIndex) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public String do_getNString(String columnName) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public Reader do_getNCharacterStream(int columnIndex) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public Reader do_getNCharacterStream(String columnName) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public void do_updateNCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void do_updateNCharacterStream(String columnName, Reader x, int length) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void do_updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.rRs.updateAsciiStream(columnIndex, x, length);
    }

    public void do_updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.rRs.updateAsciiStream(columnIndex, x);
    }

    public void do_updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.rRs.updateAsciiStream(this.do_findColumn(columnLabel), x, length);
    }

    public void do_updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.rRs.updateAsciiStream(this.do_findColumn(columnLabel), x);
    }

    public void do_updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.rRs.updateBinaryStream(columnIndex, x, length);
    }

    public void do_updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.rRs.updateBinaryStream(columnIndex, x);
    }

    public void do_updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.rRs.updateBinaryStream(this.do_findColumn(columnLabel), x, length);
    }

    public void do_updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.rRs.updateBinaryStream(this.do_findColumn(columnLabel), x);
    }

    public void do_updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.rRs.updateAsciiStream(columnIndex, inputStream, length);
    }

    public void do_updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.rRs.updateAsciiStream(columnIndex, inputStream);
    }

    public void do_updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.rRs.updateAsciiStream(this.do_findColumn(columnLabel), inputStream, length);
    }

    public void do_updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.rRs.updateAsciiStream(this.do_findColumn(columnLabel), inputStream);
    }

    public void do_updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.rRs.updateCharacterStream(columnIndex, x, length);
    }

    public void do_updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.rRs.updateCharacterStream(columnIndex, x);
    }

    public void do_updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.rRs.updateCharacterStream(this.do_findColumn(columnLabel), reader, length);
    }

    public void do_updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.rRs.updateCharacterStream(this.do_findColumn(columnLabel), reader);
    }

    public void do_updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.rRs.updateCharacterStream(columnIndex, reader, length);
    }

    public void do_updateClob(int columnIndex, Reader reader) throws SQLException {
        this.rRs.updateCharacterStream(columnIndex, reader);
    }

    public void do_updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.rRs.updateCharacterStream(this.do_findColumn(columnLabel), reader, length);
    }

    public void do_updateClob(String columnLabel, Reader reader) throws SQLException {
        this.rRs.updateCharacterStream(this.do_findColumn(columnLabel), reader);
    }

    public void do_updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void do_updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void do_updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void do_updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void do_updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void do_updateNClob(int columnIndex, Reader reader) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void do_updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void do_updateNClob(String columnLabel, Reader reader) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public <T> T do_getObject(int columnIndex, Class<T> type) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public <T> T do_getObject(String columnLabel, Class<T> type) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public void setConstructNano() {
        this.constructNano = System.nanoTime();
    }

    public long getConstructNano() {
        return this.constructNano;
    }

    public long getFetchRowCount() {
        return this.rRs.getFetchRowCount();
    }

    public int getCursorIndex() {
        return this.cursorIndex;
    }

    public void setCursorIndex(int cursorIndex) {
        this.cursorIndex = cursorIndex;
    }

    public int getCloseCount() {
        return this.closeCount;
    }

    public void incrementCloseCount() {
        this.closeCount = this.closeCount++;
    }

    public long getReadStringLength() {
        return this.readStringLength;
    }

    public void setReadStringLength(long readStringLength) {
        this.readStringLength = readStringLength;
    }

    public long getReadBytesLength() {
        return this.readBytesLength;
    }

    public void setReadBytesLength(long readBytesLength) {
        this.readBytesLength = readBytesLength;
    }

    public int getOpenInputStreamCount() {
        return this.openInputStreamCount;
    }

    public void setOpenInputStreamCount(int openInputStreamCount) {
        this.openInputStreamCount = openInputStreamCount;
    }

    public int getOpenReaderCount() {
        return this.openReaderCount;
    }

    public void setOpenReaderCount(int openReaderCount) {
        this.openReaderCount = openReaderCount;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public SqlStat getSqlStat() {
        return this.sqlStat;
    }

    public void setSqlStat(SqlStat sqlStat) {
        this.sqlStat = sqlStat;
    }

    public long getLastExecuteTimeNano() {
        return this.curstmt.getLastExecuteTimeNano();
    }
}

