/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.desc.DTypeInfo;
import java.sql.SQLException;

public class DmdbType {
    static final String VERSION = "7.6.0.142";
    static final String EXECUTE2_VERSION = "7.1.2.128";
    static final String LOB_EMPTY_COMP_ORCL_VERSION = "7.1.5.144";
    public static final String BUILD_TIME = "2017.06.02";
    public static final long STARTUP_TIME = System.currentTimeMillis();
    static final String DRIVER_NAME = "dm.jdbc.driver.DmDriver";
    static final String DATABASE_PRODUCT_VERSION = "7.0.0.9";
    public static int JDBC_VERSION = 3;
    public static final int CURSOR = 50;
    public static final int ORACLE_CURSOR = -10;
    public static final int DATA_CHAR = 0;
    public static final int DATA_VARCHAR2 = 1;
    public static final int DATA_VARCHAR = 2;
    public static final int DATA_BIT = 3;
    public static final int DATA_TINYINT = 5;
    public static final int DATA_SMALLINT = 6;
    public static final int DATA_INT = 7;
    public static final int DATA_INT64 = 8;
    public static final int DATA_XDEC = 9;
    public static final int DATA_REAL = 10;
    public static final int DATA_DOUBLE = 11;
    public static final int DATA_BLOB = 12;
    public static final int DATA_BOOLEAN = 13;
    public static final int DATA_DATE = 14;
    public static final int DATA_TIME = 15;
    public static final int DATA_DATETIME = 16;
    public static final int DATA_BINARY = 17;
    public static final int DATA_VARBINARY = 18;
    public static final int DATA_TEXT = 19;
    public static final int DATA_INTERVAL_YM = 20;
    public static final int DATA_INTERVAL_DT = 21;
    public static final int DATA_TIME_TZ = 22;
    public static final int DATA_DATETIME_TZ = 23;
    public static final int DATA_NULL = 25;
    public static final int DATA_ANY = 31;
    public static final int DATA_STAR_ALL = 32;
    public static final int DATA_STAR = 33;
    public static final int DATA_RECORD = 40;
    public static final int DATA_TYPE = 41;
    public static final int DATA_TYPE_REF = 42;
    public static final int DATA_UNKNOWN = 54;
    public static final int PLTYPE_ARRAY = 117;
    public static final int PLTYPE_CLASS = 119;
    public static final int PLTYPE_CURSOR = 120;
    public static final int PLTYPE_RECORD = 121;
    public static final int PLTYPE_SARRAY = 122;
    public static final int DATA_LOCAL_TIME_ZONE_MASK = 4096;
    public static final int DATA_BIT_LEN = 1;
    public static final int DATA_TINYINT_LEN = 1;
    public static final int DATA_SMALLINT_LEN = 2;
    public static final int DATA_INT_LEN = 4;
    public static final int DATA_INT64_LEN = 8;
    public static final int DATA_FLOAT_LEN = 4;
    public static final int DATA_DOUBLE_LEN = 8;
    public static final int DATA_DATE_LEN = 3;
    public static final int DATA_TIME_LEN = 5;
    public static final int DATA_DATETIME_LEN = 8;
    public static final int DATA_INTERVAL_YM_LEN = 12;
    public static final int DATA_INTERVAL_DT_LEN = 24;
    public static final int DATA_TIME_TZ_LEN = 12;
    public static final int DATA_DATETIME_TZ_LEN = 12;
    public static final int DATA_DEC_INT64_LEN = 8;
    public static final int DATA_NULL_LEN = 4;
    public static final int MAX_STRING_LEN = 8188;
    public static final int MAX_DMINTVER_LOADPREC = 9;
    public static final int MAX_DMINTVER_SECDPREC = 6;
    public static final int DATA_JIO_INVALID = -1;
    public static final int DATA_JIO_BOOLEAN = 0;
    public static final int DATA_JIO_BYTE = 1;
    public static final int DATA_JIO_SHORT = 2;
    public static final int DATA_JIO_INTEGER = 3;
    public static final int DATA_JIO_LONG = 4;
    public static final int DATA_JIO_FLOAT = 5;
    public static final int DATA_JIO_DOUBLE = 6;
    public static final int DATA_JIO_BIGDEC = 7;
    public static final int DATA_JIO_DATE = 8;
    public static final int DATA_JIO_TIME = 9;
    public static final int DATA_JIO_TIMESTAMP = 10;
    public static final int DATA_JIO_DM_TIME = 11;
    public static final int DATA_JIO_DM_INTV_YM = 12;
    public static final int DATA_JIO_DM_INTV_DT = 13;
    public static final int DATA_JIO_STRING = 14;
    public static final int DATA_JIO_BYTE_ARR = 15;
    public static final int DATA_JIO_BLOB = 16;
    public static final int DATA_JIO_CLOB = 17;
    public static final int DATA_JIO_READER = 18;
    public static final int DATA_JIO_INPUTSTREAM = 19;
    public static final int DATA_JIO_ARRAY = 20;
    public static final int DATA_JIO_STRUCT = 21;
    public static final int DATA_JIO_TIMEZONE = 22;
    public static final int DATA_JIO_CHAR = 23;
    public static final int DATA_JIO_NULL = 24;
    public static final int DATA_JIO_OBJECT = 25;
    public static final int DATA_JIO_REF = 26;
    public static final int DATA_JIO_URL = 27;
    public static final int OBJ_BLOB_MAGIC = 78111999;
    public static final int CLTN_TYPE_IND_TABLE = 3;
    public static final int CLTN_TYPE_NST_TABLE = 2;
    public static final int CLTN_TYPE_VARRAY = 1;
    public static final int INTERVAL_YEAR = 0;
    public static final int INTERVAL_YEAR_TO_MONTH = 1;
    public static final int INTERVAL_MONTH = 2;
    public static final int INTERVAL_DAY = 3;
    public static final int INTERVAL_DAY_TO_HOUR = 4;
    public static final int INTERVAL_DAY_TO_MIMUTE = 5;
    public static final int INTERVAL_DAY_TO_SECOND = 6;
    public static final int INTERVAL_HOUR = 7;
    public static final int INTERVAL_HOUR_TO_MIMUTE = 8;
    public static final int INTERVAL_HOUR_TO_SECOND = 9;
    public static final int INTERVAL_MIMUTE = 10;
    public static final int INTERVAL_MIMUTE_TO_SECOND = 11;
    public static final int INTERVAL_SECOND = 12;
    public static final int ARRAY_TYPE_SHORT = 1;
    public static final int ARRAY_TYPE_INTEGER = 2;
    public static final int ARRAY_TYPE_LONG = 3;
    public static final int ARRAY_TYPE_FLOAT = 4;
    public static final int ARRAY_TYPE_DOUBLE = 5;

    public static String getVersion() {
        return VERSION;
    }

    public static String getDbProductVer() {
        return DATABASE_PRODUCT_VERSION;
    }

    public static boolean isNumberType(int dType) {
        return dType == 7 || dType == 6 || dType == 8 || dType == 5;
    }

    public static boolean isComplexType(int dtype, int scale) {
        return dtype == 12 && scale == 5;
    }

    public static boolean isLocalTimeZone(int type, int scale) {
        return type == 16 && (scale & 0x1000) != 0;
    }

    public static int localTimeZoneRealPrec(int prec) {
        return prec & 0xFFFFEFFF;
    }

    public static final int CPrecToJdbcPrec(int jSqlType, int cprec, int scale) {
        int jPrec = 0;
        switch (jSqlType) {
            case -7: {
                jPrec = 1;
                break;
            }
            case -6: {
                jPrec = 3;
                break;
            }
            case -5: {
                jPrec = 19;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                jPrec = cprec;
                break;
            }
            case -1: {
                jPrec = cprec;
                break;
            }
            case 0: 
            case 2: 
            case 3: {
                jPrec = cprec;
                break;
            }
            case 4: {
                jPrec = 10;
                break;
            }
            case 5: {
                jPrec = 5;
                break;
            }
            case 6: {
                jPrec = 53;
                break;
            }
            case 7: {
                jPrec = 24;
                break;
            }
            case 8: {
                jPrec = 53;
                break;
            }
            case 1: 
            case 12: {
                jPrec = cprec;
                break;
            }
            case 16: {
                jPrec = 1;
                break;
            }
            case 91: {
                jPrec = 10;
                break;
            }
            case 92: {
                if (scale != 0) {
                    jPrec = 9 + scale;
                    break;
                }
                jPrec = 8;
                break;
            }
            case 93: {
                if (scale != 0) {
                    jPrec = 20 + DmdbType.localTimeZoneRealPrec(scale);
                    break;
                }
                jPrec = 19;
                break;
            }
            default: {
                jPrec = cprec;
            }
        }
        return jPrec;
    }

    public static final int displaySizeByJdbcType(int jSqlType, int cprec, int scale) {
        int jPrec = 0;
        switch (jSqlType) {
            case -7: {
                jPrec = 1;
                break;
            }
            case -6: {
                jPrec = 4;
                break;
            }
            case 5: {
                jPrec = 6;
                break;
            }
            case 4: {
                jPrec = 11;
                break;
            }
            case -5: {
                jPrec = 20;
                break;
            }
            case 2: 
            case 3: {
                if (cprec == 0) {
                    jPrec = 22;
                    break;
                }
                jPrec = cprec + 2;
                break;
            }
            case 7: {
                jPrec = 25;
                break;
            }
            case 6: {
                jPrec = 54;
                break;
            }
            case 8: {
                jPrec = 53;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                jPrec = cprec * 2;
                break;
            }
            case -1: {
                jPrec = cprec;
                break;
            }
            case 1: 
            case 12: {
                jPrec = cprec;
                break;
            }
            case 16: {
                jPrec = 1;
                break;
            }
            case 91: {
                jPrec = 10;
                break;
            }
            case 92: {
                if (scale != 0) {
                    jPrec = 9 + scale;
                    break;
                }
                jPrec = 8;
                break;
            }
            case 93: {
                if (scale != 0) {
                    jPrec = 20 + DmdbType.localTimeZoneRealPrec(scale);
                    break;
                }
                jPrec = 19;
                break;
            }
            case 0: {
                jPrec = cprec + 2;
                break;
            }
            default: {
                jPrec = cprec;
            }
        }
        return jPrec;
    }

    public static final int dtypeToSqlType(int dtype, String typeName) {
        int jdbcType = 0;
        switch (dtype) {
            case 0: 
            case 1: {
                jdbcType = 1;
                break;
            }
            case 2: {
                jdbcType = 12;
                break;
            }
            case 3: {
                if (typeName != null && typeName.equalsIgnoreCase("BOOLEAN")) {
                    jdbcType = 16;
                    break;
                }
                jdbcType = -7;
                break;
            }
            case 5: {
                jdbcType = -6;
                break;
            }
            case 6: {
                jdbcType = 5;
                break;
            }
            case 7: {
                jdbcType = 4;
                break;
            }
            case 8: {
                jdbcType = -5;
                break;
            }
            case 9: {
                if (typeName != null && (typeName.equalsIgnoreCase("NUMERIC") || typeName.equalsIgnoreCase("NUMBER"))) {
                    jdbcType = 2;
                    break;
                }
                jdbcType = 3;
                break;
            }
            case 10: {
                jdbcType = 7;
                break;
            }
            case 11: {
                if (typeName != null && typeName.equalsIgnoreCase("FLOAT")) {
                    jdbcType = 6;
                    break;
                }
                jdbcType = 8;
                break;
            }
            case 12: {
                if (typeName != null && typeName.equalsIgnoreCase("LONGVARBINARY")) {
                    jdbcType = -4;
                    break;
                }
                jdbcType = 2004;
                break;
            }
            case 13: {
                jdbcType = 16;
                break;
            }
            case 14: {
                jdbcType = 91;
                break;
            }
            case 15: {
                jdbcType = 92;
                break;
            }
            case 16: {
                jdbcType = 93;
                break;
            }
            case 17: {
                jdbcType = -2;
                break;
            }
            case 18: {
                jdbcType = -3;
                break;
            }
            case 19: {
                if (typeName != null && typeName.equalsIgnoreCase("LONGVARCHAR")) {
                    jdbcType = -1;
                    break;
                }
                jdbcType = 2005;
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                jdbcType = 2000;
                break;
            }
            case 54: {
                jdbcType = 12;
                break;
            }
            case 117: 
            case 122: {
                jdbcType = 2003;
                break;
            }
            case 119: 
            case 121: {
                jdbcType = 2002;
                break;
            }
            case 50: {
                jdbcType = 1111;
            }
            default: {
                jdbcType = 0;
            }
        }
        return jdbcType;
    }

    public static final int sqlTypeToDType(int jdbcType) {
        int dtype = 0;
        switch (jdbcType) {
            case 2003: {
                dtype = 117;
                break;
            }
            case -5: {
                dtype = 8;
                break;
            }
            case -2: {
                dtype = 17;
                break;
            }
            case -7: {
                dtype = 3;
                break;
            }
            case -4: 
            case 2004: {
                dtype = 12;
                break;
            }
            case 16: {
                dtype = 13;
                break;
            }
            case 1: {
                dtype = 0;
                break;
            }
            case -1: 
            case 2005: {
                dtype = 19;
                break;
            }
            case 91: {
                dtype = 14;
                break;
            }
            case 2: 
            case 3: {
                dtype = 9;
                break;
            }
            case 8: {
                dtype = 11;
                break;
            }
            case 6: 
            case 7: {
                dtype = 10;
                break;
            }
            case 4: {
                dtype = 7;
                break;
            }
            case 5: {
                dtype = 6;
                break;
            }
            case 2000: 
            case 2002: {
                dtype = 119;
                break;
            }
            case 92: {
                dtype = 15;
                break;
            }
            case 93: {
                dtype = 16;
                break;
            }
            case -6: {
                dtype = 5;
                break;
            }
            case -3: {
                dtype = 18;
                break;
            }
            case 12: {
                dtype = 2;
                break;
            }
            default: {
                dtype = 54;
            }
        }
        return dtype;
    }

    public static final boolean isNUMERICtype(int type) {
        return type == -5 || type == 3 || type == 8 || type == 6 || type == 7 || type == 4 || type == 5 || type == -6 || type == 2;
    }

    public static final int getIntervalLoadPrec(int typePrec) {
        int prec = (typePrec & 0xF0) >> 4;
        return prec;
    }

    public static final int getIntervalScale(int typePrec) {
        int scale = 2;
        int type = (typePrec & 0xFF00) >> 8;
        if (type == 6 || type == 9 || type == 11 || type == 12) {
            scale = typePrec & 0xF;
        }
        return scale;
    }

    public static final String interval_dtype_to_name(int scale) {
        String name = "";
        int qua = (scale & 0xFF00) >> 8;
        int lead_prec = (scale & 0xF0) >> 4;
        int second_prec = scale & 0xF;
        switch (qua) {
            case 0: {
                name = "INTERVAL YEAR(" + lead_prec + ")";
                break;
            }
            case 2: {
                name = "INTERVAL MONTH(" + lead_prec + ")";
                break;
            }
            case 3: {
                name = "INTERVAL DAY(" + lead_prec + ")";
                break;
            }
            case 7: {
                name = "INTERVAL HOUR(" + lead_prec + ")";
                break;
            }
            case 10: {
                name = "INTERVAL MINUTE(" + lead_prec + ")";
                break;
            }
            case 12: {
                name = "INTERVAL SECOND(" + lead_prec + "," + second_prec + ")";
                break;
            }
            case 1: {
                name = "INTERVAL YEAR(" + lead_prec + ") TO MONTH";
                break;
            }
            case 4: {
                name = "INTERVAL DAY(" + lead_prec + ") TO HOUR";
                break;
            }
            case 5: {
                name = "INTERVAL DAY(" + lead_prec + ") TO MINUTE";
                break;
            }
            case 6: {
                name = "INTERVAL DAY(" + lead_prec + ") TO SECOND(" + second_prec + ")";
                break;
            }
            case 8: {
                name = "INTERVAL HOUR(" + lead_prec + ") TO MINUTE";
                break;
            }
            case 9: {
                name = "INTERVAL HOUR(" + lead_prec + ") TO SECOND(" + second_prec + ")";
                break;
            }
            case 11: {
                name = "INTERVAL MINUTE(" + lead_prec + ") TO SECOND(" + second_prec + ")";
            }
        }
        return name;
    }

    static boolean dtype_is_fixed_low(int dtype) {
        switch (dtype) {
            case 0: {
                return true;
            }
            case 1: 
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
            case 6: {
                return true;
            }
            case 5: {
                return true;
            }
            case 9: {
                return true;
            }
            case 10: {
                return true;
            }
            case 11: {
                return true;
            }
            case 12: {
                return false;
            }
            case 19: {
                return false;
            }
            case 14: {
                return true;
            }
            case 15: {
                return true;
            }
            case 16: {
                return true;
            }
            case 20: {
                return true;
            }
            case 21: {
                return true;
            }
            case 17: {
                return true;
            }
            case 18: {
                return false;
            }
            case 25: {
                return true;
            }
        }
        return false;
    }

    static int dtype_get_internal_len_low(int dtype, int len) {
        switch (dtype) {
            case 7: {
                return 4;
            }
            case 0: {
                return len;
            }
            case 9: {
                return (2 + len + 1) / 2;
            }
            case 11: {
                return 8;
            }
            case 6: {
                return 2;
            }
            case 8: {
                return 8;
            }
            case 5: {
                return 1;
            }
            case 10: {
                return 4;
            }
            case 14: {
                return 3;
            }
            case 15: {
                return 5;
            }
            case 16: {
                return 8;
            }
            case 17: {
                return len;
            }
            case 3: {
                return 1;
            }
            case 20: {
                return 12;
            }
            case 21: {
                return 24;
            }
            case 25: {
                return 4;
            }
        }
        return 0;
    }

    public static final DTypeInfo getDtypeByJType(int Jtype, int Jprec, int Jscale, int sDtype, int sPrec, int sScale) throws SQLException {
        int dType = 0;
        int prec = 0;
        int scale = 0;
        switch (Jtype) {
            case 0: 
            case 1: {
                dType = 5;
                prec = 1;
                scale = 0;
                break;
            }
            case 2: {
                dType = 6;
                prec = 2;
                scale = 0;
                break;
            }
            case 3: {
                dType = 7;
                prec = 4;
                scale = 0;
                break;
            }
            case 4: {
                dType = 8;
                prec = 8;
                scale = 0;
                break;
            }
            case 5: {
                dType = 10;
                prec = 0;
                scale = 0;
                break;
            }
            case 6: {
                dType = 11;
                prec = 0;
                scale = 0;
                break;
            }
            case 7: {
                if (sDtype != 10 && sDtype != 11) {
                    dType = 9;
                    prec = 0;
                    scale = 0;
                    break;
                }
                dType = sDtype;
                prec = sPrec;
                scale = sScale;
                break;
            }
            case 8: {
                dType = 14;
                prec = 3;
                scale = 0;
                break;
            }
            case 9: {
                dType = 15;
                prec = 5;
                scale = 0;
                break;
            }
            case 10: {
                dType = 16;
                prec = 8;
                scale = 0;
                break;
            }
            case 11: {
                dType = 15;
                prec = 5;
                scale = 0;
                break;
            }
            case 12: {
                dType = 20;
                prec = 0;
                scale = Jprec;
                break;
            }
            case 13: {
                dType = 21;
                prec = 0;
                scale = Jprec;
                break;
            }
            case 14: {
                dType = 2;
                prec = 8188;
                scale = 0;
                break;
            }
            case 15: {
                dType = 18;
                prec = 8188;
                scale = 0;
                break;
            }
            case 16: {
                dType = 12;
                prec = sPrec;
                scale = 0;
                break;
            }
            case 17: {
                dType = 19;
                prec = sPrec;
                scale = 0;
                break;
            }
            case 18: {
                if (sDtype == 0 || sDtype == 1 || sDtype == 2 || sDtype == 17 || sDtype == 18) {
                    dType = 2;
                    prec = 8188;
                    scale = 0;
                    break;
                }
                if (sDtype == 12 || sDtype == 19) {
                    dType = 19;
                    prec = Integer.MAX_VALUE;
                    scale = 0;
                    break;
                }
                DBError.throwSQLException(6007);
                break;
            }
            case 19: {
                if (sDtype == 0 || sDtype == 1 || sDtype == 2 || sDtype == 17 || sDtype == 18) {
                    dType = 18;
                    prec = 8188;
                    scale = 0;
                    break;
                }
                if (sDtype == 12 || sDtype == 19) {
                    dType = 12;
                    prec = Integer.MAX_VALUE;
                    scale = 0;
                    break;
                }
                DBError.throwSQLException(6007);
                break;
            }
            case 20: 
            case 21: {
                dType = sDtype;
                prec = 1;
                scale = 0;
                break;
            }
            case 22: {
                dType = sDtype;
                prec = 0;
                scale = sScale;
                break;
            }
            case 23: {
                dType = 0;
                prec = 1;
                scale = 0;
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return new DTypeInfo(dType, prec, scale);
    }

    public static final boolean emptyStringToNull(int dType) {
        switch (dType) {
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBFileType(int dtype, int prec, int scale) {
        return dtype == 2 && prec == 512 && scale == 6;
    }
}

