/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.stat;

import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.stat.ConnectionStat;
import dm.jdbc.stat.ConnectionStatValue;
import dm.jdbc.stat.JdbcStat;
import dm.jdbc.stat.SqlStat;
import dm.jdbc.stat.support.json.JSONArray;
import dm.jdbc.stat.support.json.JSONObject;
import dm.jdbc.util.StringUtil;
import dm.jdbc.util.stat.FilterUtil;
import dm.jdbc.util.stat.MapComparator;
import java.lang.management.ManagementFactory;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.JMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatService {
    public static final String PROP_NAME_SORT = "sort";
    public static final String PROP_NAME_SORT_FIELD = "field";
    public static final String PROP_NAME_SORT_TYPE = "direction";
    public static final String PROP_NAME_SEARCH = "search";
    public static final String PROP_NAME_PAGE_NUM = "pageNum";
    public static final String PROP_NAME_PAGE_SIZE = "pageSize";
    public static final String PROP_NAME_PAGE_COUNT = "pageCount";
    public static final String PROP_NAME_TOTAL_ROW_COUNT = "totalRowCount";
    public static final String PROP_NAME_FLUSH_FREQ = "flushFreq";
    public static final String PROP_NAME_DATASOURCE_ID = "dataSourceId";
    public static final String PROP_NAME_SQL_ID = "sqlId";
    public static final String URL_SQL = "/sql.json";
    public static final String URL_SQL_DETAIL = "/sqlDetail.json";
    public static final String URL_DATASOURCE = "/dataSource.json";
    public static final String URL_DATASOURCE_DETAIL = "/dataSourceDetail.json";
    public static final String URL_DRIVER_INFO = "/driverInfo.json";
    public static final int RESULT_CODE_SUCCESS = 1;
    public static final int RESULT_CODE_ERROR = -1;
    private static final int DEFAULT_PAGE_NUM = 1;
    private static final int DEFAULT_PAGE_SIZE = Integer.MAX_VALUE;
    private static final String DEFAULT_ORDER_TYPE = "asc";
    private static final String DEFAULT_ORDERBY = "DataSourceId";
    public static JdbcStat jdbcStat = new JdbcStat(-1);
    private static final StatService instance = new StatService();

    private StatService() {
    }

    public static StatService getInstance() {
        return instance;
    }

    public List<Map<String, Object>> service(String url) {
        return this.service(url, null);
    }

    public List<Map<String, Object>> service(String url, Properties params) {
        if (params != null) {
            params.putAll((Map<?, ?>)this.parseUrl(url));
        } else {
            params = this.parseUrl(url);
        }
        if (url.startsWith(URL_SQL)) {
            List<Map<String, Object>> array = this.getSqlStatList(params);
            array = this.comparatorOrderBy(array, params);
            params.put(PROP_NAME_FLUSH_FREQ, (Object)DmSvcConf.statFlushFreq);
            return array;
        }
        if (url.startsWith(URL_SQL_DETAIL)) {
            List<Map<String, Object>> array = this.getSqlStatDetailList(params);
            return array;
        }
        if (url.startsWith(URL_DATASOURCE)) {
            List<Map<String, Object>> array = this.getConnStatList(params);
            array = this.comparatorOrderBy(array, params);
            params.put(PROP_NAME_FLUSH_FREQ, (Object)DmSvcConf.statFlushFreq);
            return array;
        }
        if (url.startsWith(URL_DATASOURCE_DETAIL)) {
            List<Map<String, Object>> array = this.getConnStatDetailList(params);
            return array;
        }
        if (url.startsWith(URL_DRIVER_INFO)) {
            List<Map<String, Object>> array = this.getDriverInfoList(params);
            return array;
        }
        return null;
    }

    private void resetPageInfo(Properties params, int rowCount, int pageCount, int pageNum) {
        try {
            if (params != null && params.containsKey(PROP_NAME_PAGE_SIZE)) {
                params.put(PROP_NAME_PAGE_COUNT, (Object)pageCount);
                params.put(PROP_NAME_TOTAL_ROW_COUNT, (Object)rowCount);
                params.put(PROP_NAME_PAGE_NUM, (Object)pageNum);
            }
        }
        catch (Exception exception) {}
    }

    private List<Map<String, Object>> getDriverInfoList(Properties parmas) {
        ArrayList<Map<String, Object>> sortedArray = new ArrayList<Map<String, Object>>();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "\u9a71\u52a8");
        data.put("value", "dm.jdbc.driver.DmDriver");
        sortedArray.add(data);
        data = new HashMap();
        data.put("name", "\u7248\u672c");
        data.put("value", String.valueOf(DmdbType.getVersion()) + "(" + "2017.06.02" + ")");
        sortedArray.add(data);
        data = new HashMap();
        data.put("name", "\u542f\u52a8\u65f6\u95f4");
        data.put("value", new Timestamp(DmdbType.STARTUP_TIME).toString());
        sortedArray.add(data);
        data = new HashMap();
        data.put("name", "java\u7248\u672c");
        data.put("value", System.getProperty("java.version"));
        sortedArray.add(data);
        data = new HashMap();
        data.put("name", "Java Home");
        data.put("value", System.getProperty("java.home"));
        sortedArray.add(data);
        data = new HashMap();
        data.put("name", "jvm\u540d\u79f0");
        data.put("value", System.getProperty("java.vm.name"));
        sortedArray.add(data);
        data = new HashMap();
        data.put("name", "jvm\u53c2\u6570");
        List<String> args = ManagementFactory.getRuntimeMXBean().getInputArguments();
        if (args != null && args.size() > 0) {
            StringBuilder buf = new StringBuilder();
            for (String str : args) {
                buf.append(str).append("<br>");
            }
            data.put("value", buf.toString());
        } else {
            data.put("value", "");
        }
        sortedArray.add(data);
        data = new HashMap();
        data.put("name", "java.library.path");
        String str = System.getProperty("java.library.path");
        if (StringUtil.isNotEmpty(str)) {
            data.put("value", str);
        } else {
            data.put("value", "");
        }
        sortedArray.add(data);
        data = new HashMap();
        data.put("name", "java.class.path");
        str = System.getProperty("java.class.path");
        if (StringUtil.isNotEmpty(str)) {
            data.put("value", str);
        } else {
            data.put("value", "");
        }
        sortedArray.add(data);
        return sortedArray;
    }

    private List<Map<String, Object>> getSqlStatList(Properties params) {
        ArrayList<Map<String, Object>> array = new ArrayList<Map<String, Object>>();
        Map<String, ConnectionStat> connStatMap = jdbcStat.getConnStatMap();
        for (ConnectionStat connStat : connStatMap.values()) {
            Map<String, SqlStat> sqlStatMap = connStat.getSqlStatMap();
            for (SqlStat sqlStat : sqlStatMap.values()) {
                try {
                    Map<String, Object> data = sqlStat.getData();
                    long executeCount = (Long)data.get("ExecuteCount");
                    long runningCount = (Long)data.get("RunningCount");
                    if (executeCount == 0L && runningCount == 0L || !this.filterStatData(data, params)) continue;
                    array.add(data);
                }
                catch (Exception exception) {}
            }
        }
        return array;
    }

    private boolean filterStatData(Map<String, Object> data, Properties params) {
        JSONArray search = null;
        if (params.containsKey(PROP_NAME_SEARCH)) {
            search = (JSONArray)params.get(PROP_NAME_SEARCH);
        }
        if (search != null && search.length() > 0) {
            int i = 0;
            while (i < search.length()) {
                block20: {
                    String colValue;
                    String filterValue;
                    String operator;
                    block27: {
                        block26: {
                            block25: {
                                String type;
                                String field;
                                JSONObject filterCol;
                                block21: {
                                    int filterValue2;
                                    int colValue2;
                                    block24: {
                                        block23: {
                                            block22: {
                                                try {
                                                    filterCol = search.getJSONObject(i);
                                                    field = filterCol.get(PROP_NAME_SORT_FIELD).toString().trim();
                                                    operator = filterCol.get("operator").toString().trim();
                                                    type = filterCol.get("type").toString().trim();
                                                    if (!data.containsKey(field)) break block20;
                                                    if (!StringUtil.equalsIgnoreCase(type, "int")) break block21;
                                                    colValue2 = Integer.parseInt(StringUtil.trimToEmpty(data.get(field).toString()));
                                                    if (!StringUtil.equalsIgnoreCase(operator, "is")) break block22;
                                                    int filterValue3 = filterCol.getInt("value");
                                                    if (filterValue3 != colValue2) {
                                                        return false;
                                                    }
                                                    break block20;
                                                }
                                                catch (Exception exception) {}
                                            }
                                            if (!StringUtil.equalsIgnoreCase(operator, "between")) break block23;
                                            int start = ((JSONArray)filterCol.get("value")).getInt(0);
                                            int end = ((JSONArray)filterCol.get("value")).getInt(1);
                                            if (colValue2 < start || colValue2 > end) {
                                                return false;
                                            }
                                            break block20;
                                        }
                                        if (!StringUtil.equalsIgnoreCase(operator, "less")) break block24;
                                        int filterValue4 = filterCol.getInt("value");
                                        if (colValue2 >= filterValue4) {
                                            return false;
                                        }
                                        break block20;
                                    }
                                    if (StringUtil.equalsIgnoreCase(operator, "more") && colValue2 <= (filterValue2 = filterCol.getInt("value"))) {
                                        return false;
                                    }
                                    break block20;
                                }
                                if (!StringUtil.equalsIgnoreCase(type, "text")) break block20;
                                filterValue = filterCol.getString("value");
                                colValue = StringUtil.trimToEmpty(data.get(field).toString());
                                if (!StringUtil.equalsIgnoreCase(operator, "is")) break block25;
                                if (!StringUtil.equalsIgnoreCase(colValue, filterValue)) {
                                    return false;
                                }
                                break block20;
                            }
                            if (!StringUtil.equalsIgnoreCase(operator, "begins")) break block26;
                            if (!colValue.toUpperCase().startsWith(filterValue.toUpperCase())) {
                                return false;
                            }
                            break block20;
                        }
                        if (!StringUtil.equalsIgnoreCase(operator, "contains")) break block27;
                        if (!colValue.toUpperCase().contains(filterValue.toUpperCase())) {
                            return false;
                        }
                        break block20;
                    }
                    if (StringUtil.equalsIgnoreCase(operator, "ends") && !colValue.toUpperCase().endsWith(filterValue.toUpperCase())) {
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    private Properties parseUrl(String url) {
        String[] parametersArray;
        Properties parameters = new Properties();
        if (url == null || (url = url.trim()).length() == 0) {
            return parameters;
        }
        String parametersStr = FilterUtil.subString(url, "?", null);
        if (parametersStr == null || parametersStr.length() == 0) {
            return parameters;
        }
        String[] stringArray = parametersArray = parametersStr.split("&");
        int n = parametersArray.length;
        int n2 = 0;
        while (n2 < n) {
            String parameterStr = stringArray[n2];
            int index = parameterStr.indexOf("=");
            if (index > 0) {
                String name = parameterStr.substring(0, index);
                String value = parameterStr.substring(index + 1);
                parameters.put(name, value);
            }
            ++n2;
        }
        return parameters;
    }

    private List<Map<String, Object>> comparatorOrderBy(List<Map<String, Object>> array, Properties params) {
        int rowCount;
        int pageCount;
        if (array == null) {
            array = new ArrayList<Map<String, Object>>();
        }
        String orderBy = DEFAULT_ORDERBY;
        String orderType = DEFAULT_ORDER_TYPE;
        Integer pageNum = 1;
        Integer pageSize = Integer.MAX_VALUE;
        if (params != null) {
            String str;
            if (params.containsKey(PROP_NAME_SORT_FIELD)) {
                orderBy = StringUtil.trimToEmpty(params.get(PROP_NAME_SORT_FIELD).toString());
            }
            if (params.containsKey(PROP_NAME_SORT_TYPE)) {
                orderType = StringUtil.trimToEmpty(params.get(PROP_NAME_SORT_TYPE).toString());
            }
            if (params.containsKey(PROP_NAME_PAGE_NUM) && (str = StringUtil.trimToEmpty(params.get(PROP_NAME_PAGE_NUM).toString())) != null && str.length() != 0) {
                pageNum = Integer.parseInt(str);
            }
            if (params.containsKey(PROP_NAME_PAGE_SIZE) && (str = StringUtil.trimToEmpty(params.get(PROP_NAME_PAGE_SIZE).toString())) != null && str.length() > 0) {
                pageSize = Integer.parseInt(str);
            }
        }
        int n = pageCount = (pageCount = (int)Math.ceil((double)(rowCount = array.size()) * 1.0 / (double)pageSize.intValue())) < 1 ? 1 : pageCount;
        if (pageNum > pageCount) {
            pageNum = pageCount;
        }
        if (array.size() > 0) {
            if (StringUtil.isNotEmpty(orderBy)) {
                Collections.sort(array, new MapComparator(orderBy, !DEFAULT_ORDER_TYPE.equals(orderType)));
            }
            int fromIndex = (pageNum - 1) * pageSize;
            int toIndex = pageNum * pageSize;
            if (toIndex > rowCount) {
                toIndex = rowCount;
            }
            array = array.subList(fromIndex, toIndex);
        }
        this.resetPageInfo(params, rowCount, pageCount, pageNum);
        return array;
    }

    private List<Map<String, Object>> getConnStatList(Properties params) {
        ArrayList<Map<String, Object>> array = new ArrayList<Map<String, Object>>();
        Map<String, ConnectionStat> connStatMap = jdbcStat.getConnStatMap();
        String id = null;
        if (params.containsKey(PROP_NAME_DATASOURCE_ID)) {
            id = params.get(PROP_NAME_DATASOURCE_ID).toString();
        }
        for (ConnectionStat connStat : connStatMap.values()) {
            try {
                Map<String, Object> data = connStat.getData();
                long connCount = (Long)data.get("ConnCount");
                if (connCount == 0L) continue;
                if (StringUtil.isNotEmpty(id)) {
                    if (!id.equalsIgnoreCase(connStat.getId())) continue;
                    array.add(data);
                    break;
                }
                if (!this.filterStatData(data, params)) continue;
                array.add(data);
            }
            catch (Exception exception) {}
        }
        return array;
    }

    private List<Map<String, Object>> getConnStatDetailList(Properties params) {
        ArrayList<Map<String, Object>> array = new ArrayList<Map<String, Object>>();
        ConnectionStat data = null;
        Map<String, ConnectionStat> connStatMap = jdbcStat.getConnStatMap();
        String id = null;
        if (params.containsKey(PROP_NAME_DATASOURCE_ID)) {
            id = params.get(PROP_NAME_DATASOURCE_ID).toString();
        }
        if (StringUtil.isNotEmpty(id)) {
            for (ConnectionStat connStat : connStatMap.values()) {
                try {
                    if (!id.equals(connStat.getId())) continue;
                    data = connStat;
                    break;
                }
                catch (Exception exception) {}
            }
            if (data != null) {
                ConnectionStatValue dataValue = data.getValue(false);
                HashMap<String, Object> map = new HashMap<String, Object>(2);
                map.put("name", "\u6570\u636e\u6e90");
                map.put("value", dataValue.getUrl());
                array.add(map);
                map = new HashMap(2);
                map.put("name", "\u603b\u4f1a\u8bdd\u6570");
                map.put("value", dataValue.getConnCount());
                array.add(map);
                map = new HashMap(2);
                map.put("name", "\u6d3b\u52a8\u4f1a\u8bdd\u6570");
                map.put("value", dataValue.getActiveConnCount());
                array.add(map);
                map = new HashMap(2);
                map.put("name", "\u6d3b\u52a8\u4f1a\u8bdd\u6570\u5cf0\u503c");
                map.put("value", dataValue.getMaxActiveConnCount());
                array.add(map);
                map = new HashMap(2);
                map.put("name", "\u603b\u53e5\u67c4\u6570");
                map.put("value", dataValue.getStmtCount());
                array.add(map);
                map = new HashMap(2);
                map.put("name", "\u6d3b\u52a8\u53e5\u67c4\u6570");
                map.put("value", dataValue.getActiveStmtCount());
                array.add(map);
                map = new HashMap(2);
                map.put("name", "\u6d3b\u52a8\u53e5\u67c4\u6570\u5cf0\u503c");
                map.put("value", dataValue.getMaxActiveStmtCount());
                array.add(map);
                map = new HashMap(2);
                map.put("name", "\u6267\u884c\u6b21\u6570");
                map.put("value", dataValue.getExecuteCount());
                array.add(map);
                map = new HashMap(2);
                map.put("name", "\u6267\u884c\u51fa\u9519\u6b21\u6570");
                map.put("value", dataValue.getErrorCount());
                array.add(map);
                map = new HashMap(2);
                map.put("name", "\u63d0\u4ea4\u6b21\u6570");
                map.put("value", dataValue.getCommitCount());
                array.add(map);
                map = new HashMap(2);
                map.put("name", "\u56de\u6eda\u6b21\u6570");
                map.put("value", dataValue.getRollbackCount());
                array.add(map);
                map = new HashMap(2);
                map.put("name", "\u5c5e\u6027");
                map.put("value", dataValue.getProperties().replaceAll(StringUtil.LINE_SEPARATOR, "<br>"));
                array.add(map);
            }
        }
        return array;
    }

    private List<Map<String, Object>> getSqlStatDetailList(Properties params) {
        ArrayList<Map<String, Object>> array = new ArrayList<Map<String, Object>>();
        Map<String, ConnectionStat> connStatMap = jdbcStat.getConnStatMap();
        SqlStat data = null;
        String sqlId = null;
        String dsId = null;
        if (params.containsKey(PROP_NAME_SQL_ID)) {
            sqlId = params.get(PROP_NAME_SQL_ID).toString();
        }
        if (params.containsKey(PROP_NAME_DATASOURCE_ID)) {
            dsId = params.get(PROP_NAME_DATASOURCE_ID).toString();
        }
        if (StringUtil.isNotEmpty(sqlId) && StringUtil.isNotEmpty(dsId)) {
            block4: for (ConnectionStat connStat : connStatMap.values()) {
                if (!dsId.equals(connStat.getId())) continue;
                Map<String, SqlStat> sqlStatMap = connStat.getSqlStatMap();
                for (SqlStat sqlStat : sqlStatMap.values()) {
                    try {
                        if (!sqlId.equals(sqlStat.getId())) continue;
                        data = sqlStat;
                        break block4;
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (data != null) {
            try {
                array.add(data.getData());
            }
            catch (JMException jMException) {}
        }
        return array;
    }
}

