function getDefaultPostData()
{
	return {
            pageNum : 1, 
            pageSize : 20,
            pageCount : 1,
            totalRowCount : 0,
            flushFreq: 0
        };
}

//加载表格页面后重置页号和总页数,返回自动刷新定时器id
function afterParser(w2uiGrid, data, flusherId) {
	w2uiGrid.postData['pageCount'] = parseInt(data["pageCount"]);
	w2uiGrid.postData['pageNum'] = parseInt(data["pageNum"]);
	w2uiGrid.postData['totalRowCount'] = parseInt(data["totalRowCount"]);
	if((w2uiGrid.postData['flushFreq'] <= 0) && (data["flushFreq"] !== undefined))
	{
		w2uiGrid.postData['flushFreq'] = parseInt(data["flushFreq"]);
		if(w2uiGrid.postData['flushFreq'] > 0 && flusherId === null)
		{
			flusherId = window.setInterval(refreshGrid, w2uiGrid.postData['flushFreq'] * 1000, w2uiGrid); 
		}
	}
	return flusherId;
}

function reloadBase (w2uiGrid, callBack) {
    var url  = (typeof w2uiGrid.url != 'object' ? w2uiGrid.url : w2uiGrid.url.get);
    w2uiGrid.selectionSave();
    if (url) {
        // need to remember selection (not just last.selection object)
    	w2uiGrid.load(url, function () {
    		w2uiGrid.selectionRestore();
            if (typeof callBack == 'function') callBack();
        });
    } else {
    	w2uiGrid.reset(true);
    	w2uiGrid.localSearch();
    	w2uiGrid.selectionRestore();
        if (typeof callBack == 'function') callBack({ status: 'success' });
    }
}

function refreshGrid(w2uiGrid)
{
	reloadBase(w2uiGrid, function ()
			{
				expandAll(w2uiGrid);
			});
	
}

function expandAll(w2uiGrid)
{
	for(var i = 0; i < w2uiGrid.records.length; i++)
	{
		if (w2uiGrid.records[i] !== undefined && w2uiGrid.records[i].hasChildren)	
		{
			w2uiGrid.expand(w2uiGrid.records[i].recid);
		}
	}
	
}

// 转到表格第一页
function firstPage(w2uiGrid) {
	w2uiGrid.postData['pageNum'] = 1;
	w2uiGrid.reload();
}

// 转到表格前一页
function previousPage(w2uiGrid) {
	if (w2uiGrid.postData['pageNum'] > 1) {
		w2uiGrid.postData['pageNum'] = w2uiGrid.postData['pageNum'] - 1;
	} else {
		w2uiGrid.postData['pageNum'] = 1;
	}
	w2uiGrid.reload();
}

// 转到表格下一页
function nextPage(w2uiGrid) {
	if (w2uiGrid.postData['pageNum'] < w2uiGrid.postData['pageCount']) {
		w2uiGrid.postData['pageNum'] = w2uiGrid.postData['pageNum'] + 1;
	} else {
		w2uiGrid.postData['pageNum'] = w2uiGrid.postData['pageCount'];
	}
	w2uiGrid.reload();
}

// 转到表格最后一页
function lastPage(w2uiGrid) {
	w2uiGrid.postData['pageNum'] = w2uiGrid.postData['pageCount'];
	w2uiGrid.reload();
}

// 按回车时表格跳转到指定的页
function turnToPage(w2uiGrid, pageNumStr, event) {
	if (event.keyCode == 13) {
		var pageNum = parseInt(pageNumStr.trim());
		if (pageNum < 1) {
			pageNum = 1;
		} else if (pageNum > w2ui.grid.postData['pageCount']) {
			pageNum = w2ui.grid.postData['pageCount'];
		}

		w2uiGrid.postData['pageNum'] = pageNum;
		w2uiGrid.reload();
	}
}

//创建表格下方页脚
function createFooter(w2uiGrid) {
	var pageNum = '';
	var pageCount = '';
	var pageSize = '';
	var rowCount = '';
	var firstPageImg = "first_page.png";
	var previousImg = "previous.png";
	var lastPageImg = "last_page.png";
	var nextImg = "next.png";
	if (w2uiGrid != undefined) {
		pageNum = w2uiGrid.postData['pageNum'];
		pageCount = w2uiGrid.postData['pageCount'];
		pageSize = w2uiGrid.postData['pageSize'];
		rowCount = w2uiGrid.postData['totalRowCount'];
		if (pageNum === 1)
		{
			firstPageImg = "first_page_disabled.png";
			previousImg = "previous_disabled.png";
		}
		if (pageNum === pageCount)
		{
			lastPageImg = "last_page_disabled.png";
			nextImg = "next_disabled.png";
		}
	}
	return '<div>'
			+ '	 <div class="w2ui-footer-expend-left" >'
			+ '	 <img src="img/' + firstPageImg + '" style="cursor:pointer" onClick="firstPage(w2ui.grid)">'
			+ '	 <img src="img/' + previousImg + '" style="cursor:pointer"  onClick="previousPage(w2ui.grid)">'
			+ '	 <input id="page_num" type="text" class="text" value="' + pageNum + '" style="width:60px;text-align:right;" onkeyup="javascript:permitNumber(this);" onafterpaste="javascript:permitNumber(this);" onKeyPress="javascript:turnToPage(w2ui.grid, this.value, event);">'
			+ '  <label id="page_count" >/' + pageCount + '</label>'
			+ '	 <img src="img/' + nextImg + '" style="cursor:pointer"  onClick="nextPage(w2ui.grid)">'
			+ '	 <img src="img/' + lastPageImg + '" style="cursor:pointer"  onClick="lastPage(w2ui.grid)">'
			+ '  <label id="info">  (共' + rowCount + '行, 每页' + pageSize + '行)</label>'
			+ '  </div>'
			+ '</div>';
}

//获取列值
function getCellValueBase(w2uiGrid, ind, col_ind, summary) {
    var col    = w2uiGrid.columns[col_ind];
    var record = (summary !== true ? w2uiGrid.records[ind] : w2uiGrid.summary[ind]);
    var data   = w2uiGrid.parseField(record, col.field);
    if (record && record.w2ui && record.w2ui.changes && record.w2ui.changes[col.field] != null) {
        data = record.w2ui.changes[col.field];
    }
    if ($.isPlainObject(data) /*&& col.editable*/) {    //It can be an object btw
        if (col.options && col.options.items) {
                val=col.options.items.find(function(item){ return item.id==data.id});
                if (val) data=val.text;
                else data=data.id;
        } else {
                if (data.text != null) data = data.text;
                if (data.id != null) data = data.id;
        }
    }
    if (data == null) data = '';
    return data;
}

// 输入框限制只能输入数字
function permitNumber(input) {
	input.value = input.value.replace(/\D/g, '');
}

//返回上一页
function turnBack()
{
	window.history.go(-1);
}

//转到数据源详情页面
function turnToDataSourceDetail(dsId)
{
	window.location.href = "dataSourceDetail.html?dataSourceId=" + dsId;
}

//转到SQL详情页面
function turnToSqlDetail(dsId, sqlId)
{
	window.location.href = "sqlDetail.html?dataSourceId=" + dsId + "&sqlId=" + sqlId;	
}

//链接样式
function linkStyle(value, jsFunc)
{
	return "<a style=\"cursor:pointer\" onclick=\""+ jsFunc + "\" href=\"javascript:void(0);\">" + value + "</a>"
}

function parseUrl() {
    var data = {};
    var url = window.location.href;
    if (url.indexOf('?') > 0) {
        url = url.substring(url.indexOf('?') + 1);
        var params = url.split("&");
        var param;
        var str;
        for(var i = 0; i< params.length; i++)
        {
            param = params[i];
            str = param.split("=");
            if (str.length == 2)
            {
                data[str[0].trim()] = str[1].trim();
            }

        }
    }
    return data;
}
