package BP.Sys;

import BP.DA.*;
import BP.Difference.SystemConfig;
import BP.En.*;
import BP.En.Map;

import java.util.*;
import java.io.*;

public class SysDocFile extends EntityMyPK
{

		///#region 实现基本属性
	public final String getEnName() throws Exception
	{
		return this.GetValStringByKey(SysDocFileAttr.EnName);
	}
	public final void setEnName(String value) throws Exception
	{
		this.SetValByKey(SysDocFileAttr.EnName, value);
	}
	public final String getRefKey() throws Exception
	{
		return this.GetValStringByKey(SysDocFileAttr.RefKey);
	}
	public final void setRefKey(String value) throws Exception
	{
		this.SetValByKey(SysDocFileAttr.RefKey, value);
	}
	public final String getRefVal() throws Exception
	{
		return this.GetValStringByKey(SysDocFileAttr.RefVal);
	}
	public final void setRefVal(String value) throws Exception
	{
		this.SetValByKey(SysDocFileAttr.RefVal, value);
	}
	public final String getFileName() throws Exception
	{
		return this.GetValStringByKey(SysDocFileAttr.FileName);
	}
	public final void setFileName(String value) throws Exception
	{
		this.SetValByKey(SysDocFileAttr.FileName, value);
	}
	public final int getFileSize() throws Exception
	{
		return this.GetValIntByKey(SysDocFileAttr.FileSize);
	}
	public final void setFileSize(int value) throws Exception
	{
		this.SetValByKey(SysDocFileAttr.FileSize, value);
	}
	public final String getFileType() throws Exception
	{
		return this.GetValStringByKey(SysDocFileAttr.FileType);
	}
	public final void setFileType(String value) throws Exception
	{
		this.SetValByKey(SysDocFileAttr.FileType, value);
	}

		///#endregion


		///#region 字段
	public final String getDocHtml() throws Exception
	{
		return DataType.ParseText2Html(this.getDocText());
	}
	public final String getDocText1()
	{
		return "";
	}
	public final String getDocText() throws Exception
	{
		return this.getD1() + this.getD2() + this.getD3() + this.getD4() + this.getD5() + this.getD6() + this.getD7() + this.getD8() + this.getD9() + this.getD10() + this.getD11() + this.getD12() + this.getD13() + this.getD14() + this.getD15() + this.getD16() + this.getD17() + this.getD18() + this.getD19() + this.getD20();
	}
	public final void setDocText(String value) throws Exception
	{
		int len = value.length();
		this.setFileSize(len);
		int step = 2000;
		int i = 0;
		int idx = -1;
		while (true)
		{
			i++;
			idx++;
			if (len > step * i)
			{
				this.SetValByKey("D" + i, value.substring(step * idx, step * idx + step));
			}
			else
			{
				this.SetValByKey("D" + i, value.substring(step * idx));
				break;
			}
			if (i > 20)
			{
				throw new RuntimeException("数据太大存储不下。");
			}
		}
	}
	public final String getD1() throws Exception
	{
		return this.GetValStrByKey("D1");
	}
	public final void setD1(String value) throws Exception
	{
		this.SetValByKey("D1", value);
	}
	public final String getD2() throws Exception
	{
		return this.GetValStrByKey("D2");
	}
	public final void setD2(String value) throws Exception
	{
		this.SetValByKey("D2", value);
	}
	public final String getD3() throws Exception
	{
		return this.GetValStrByKey("D3");
	}
	public final void setD3(String value) throws Exception
	{
		this.SetValByKey("D3", value);
	}
	public final String getD4() throws Exception
	{
		return this.GetValStrByKey("D4");
	}
	public final void setD4(String value) throws Exception
	{
		this.SetValByKey("D4", value);
	}
	public final String getD5() throws Exception
	{
		return this.GetValStrByKey("D5");
	}
	public final void setD5(String value) throws Exception
	{
		this.SetValByKey("D5", value);
	}
	public final String getD6() throws Exception
	{
		return this.GetValStrByKey("D6");
	}
	public final void setD6(String value) throws Exception
	{
		this.SetValByKey("D6", value);
	}
	public final String getD7() throws Exception
	{
		return this.GetValStrByKey("D7");
	}
	public final void setD7(String value) throws Exception
	{ 
		this.SetValByKey("D7", value);
	}
	public final String getD8() throws Exception
	{
		return this.GetValStrByKey("D8");
	}
	public final void setD8(String value) throws Exception
	{
		this.SetValByKey("D8", value);
	}
	public final String getD9() throws Exception
	{
		return this.GetValStrByKey("D9");
	}
	public final void setD9(String value) throws Exception
	{
		this.SetValByKey("D9", value);
	}

	public final String getD10() throws Exception
	{
		return this.GetValStrByKey("D10");
	}
	public final void setD10(String value) throws Exception
	{
		this.SetValByKey("D10", value);
	}
	public final String getD11() throws Exception
	{
		return this.GetValStrByKey("D11");
	}
	public final void setD11(String value) throws Exception
	{
		this.SetValByKey("D11", value);
	}
	public final String getD12()throws Exception
	{ 
		return this.GetValStrByKey("D12");
	}
	public final void setD12(String value) throws Exception
	{
		this.SetValByKey("D12", value);
	}
	public final String getD13() throws Exception
	{
		return this.GetValStrByKey("D13");
	}
	public final void setD13(String value) throws Exception
	{
		this.SetValByKey("D13", value);
	}
	public final String getD14() throws Exception
	{
		return this.GetValStrByKey("D14");
	}
	public final void setD14(String value) throws Exception
	{
		this.SetValByKey("D14", value);
	}
	public final String getD15() throws Exception
	{
		return this.GetValStrByKey("D15");
	}
	public final void setD15(String value) throws Exception
	{
		this.SetValByKey("D15", value);
	}
	public final String getD16() throws Exception
	{
		return this.GetValStrByKey("D16");
	}
	public final void setD16(String value) throws Exception
	{
		this.SetValByKey("D16", value);
	} 
	public final String getD17() throws Exception
	{
		return this.GetValStrByKey("D17");
	}
	public final void setD17(String value) throws Exception
	{
		this.SetValByKey("D17", value);
	}
	public final String getD18() throws Exception
	{
		return this.GetValStrByKey("D18");
	}
	public final void setD18(String value) throws Exception
	{
		this.SetValByKey("D18", value);
	}
	public final String getD19() throws Exception
	{
		return this.GetValStrByKey("D19");
	}
	public final void setD19(String value) throws Exception
	{
		this.SetValByKey("D19", value);
	}
	public final String getD20() throws Exception
	{
		return this.GetValStrByKey("D20");
	}
	public final void setD20(String value) throws Exception
	{
		this.SetValByKey("D20", value);
	}

		///#endregion


		///#region 构造方法
	public SysDocFile()
	{
	}
	public SysDocFile(String pk) throws Exception
	{
		super(pk);
	}
	/** 
	 注意不初始化数据。
	 
	 @param enName
	 @param key
	 @param val
	*/
	public SysDocFile(String enName, String key, String val) throws Exception
	{
		this.setMyPK(enName + "@" + key + "@" + val);
	}
	@Override
	public Map getEnMap()
	{
		if (this.get_enMap() != null)
		{
			return this.get_enMap();
		}

		Map map = new Map("Sys_DocFile", "备注字段文件管理者");
		map.Java_SetDepositaryOfMap(Depositary.Application);
		map.AddMyPK();

		map.AddTBString(SysDocFileAttr.FileName, null, "名称", false, true, 0, 200, 30);
		map.AddTBInt(SysDocFileAttr.FileSize, 0, "大小", true, true);
		map.AddTBString(SysDocFileAttr.FileType, null, "文件类型", true, true, 0, 50, 20);

		map.AddTBString("D1", null, "D1", true, true, 0, 4000, 20);
		map.AddTBString("D2", null, "D2", true, true, 0, 4000, 20);
		map.AddTBString("D3", null, "D3", true, true, 0, 4000, 20);


		if (map.getEnDBUrl().getDBType() == DBType.Oracle || map.getEnDBUrl().getDBType() == DBType.MSSQL)
		{
			map.AddTBString("D4", null, "D4", true, true, 0, 4000, 20);
			map.AddTBString("D5", null, "D5", true, true, 0, 4000, 20);
			map.AddTBString("D6", null, "D6", true, true, 0, 4000, 20);

			map.AddTBString("D7", null, "D7", true, true, 0, 4000, 20);
			map.AddTBString("D8", null, "D8", true, true, 0, 4000, 20);
			map.AddTBString("D9", null, "D9", true, true, 0, 4000, 20);

			map.AddTBString("D10", null, "D10", true, true, 0, 4000, 20);
			map.AddTBString("D11", null, "D11", true, true, 0, 4000, 20);

			map.AddTBString("D12", null, "D12", true, true, 0, 4000, 20);
			map.AddTBString("D13", null, "D13", true, true, 0, 4000, 20);
			map.AddTBString("D14", null, "D14", true, true, 0, 4000, 20);
			map.AddTBString("D15", null, "D15", true, true, 0, 4000, 20);

			map.AddTBString("D16", null, "D16", true, true, 0, 4000, 20);
			map.AddTBString("D17", null, "D17", true, true, 0, 4000, 20);
			map.AddTBString("D18", null, "D18", true, true, 0, 4000, 20);
			map.AddTBString("D19", null, "D19", true, true, 0, 4000, 20);
			map.AddTBString("D20", null, "D20", true, true, 0, 4000, 20);
		}

		this.set_enMap(map);
		return this.get_enMap();
	}

		///#endregion


		///#region 共用方法 V2.0
	public static String GetValHtmlV2(String enName, String pkVal)
	{
		try
		{
			return BP.DA.DataType.ReadTextFile(SystemConfig.getPathOfFDB() + enName + "\\" + pkVal + ".fdb");
		}
		catch (java.lang.Exception e)
		{
			return null;
		}
	}
	public static String GetValTextV2(String enName, String pkVal)
	{
		  try
		  {
		return BP.DA.DataType.ReadTextFile(SystemConfig.getPathOfFDB() + enName + "\\" + pkVal + ".fdb");
		  }
		  catch (java.lang.Exception e)
		  {
			  return null;
		  }
	}
	public static void SetValV2(String enName, String pkVal, String val)
	{
		try
		{
			String dir = SystemConfig.getPathOfFDB() + enName + "\\";
			if ((new File(dir)).isDirectory() == false)
			{
				(new File(dir)).mkdirs();
			}

			BP.DA.DataType.SaveAsFile(dir + "\\" + pkVal + ".fdb", val);
		}
		catch (RuntimeException ex)
		{
			throw ex;
		}
	}

		///#endregion


		///#region 共用方法
	public static String GetValHtmlV1(String enName, String pkVal) throws Exception
	{
		SysDocFile sdf = new SysDocFile();
		sdf.setMyPK(enName + "@Doc@" + pkVal);
		sdf.RetrieveFromDBSources();
		return sdf.getDocHtml();
	}
	public static String GetValTextV1(String enName, String pkVal) throws Exception
	{
		SysDocFile sdf = new SysDocFile();
		sdf.setMyPK(enName + "@Doc@" + pkVal);
		sdf.RetrieveFromDBSources();
		return sdf.getDocText();
	}
	public static void SetValV1(String enName, String pkVal, String val) throws Exception
	{
		SysDocFile sdf = new SysDocFile();
		sdf.setMyPK(enName + "@Doc@" + pkVal);
		sdf.setFileSize(val.length());
		sdf.setDocText(val);
		sdf.Save();
	}

	public final void UpdateLoadFileOfAccess(String FileName)
	{
		//FileInfo fi = new FileInfo( FileName );// Replace with your file name
		//if (fi.Exists==false)
		//    throw new Exception("文件已经不存在。");

		//this.FileSize=fi.Length.ToString();
		//this.FileName = fi.FullName;
		//this.Name=fi.Name;
		//this.Insert();

		//byte[] bData = null;
		////int nNewFileID = 0;
		//// Read file data into buffer
		//using ( FileStream fs = fi.OpenRead() )
		//{
		//    bData = new byte[fi.Length];
		//    int nReadLength = fs.Read( bData,0, (int)(fi.Length) );
		//}

		////			// Add file info into DB
		////			string strQuery = "INSERT INTO FileInfo " 
		////				+ " ( FileName, FullName, FileData ) "
		////				+ " VALUES "
		////				+ " ( @FileName, @FullName, @FileData ) "
		////				+ " SELECT @@IDENTITY AS 'Identity'";

		//string strQuery="UPDATE Sys_FileManager SET FileData=@FileData WHERE OID="+this.OID;
		//OleDbConnection conn = (OleDbConnection)BP.DA.DBAccess.GetAppCenterDBConn ;
		//conn.Open();

		//OleDbCommand sqlComm = new OleDbCommand( strQuery, 
		//    conn);

		////sqlComm.Parameters.Add( "@FileName", fi.Name );
		////sqlComm.Parameters.Add( "@FullName", fi.FullName );
		//sqlComm.Parameters.AddWithValue("@FileData", bData);
		//sqlComm.ExecuteNonQuery();

		//// Get new file ID
		////	SqlDataReader sqlReader = sqlComm.ExecuteReader(); 
		////			if( sqlReader.Read() )
		////			{
		////				nNewFileID = int.Parse(sqlReader.GetValue(0).ToString());
		////			}
		////
		////			sqlReader.Close();
		////			sqlComm.Dispose();
		////
		////			if( nNewFileID > 0 )
		////			{
		////				// Add new item in list view
		////				//ListViewItem itmNew = lsvFileInfo.Items.Add( fi.Name );
		////				//itmNew.Tag = nNewFileID;
		////			}
	}

		///#endregion
}