package BP.WF.Template;

import BP.DA.*;
import BP.En.*;
import BP.En.Map;
import BP.WF.*;
import BP.Port.*;
import BP.WF.*;
import java.util.*;

/** 
 任务
*/
public class Task extends EntityMyPK
{

		///#region 属性
	/** 
	 参数
	 * @throws Exception 
	*/
	public final String getParas() throws Exception
	{
		return this.GetValStringByKey(TaskAttr.Paras);
	}
	public final void setParas(String value) throws Exception
	{
		this.SetValByKey(TaskAttr.Paras, value);
	}
	/** 
	 发起人
	 * @throws Exception 
	*/
	public final String getStarter() throws Exception
	{
		return this.GetValStringByKey(TaskAttr.Starter);
	}
	public final void setStarter(String value) throws Exception
	{
		this.SetValByKey(TaskAttr.Starter, value);
	}
	/** 
	 到达的人员
	 * @throws Exception 
	*/
	public final String getToEmps() throws Exception
	{
		return this.GetValStringByKey(TaskAttr.ToEmps);
	}
	public final void setToEmps(String value) throws Exception
	{
		this.SetValByKey(TaskAttr.ToEmps, value);
	}
	/** 
	 到达节点（可以为0）
	 * @throws Exception 
	*/
	public final int getToNode() throws Exception
	{
		return this.GetValIntByKey(TaskAttr.ToNode);
	}
	public final void setToNode(int value) throws Exception
	{
		this.SetValByKey(TaskAttr.ToNode, value);
	}
	/** 
	 流程编号
	 * @throws Exception 
	*/
	public final String getFK_Flow() throws Exception
	{
		return this.GetValStringByKey(TaskAttr.FK_Flow);
	}
	public final void setFK_Flow(String value) throws Exception
	{
		this.SetValByKey(TaskAttr.FK_Flow, value);
	}
	/** 
	 发起时间（可以为空）
	 * @throws Exception 
	*/
	public final String getStartDT() throws Exception
	{
		return this.GetValStringByKey(TaskAttr.StartDT);
	}
	public final void setStartDT(String value) throws Exception
	{
		this.SetValByKey(TaskAttr.StartDT, value);
	}

		///#endregion


		///#region 构造函数
	/** 
	 Task
	*/
	public Task()
	{
	}
	/** 
	 重写基类方法
	*/
	@Override
	public Map getEnMap()
	{
		if (this.get_enMap() != null)
		{
			return this.get_enMap();
		}
		Map map = new Map("WF_Task", "任务");
		map.Java_SetEnType(EnType.Admin);

		map.AddMyPK(); //唯一的主键.
		map.AddTBString(TaskAttr.FK_Flow, null, "流程编号", true, false, 0, 200, 10);
		map.AddTBString(TaskAttr.Starter, null, "发起人", true, false, 0, 200, 10);

			//为上海同事科技增加两个字段. 可以为空.
		map.AddTBInt(TaskAttr.ToNode, 0, "到达的节点", true, false);
		map.AddTBString(TaskAttr.ToEmps, null, "到达人员", true, false, 0, 200, 10);

		map.AddTBString(TaskAttr.Paras, null, "参数", true, false, 0, 4000, 10);

			// TaskSta 0=未发起，1=成功发起，2=发起失败.
		map.AddTBInt(TaskAttr.TaskSta, 0, "任务状态", true, false);

		map.AddTBString(TaskAttr.Msg, null, "消息", true, false, 0, 4000, 10);
		map.AddTBString(TaskAttr.StartDT, null, "发起时间", true, false, 0, 20, 10);
		map.AddTBString(TaskAttr.RDT, null, "插入数据时间", true, false, 0, 20, 10);

		this.set_enMap(map);
		return this.get_enMap();
	}

		///#endregion
}