/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.funtions;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.funtions.FunctionDef;
import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import java.util.LinkedHashMap;
import java.util.Map;

public class FunctionRepository {
    private final DbType dbType;
    private Map<Long, FunctionDef> functions = new LinkedHashMap<Long, FunctionDef>();
    public static final FunctionRepository MY_SQL = new FunctionRepository(DbType.mysql);

    public FunctionRepository(DbType dbType) {
        this.dbType = dbType;
    }

    public void registerFunction(String name, SQLDataType returnType, SQLDataType ... parameterTypes) {
        this.registerFunction(name, false, returnType, parameterTypes);
    }

    public void registerFunction(String name, boolean varArg, SQLDataType returnType, SQLDataType ... parameterTypes) {
        FunctionDef func = new FunctionDef(name, varArg, returnType, parameterTypes);
        this.functions.put(func.nameHash64(), func);
    }

    public FunctionDef find(long hash) {
        return this.functions.get(hash);
    }

    static {
        MY_SQL.registerFunction("concat", true, SQLCharExpr.DEFAULT_DATA_TYPE, SQLCharExpr.DEFAULT_DATA_TYPE);
        MY_SQL.registerFunction("month", false, SQLIntegerExpr.DEFAULT_DATA_TYPE, new SQLDataType[0]);
    }
}

